/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor.quickdiff;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.internal.texteditor.quickdiff.DocumentLineDiffer;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffExtensionsRegistry;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;
import org.eclipse.ui.texteditor.quickdiff.ReferenceProviderDescriptor;

public class QuickDiff {
    public ReferenceProviderDescriptor getDefaultProvider() {
        QuickDiffExtensionsRegistry registry = TextEditorPlugin.getDefault().getQuickDiffExtensionRegistry();
        if (registry != null) {
            return registry.getDefaultProvider();
        }
        return null;
    }

    public List getReferenceProviderDescriptors() {
        QuickDiffExtensionsRegistry registry = TextEditorPlugin.getDefault().getQuickDiffExtensionRegistry();
        if (registry != null) {
            return registry.getReferenceProviderDescriptors();
        }
        return Collections.EMPTY_LIST;
    }

    public IQuickDiffReferenceProvider getReferenceProviderOrDefault(ITextEditor editor, String id) {
        ReferenceProviderDescriptor defaultDescriptor;
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)id);
        List descs = this.getReferenceProviderDescriptors();
        IQuickDiffReferenceProvider provider = null;
        Iterator iter = descs.iterator();
        while (iter.hasNext()) {
            ReferenceProviderDescriptor desc = (ReferenceProviderDescriptor)iter.next();
            if (!desc.getId().equals(id) || (provider = desc.createProvider()) == null) continue;
            provider.setActiveEditor(editor);
            if (provider.isEnabled()) break;
            provider.dispose();
            provider = null;
        }
        if (provider == null && (defaultDescriptor = this.getDefaultProvider()) != null && (provider = defaultDescriptor.createProvider()) != null) {
            provider.setActiveEditor(editor);
            if (!provider.isEnabled()) {
                provider.dispose();
                provider = null;
            }
        }
        return provider;
    }

    public IAnnotationModel createQuickDiffAnnotationModel(ITextEditor editor, String id) {
        IQuickDiffReferenceProvider provider = this.getReferenceProviderOrDefault(editor, id);
        if (provider != null) {
            DocumentLineDiffer differ = new DocumentLineDiffer();
            differ.setReferenceProvider(provider);
            return differ;
        }
        return null;
    }
}

