/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.cleanup;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.cleanup.StructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

abstract class AbstractNodeCleanupHandler
implements IStructuredCleanupHandler {
    protected IStructuredCleanupPreferences fCleanupPreferences = null;
    protected IProgressMonitor fProgressMonitor = null;

    AbstractNodeCleanupHandler() {
    }

    public void setCleanupPreferences(IStructuredCleanupPreferences cleanupPreferences) {
        this.fCleanupPreferences = cleanupPreferences;
    }

    public IStructuredCleanupPreferences getCleanupPreferences() {
        if (this.fCleanupPreferences == null) {
            this.fCleanupPreferences = new StructuredCleanupPreferences();
            Preferences preferences = this.getModelPreferences();
            if (preferences != null) {
                this.fCleanupPreferences.setCompressEmptyElementTags(preferences.getBoolean("compressEmptyElementTags"));
                this.fCleanupPreferences.setInsertRequiredAttrs(preferences.getBoolean("insertRequiredAttrs"));
                this.fCleanupPreferences.setInsertMissingTags(preferences.getBoolean("insertMissingTags"));
                this.fCleanupPreferences.setQuoteAttrValues(preferences.getBoolean("quoteAttrValues"));
                this.fCleanupPreferences.setFormatSource(preferences.getBoolean("formatSource"));
                this.fCleanupPreferences.setConvertEOLCodes(preferences.getBoolean("convertEOLCodes"));
                this.fCleanupPreferences.setEOLCode(preferences.getString("cleanupEOLCode"));
            }
        }
        return this.fCleanupPreferences;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    protected static StructuredDocumentEvent replaceSource(IDOMModel model, Object requester, int offset, int length, String source) {
        StructuredDocumentEvent result = null;
        if (model == null) {
            return result;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return result;
        }
        if (source == null) {
            source = new String();
        }
        if (structuredDocument.containsReadOnly(offset, length)) {
            return result;
        }
        if (requester == null) {
            requester = structuredDocument;
        }
        return structuredDocument.replaceText(requester, offset, length, source);
    }

    protected Preferences getModelPreferences() {
        return HTMLCorePlugin.getDefault().getPluginPreferences();
    }
}

