/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.validation;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.dtd.core.internal.validation.DTDValidationMessages;
import org.eclipse.wst.dtd.core.internal.validation.ElementRefLocation;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class Validator {
    private static Validator _instance = null;
    private URIResolver fResolver = null;

    public static Validator getInstance() {
        if (_instance == null) {
            _instance = new Validator();
        }
        return _instance;
    }

    private Validator() {
    }

    public void setURIResolver(URIResolver uriresolver) {
        this.fResolver = uriresolver;
    }

    public ValidationReport validate(String uri) {
        ValidationInfo valinfo = new ValidationInfo(uri);
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader reader = parser.getXMLReader();
            MultiHandler dtdHandler = new MultiHandler();
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", dtdHandler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", dtdHandler);
            reader.setContentHandler(dtdHandler);
            reader.setDTDHandler(dtdHandler);
            reader.setErrorHandler(new DTDErrorHandler(valinfo));
            reader.setEntityResolver(new DTDEntityResolver(this.fResolver, uri));
            String document = "<!DOCTYPE root SYSTEM \"" + uri + "\"><root/>";
            reader.parse(new InputSource(new StringReader(document)));
            List elemDecls = dtdHandler.getElementDeclarations();
            Hashtable elemRefs = dtdHandler.getElementReferences();
            this.validateElementReferences(elemDecls, elemRefs, valinfo);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
        return valinfo;
    }

    private void validateElementReferences(List elemDecls, Hashtable elemRefs, ValidationInfo valinfo) {
        Enumeration keys = elemRefs.keys();
        while (keys.hasMoreElements()) {
            String elemRef = (String)keys.nextElement();
            if (elemDecls.contains(elemRef)) continue;
            ElementRefLocation elemLoc = (ElementRefLocation)elemRefs.get(elemRef);
            do {
                valinfo.addError(NLS.bind((String)DTDValidationMessages._ERROR_REF_ELEMENT_UNDEFINED, (Object)("'" + elemRef + "'")), elemLoc.getLine(), elemLoc.getColumn(), elemLoc.getURI());
            } while ((elemLoc = elemLoc.getNext()) != null);
        }
    }

    class DTDEntityResolver
    implements EntityResolver {
        private String fBaseLocation = null;
        private URIResolver fURIResolver = null;

        public DTDEntityResolver(URIResolver uriresolver, String baselocation) {
            this.fURIResolver = uriresolver;
            if (this.fURIResolver == null) {
                this.fURIResolver = URIResolverPlugin.createResolver();
            }
            this.fBaseLocation = baselocation;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String location = null;
            location = this.fBaseLocation.equals(systemId) ? systemId : this.fURIResolver.resolve(this.fBaseLocation, publicId, systemId);
            InputSource is = null;
            if (location != null && !location.equals("")) {
                try {
                    String physical = this.fURIResolver.resolvePhysicalLocation(this.fBaseLocation, publicId, location);
                    URL url = new URL(physical);
                    is = new InputSource(location);
                    is.setByteStream(url.openStream());
                }
                catch (MalformedURLException e) {
                    throw new IOException(e.getMessage());
                }
                catch (Exception exception) {}
            }
            return is;
        }
    }

    class DTDErrorHandler
    implements ErrorHandler {
        private final int ERROR = 0;
        private final ValidationInfo fValidationInfo;
        private final int WARNING = 1;

        public DTDErrorHandler(ValidationInfo valinfo) {
            this.fValidationInfo = valinfo;
        }

        protected void addValidationMessage(SAXParseException exception, int severity) {
            if (exception.getSystemId() != null) {
                if (severity == 1) {
                    this.fValidationInfo.addWarning(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId());
                } else {
                    this.fValidationInfo.addError(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId());
                }
            }
        }

        public void error(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 1);
        }
    }

    class MultiHandler
    extends DefaultHandler
    implements DTDHandler,
    ContentHandler,
    LexicalHandler,
    DeclHandler {
        private static final String ELEMENT_MODIFIERS = "*+?";
        private static final String MODEL_DELIMITERS = ",()| ";
        private List fElemDecls = new ArrayList();
        private Hashtable fElemRefs = new Hashtable();
        private List fIgnoreElemModel = new ArrayList();
        private List fIgnoreElemRefs = new ArrayList();
        private Locator fLocator = null;

        public MultiHandler() {
            this.fIgnoreElemRefs.add("#PCDATA");
            this.fIgnoreElemModel.add("ANY");
            this.fIgnoreElemModel.add("EMPTY");
        }

        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        }

        public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void elementDecl(String name, String model) throws SAXException {
            this.fElemDecls.add(name);
            if (this.fIgnoreElemModel.contains(model)) {
                return;
            }
            int line = this.fLocator.getLineNumber();
            int column = this.fLocator.getColumnNumber();
            String uri = this.fLocator.getSystemId();
            StringTokenizer strtok = new StringTokenizer(model, MODEL_DELIMITERS);
            while (strtok.hasMoreTokens()) {
                int tokenlength;
                String token = strtok.nextToken();
                if (ELEMENT_MODIFIERS.indexOf(token.charAt((tokenlength = token.length()) - 1)) != -1 && (token = token.substring(0, tokenlength - 1)).length() == 0 || this.fIgnoreElemRefs.contains(token)) continue;
                ElementRefLocation elemLoc = (ElementRefLocation)this.fElemRefs.get(token);
                ElementRefLocation tokenLoc = new ElementRefLocation(line, column, uri, elemLoc);
                this.fElemRefs.put(token, tokenLoc);
            }
        }

        public void endCDATA() throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String arg0) throws SAXException {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public List getElementDeclarations() {
            return this.fElemDecls;
        }

        public Hashtable getElementReferences() {
            return this.fElemRefs;
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.fLocator = locator;
        }

        public void startCDATA() throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }
    }
}

