/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.core.uri.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.wst.command.internal.env.core.uri.file.FileScheme;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.uri.RelativeURI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIException;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIFilter;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIScheme;

public class FileURI
extends RelativeURI {
    private File file_ = null;

    public FileURI(String uri) {
        super(uri);
        if (this.getURIScheme().isValid(this)) {
            this.file_ = new File(uri.substring(5, uri.length()));
        }
    }

    public File asFile() {
        return this.file_;
    }

    public void erase() throws URIException {
        this.deleteFile(this.file_);
    }

    private void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int index = 0;
            while (index < children.length) {
                File child = children[index];
                if (child.isDirectory()) {
                    this.deleteFile(child);
                } else {
                    child.delete();
                }
                ++index;
            }
        }
        file.delete();
    }

    public InputStream getInputStream() throws URIException {
        FileInputStream stream = null;
        try {
            File parent = this.file_.getParentFile();
            parent.mkdirs();
            stream = new FileInputStream(this.file_);
        }
        catch (IOException exc) {
            SimpleStatus status = new SimpleStatus("", exc.getMessage(), 4, exc);
            throw new URIException(status, this);
        }
        return stream;
    }

    public OutputStream getOutputStream() throws URIException {
        FileOutputStream stream = null;
        try {
            File parent = this.file_.getParentFile();
            parent.mkdirs();
            stream = new FileOutputStream(this.file_);
        }
        catch (IOException exc) {
            SimpleStatus status = new SimpleStatus("", exc.getMessage(), 4, exc);
            throw new URIException(status, this);
        }
        return stream;
    }

    public URIScheme getURIScheme() {
        return new FileScheme();
    }

    public boolean isAvailableAsFile() {
        return this.file_ != null;
    }

    public boolean isAvailableAsURL() {
        return true;
    }

    public boolean isLeaf() {
        return this.file_.isFile();
    }

    public boolean isPresent() {
        return this.file_.exists();
    }

    public boolean isReadable() {
        return this.file_.canRead();
    }

    public boolean isWritable() {
        return this.file_.canWrite();
    }

    public URI[] list() throws URIException {
        File[] children = this.file_.listFiles();
        URI[] URIs = new URI[]{};
        if (children != null) {
            int length = children.length;
            URIs = new URI[length];
            int index = 0;
            while (index < length) {
                URIs[index] = new FileURI("file:" + children[index].getAbsolutePath());
                ++index;
            }
        }
        return URIs;
    }

    public URI[] list(URIFilter uriFilter) throws URIException {
        File[] children = this.file_.listFiles();
        int length = children == null ? 0 : children.length;
        Vector<FileURI> URIs = new Vector<FileURI>();
        int index = 0;
        while (index < length) {
            FileURI newURI = new FileURI("file:" + children[index].getAbsolutePath());
            if (uriFilter.accepts(newURI)) {
                URIs.add(newURI);
            }
            ++index;
        }
        return URIs.toArray(new URI[0]);
    }

    public void rename(URI newURI) throws URIException {
        this.uri_ = newURI.toString();
        this.file_.renameTo(new File(this.uri_));
    }

    public void touchFolder() throws URIException {
        this.file_.mkdirs();
    }

    public void touchLeaf() throws URIException {
        try {
            File parent = this.file_.getParentFile();
            parent.mkdirs();
            this.file_.createNewFile();
        }
        catch (IOException exc) {
            SimpleStatus status = new SimpleStatus("", exc.getMessage(), 4, exc);
            throw new URIException(status, this);
        }
    }

    private class Dummy {
        Dummy() {
        }
    }
}

