/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.web.internal.ResourceHandler;
import org.eclipse.wst.web.internal.SimpleWebNatureRuntimeUtilities;
import org.eclipse.wst.web.internal.WebPropertiesUtil;
import org.eclipse.wst.web.internal.operation.IStaticWebNature;
import org.eclipse.wst.web.ui.internal.wizards.SimpleContextRootComposite;

public class SimpleWebSettingsPropertiesPage
extends PropertyPage {
    private Text contextRootField = null;
    private Text fWebContentNameField = null;
    private SimpleContextRootComposite staticContextRoot = null;
    private String oldContextRoot = null;
    private String fOldWebContentName = null;
    private IProject fProject = null;

    protected Control createContents(Composite parent) {
        Label retVal = null;
        this.fProject = this.getWebProject();
        if (this.fProject != null) {
            IStaticWebNature webNature = SimpleWebNatureRuntimeUtilities.getRuntime((IProject)this.fProject);
            if (webNature != null) {
                this.updateFields(webNature);
                Composite containerGroup = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                containerGroup.setLayout((Layout)layout);
                containerGroup.setLayoutData((Object)new GridData(768));
                Listener listener = new Listener(){

                    public void handleEvent(Event e) {
                        SimpleWebSettingsPropertiesPage.this.validateFields();
                    }
                };
                this.createStaticControls(containerGroup, listener);
                retVal = containerGroup;
            } else {
                Label closedProjectLabel = new Label(parent, 0);
                closedProjectLabel.setText(ResourceHandler.getString((String)"StaticWebSettingsPropertiesPage.Not_available_for_closed_projects"));
                retVal = closedProjectLabel;
            }
        }
        return retVal;
    }

    public void createControl(Composite parent) {
        this.fProject = this.getWebProject();
        if (this.fProject != null && this.fProject.isOpen()) {
            super.createControl(parent);
        } else {
            Label closedProjectLabel = new Label(parent, 0);
            closedProjectLabel.setText(ResourceHandler.getString((String)"StaticWebSettingsPropertiesPage.Not_available_for_closed_projects"));
            this.setControl((Control)closedProjectLabel);
        }
    }

    protected void createStaticControls(Composite parent, Listener listener) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.etools.webtools.webp1100");
        IStaticWebNature webNature = SimpleWebNatureRuntimeUtilities.getRuntime((IProject)this.fProject);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        data.heightHint = 15;
        this.staticContextRoot = new SimpleContextRootComposite(parent);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.staticContextRoot.setLayoutData(data);
        this.staticContextRoot.setContextRoot(webNature.getContextRoot());
        this.staticContextRoot.addModifyListener(listener);
        Label webContentNameLabel = new Label(parent, 32);
        webContentNameLabel.setText(ResourceHandler.getString((String)"StaticWebSettingsPropertiesPage.Web_Content_Label"));
        this.fWebContentNameField = new Text(parent, 2048);
        data = new GridData(768);
        this.fWebContentNameField.setLayoutData((Object)data);
        this.fWebContentNameField.setText(this.fOldWebContentName);
        this.fWebContentNameField.addListener(24, listener);
    }

    public String getStaticContextRoot() {
        return this.staticContextRoot != null ? this.staticContextRoot.getContextRoot() : null;
    }

    public String getWebContentName() {
        return this.fWebContentNameField != null ? this.fWebContentNameField.getText() : null;
    }

    protected void validateFields() {
        String msg = WebPropertiesUtil.validateContextRoot((String)this.getStaticContextRoot());
        if (msg != null) {
            this.setValid(false);
            this.setErrorMessage(msg);
        } else {
            this.setValid(true);
            this.setErrorMessage(null);
        }
    }

    private IProject getWebProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    private boolean hasStaticContextRootChanged() {
        if (this.oldContextRoot == null) {
            return true;
        }
        return !this.oldContextRoot.equals(this.getStaticContextRoot());
    }

    private boolean hasWebContentNameChanged() {
        if (this.fOldWebContentName == null) {
            return true;
        }
        return !this.fOldWebContentName.equals(this.getWebContentName());
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.contextRootField != null) {
            this.contextRootField.setText(this.oldContextRoot);
        }
        if (this.fWebContentNameField != null) {
            this.fWebContentNameField.setText(this.fOldWebContentName);
        }
        if (this.staticContextRoot != null) {
            this.staticContextRoot.setContextRoot(this.oldContextRoot);
        }
    }

    public boolean performOk() {
        boolean retVal = true;
        try {
            if (this.hasUpdatedStaticInformation()) {
                IStaticWebNature nature = SimpleWebNatureRuntimeUtilities.getRuntime((IProject)this.fProject);
                if (!this.oldContextRoot.equals(this.getStaticContextRoot())) {
                    nature.setContextRoot(this.staticContextRoot.getContextRoot());
                }
                if (!this.fOldWebContentName.equals(this.getWebContentName())) {
                    SimpleWebSettingsPropertiesPage.moveWebContentFolder(this.fProject, this.getWebContentName(), (IProgressMonitor)new NullProgressMonitor());
                    nature.setModuleServerRootName(this.getWebContentName());
                }
            }
        }
        catch (CoreException coreException) {}
        return retVal;
    }

    public static void moveWebContentFolder(IProject project, String webContentName, IProgressMonitor progressMonitor) throws CoreException {
        IStaticWebNature webNature = SimpleWebNatureRuntimeUtilities.getRuntime((IProject)project);
        Path newPath = new Path(webContentName);
        if (!project.exists((IPath)newPath)) {
            IContainer webContentRoot = webNature.getModuleServerRoot();
            webContentRoot.move((IPath)newPath, 3, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
    }

    private void updateFields(IStaticWebNature nature) {
        this.oldContextRoot = nature.getContextRoot();
        this.fOldWebContentName = nature.getModuleServerRootName();
    }

    protected boolean hasUpdatedStaticInformation() {
        return this.hasStaticContextRootChanged() || this.hasWebContentNameChanged();
    }
}

