/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CutAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.IActionWTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.PasteActionOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WTPOperationDataModelUICreator;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;

public class JavaEditOperationPopulator
implements WTPOperationDataModelUICreator {
    public static final String CUT_ID = "org.eclipse.wst.common.generic.Cut";
    public static final String COPY_ID = "org.eclipse.wst.common.generic.Copy";
    public static final String PASTE_ID = "org.eclipse.wst.common.generic.Paste";
    public static final String DELETE_ID = "org.eclipse.wst.common.generic.Delete";
    public static final String RENAME_ID = "org.eclipse.wst.common.generic.Rename";
    private Map javaActionsBySite;

    public WTPOperationDataModel createDataModel(String extendedOperationId, String operationClass, IStructuredSelection selection, IWorkbenchSite site) {
        if (site == null) {
            return null;
        }
        JavaActions actions = this.getActions(site);
        WTPOperationDataModel dataModel = null;
        if (CUT_ID.equals(extendedOperationId)) {
            dataModel = IActionWTPOperationDataModel.createDataModel((Action)actions.cutAction, (IStructuredSelection)selection, (ISelectionProvider)site.getSelectionProvider(), (Shell)site.getShell());
        }
        if (COPY_ID.equals(extendedOperationId)) {
            dataModel = IActionWTPOperationDataModel.createDataModel((Action)actions.copyAction, (IStructuredSelection)selection, (ISelectionProvider)site.getSelectionProvider(), (Shell)site.getShell());
        }
        if (PASTE_ID.equals(extendedOperationId)) {
            dataModel = PasteActionOperationDataModel.createDataModel((Action)actions.pasteAction, (IStructuredSelection)selection, (ISelectionProvider)site.getSelectionProvider(), (Shell)site.getShell());
        }
        if (DELETE_ID.equals(extendedOperationId)) {
            dataModel = IActionWTPOperationDataModel.createDataModel((Action)actions.deleteAction, (IStructuredSelection)selection, (ISelectionProvider)site.getSelectionProvider(), (Shell)site.getShell());
        }
        return dataModel;
    }

    protected JavaActions getActions(IWorkbenchSite site) {
        JavaActions actions = (JavaActions)this.getJavaActionsBySite().get(site);
        if (actions == null) {
            actions = new JavaActions(site);
            this.getJavaActionsBySite().put(site, actions);
        }
        return actions;
    }

    protected Map getJavaActionsBySite() {
        if (this.javaActionsBySite == null) {
            this.javaActionsBySite = new HashMap();
        }
        return this.javaActionsBySite;
    }

    public class JavaActions {
        private IWorkbenchSite fSite;
        private Clipboard fClipboard;
        SelectionDispatchAction deleteAction;
        SelectionDispatchAction copyAction;
        SelectionDispatchAction pasteAction;
        SelectionDispatchAction cutAction;

        public JavaActions(IWorkbenchSite site) {
            this.fSite = site;
            this.fClipboard = new Clipboard(site.getShell().getDisplay());
            this.pasteAction = new PasteAction(this.fSite, this.fClipboard);
            this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
            this.copyAction = new CopyToClipboardAction(this.fSite, this.fClipboard, this.pasteAction);
            this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            this.cutAction = new CutAction(this.fSite, this.fClipboard, this.pasteAction);
            this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
            this.deleteAction = new DeleteAction(this.fSite);
            this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        }

        public void dispose() {
            if (this.fClipboard != null) {
                this.fClipboard.dispose();
                this.fClipboard = null;
            }
        }
    }
}

