/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;

public class ConfigureWorkingSetAction
extends Action {
    private final Shell fParent;
    private WorkingSetModel fWorkingSetModel;

    public ConfigureWorkingSetAction(Shell parent) {
        super(WorkingSetMessages.getString("ConfigureWorkingSetAction.label"));
        this.fParent = parent;
    }

    public void setWorkingSetModel(WorkingSetModel model) {
        this.fWorkingSetModel = model;
    }

    public void run() {
        ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>(Arrays.asList(this.fWorkingSetModel.getAllWorkingSets()));
        WorkingSetConfigurationDialog dialog = new WorkingSetConfigurationDialog(this.fParent, workingSets.toArray(new IWorkingSet[workingSets.size()]));
        dialog.setSelection(this.fWorkingSetModel.getActiveWorkingSets());
        if (dialog.open() == 0) {
            IWorkingSet[] selection = dialog.getSelection();
            this.fWorkingSetModel.setActiveWorkingSets(selection);
        }
    }
}

