/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.RuntimeServerSelectionDialog;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class RuntimeServerSelectionWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private Text runtime_;
    private Text server_;
    private Text j2eeVersionText;
    private Composite parent_;
    private boolean isClientContext_;
    private TypeRuntimeServer ids_;
    private String j2eeVersion_;
    private MessageUtils msgUtils_;
    private Listener statusListener_;
    private String INFOPOP_PWRS_GROUP_SERVICE_RUNTIME = String.valueOf(this.pluginId_) + ".PWRS0004";
    private String INFOPOP_PWRS_GROUP_SERVICE_SERVER = String.valueOf(this.pluginId_) + ".PWRS0005";
    private String INFOPOP_PWRS_J2EE_VERSION = String.valueOf(this.pluginId_) + ".PWRS0009";

    public RuntimeServerSelectionWidget(boolean isClientScenario) {
        this.isClientContext_ = isClientScenario;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.msgUtils_ = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(this.msgUtils_, this.pluginId_);
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        this.runtime_ = uiUtils.createText(parent, "LABEL_RUNTIMES_LIST", "TOOLTIP_PWRS_TEXT_RUNTIME", this.INFOPOP_PWRS_GROUP_SERVICE_RUNTIME, 8);
        this.server_ = uiUtils.createText(parent, "LABEL_SERVERS_LIST", "TOOLTIP_PWRS_TEXT_SERVER", this.INFOPOP_PWRS_GROUP_SERVICE_SERVER, 8);
        this.j2eeVersionText = uiUtils.createText(parent, "LABEL_J2EE_VERSION", "TOOLTIP_PWRS_J2EE_VERSION", this.INFOPOP_PWRS_J2EE_VERSION, 8);
        Button editButton = new Button(parent, 0);
        editButton.setText(this.msgUtils_.getMessage("LABEL_EDIT_BUTTON"));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RuntimeServerSelectionWidget.this.handleEditButton();
            }
        });
        new Label(parent, 0);
        return this;
    }

    public TypeRuntimeServer getTypeRuntimeServer() {
        return this.ids_;
    }

    public void setTypeRuntimeServer(TypeRuntimeServer ids) {
        this.ids_ = ids;
        this.setLabels();
    }

    public String getJ2EEVersion() {
        return this.j2eeVersion_;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
        this.j2eeVersionText.setText(this.j2eeVersion_ != null ? J2EEUtils.getLabelFromJ2EEVersion((String)this.j2eeVersion_) : this.msgUtils_.getMessage("LABEL_NA"));
    }

    private void setLabels() {
        String runtimeLabel = WebServiceRuntimeExtensionUtils.getRuntimeLabelById(this.ids_.getRuntimeId());
        String serverLabel = null;
        if (this.ids_.getServerInstanceId() == null) {
            String serverId = this.ids_.getServerId();
            if (serverId != null) {
                serverLabel = WebServiceRuntimeExtensionUtils.getServerLabelById(serverId);
            }
        } else {
            String serverInstanceId = this.ids_.getServerInstanceId();
            if (serverInstanceId != null) {
                serverLabel = WebServiceRuntimeExtensionUtils.getServerInstanceLabelFromInstanceId(serverInstanceId);
            }
        }
        runtimeLabel = runtimeLabel == null ? "" : runtimeLabel;
        this.runtime_.setText(runtimeLabel);
        if (serverLabel != null) {
            this.server_.setText(serverLabel);
        }
        this.j2eeVersionText.setText(this.j2eeVersion_ != null ? J2EEUtils.getLabelFromJ2EEVersion((String)this.j2eeVersion_) : this.msgUtils_.getMessage("LABEL_NA"));
    }

    public void handleEditButton() {
        byte mode = this.isClientContext_ ? (byte)1 : 0;
        RuntimeServerSelectionDialog dialog = new RuntimeServerSelectionDialog(this.parent_.getShell(), mode, this.ids_, this.j2eeVersion_);
        dialog.create();
        dialog.handleServerViewSelectionEvent();
        int result = dialog.open();
        if (result == 0) {
            this.ids_ = dialog.getTypeRuntimeServer();
            this.j2eeVersion_ = dialog.getJ2EEVersion();
            this.setLabels();
            this.statusListener_.handleEvent(null);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.runtime_ != null) {
            this.runtime_.addModifyListener(listener);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (this.runtime_ != null) {
            this.runtime_.removeModifyListener(listener);
        }
    }

    public Status getStatus() {
        String serverLabel;
        SimpleStatus status = new SimpleStatus("");
        String scenario = this.isClientContext_ ? this.msgUtils_.getMessage("MSG_CLIENT_SUB") : this.msgUtils_.getMessage("MSG_SERVICE_SUB");
        String runtimeLabel = WebServiceRuntimeExtensionUtils.getRuntimeLabelById(this.ids_.getRuntimeId());
        String string = serverLabel = this.ids_.getServerId() == null ? "" : WebServiceRuntimeExtensionUtils.getServerLabelById(this.ids_.getServerId());
        if (this.ids_.getRuntimeId() == null || runtimeLabel == null || runtimeLabel.equals("")) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_NO_RUNTIME", (Object[])new String[]{scenario}), 4);
        } else if (this.ids_.getServerId() == null || serverLabel.equals("")) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_NO_SERVER", (Object[])new String[]{scenario}), 4);
        }
        if (this.ids_.getServerId() != null && this.ids_.getRuntimeId() != null && this.isClientContext_ && !WebServiceRuntimeExtensionUtils.webServiceClientRuntimeTypeExists(this.ids_.getServerId(), this.ids_.getRuntimeId(), this.ids_.getTypeId())) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_INVALID_SRT_SELECTIONS", (Object[])new String[]{scenario}), 4);
        }
        if (this.ids_.getServerId() != null && this.ids_.getRuntimeId() != null && !this.isClientContext_ && !WebServiceRuntimeExtensionUtils.isServerRuntimeTypeSupported(this.ids_.getServerId(), this.ids_.getRuntimeId(), this.ids_.getTypeId())) {
            status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_INVALID_SRT_SELECTIONS", (Object[])new String[]{scenario}), 4);
        }
        return status;
    }
}

