/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wizard;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeInfo;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUICore;

public class RuntimeServerSelectionDialog
extends Dialog
implements Listener {
    private Shell thisShell;
    private Group viewSelectionGroup_;
    private Text messageBanner_;
    private Composite primaryGroup_;
    private Group runtimesGroup_;
    private Group serversGroup_;
    private Tree runtimesList_;
    private Tree serverList_;
    private Button viewSelectionByRuntimeButton_;
    private Button viewSelectionByServerButton_;
    private Button viewSelectionByExploreButton_;
    private Combo j2eeVersionCombo;
    private String INFOPOP_PWRS_DIALOG = "org.eclipse.jst.ws.consumption.ui.PWRS0001";
    private String INFOPOP_PWRS_LIST_RUNTIMES = "org.eclipse.jst.ws.consumption.ui.PWRS0002";
    private String INFOPOP_PWRS_LIST_SERVERS = "org.eclipse.jst.ws.consumption.ui.PWRS0003";
    private String INFOPOP_PWRS_RADIO_RUNTIME = "org.eclipse.jst.ws.consumption.ui.PWRS0005";
    private String INFOPOP_PWRS_RADIO_SERVER = "org.eclipse.jst.ws.consumption.ui.PWRS0006";
    private String INFOPOP_PWRS_RADIO_EXPLORE = "org.eclipse.jst.ws.consumption.ui.PWRS0007";
    private String INFOPOP_PWRS_J2EE_VERSION = "org.eclipse.jst.ws.consumption.ui.PWRS0009";
    private Hashtable serverLabels_;
    private Hashtable existingServersTable_;
    private String defaultServer_;
    private String defaultRuntime_;
    private String typeId_;
    private String clientTypeId_;
    private WebServiceRuntimeInfo selectedRuntime_;
    private IServer selectedServer_;
    private String selectedServerLabel_;
    private String selectedServerFactoryID_;
    private boolean isExistingServer_;
    private boolean validateOn_ = false;
    private byte selectionMode_;
    private final byte MODE_SERVICE = 0;
    private final byte MODE_CLIENT = 1;
    private final String SERVER_TYPES_ICON = "icons/servers/servers_obj.gif";
    private final String EXISTING_SERVERS_ICON = "icons/servers/existing_server_obj.gif";
    private String j2eeVersion;
    private String serverInstanceID_;

    public RuntimeServerSelectionDialog(Shell shell, byte mode, TypeRuntimeServer ids, String j2eeVersion) {
        super(shell);
        this.selectionMode_ = mode;
        this.typeId_ = ids.getTypeId();
        this.defaultRuntime_ = ids.getRuntimeId();
        this.defaultServer_ = ids.getServerId();
        this.serverInstanceID_ = ids.getServerInstanceId();
        this.setIsExistingServer(ids.getServerInstanceId() != null);
        this.serverLabels_ = new Hashtable();
        this.existingServersTable_ = new Hashtable();
        this.j2eeVersion = j2eeVersion;
    }

    public TypeRuntimeServer getTypeRuntimeServer() {
        TypeRuntimeServer ids = new TypeRuntimeServer();
        ids.setTypeId(this.typeId_);
        if (this.selectedRuntime_ != null) {
            ids.setRuntimeId(this.selectedRuntime_.getId());
        }
        if (this.selectedServerFactoryID_ == null) {
            ids.setServerId(this.defaultServer_);
            ids.setServerInstanceId(this.serverInstanceID_);
        } else {
            ids.setServerId(this.selectedServerFactoryID_);
            if (this.isExistingServer_ && this.selectedServer_ != null) {
                ids.setServerInstanceId(this.selectedServer_.getId());
            }
        }
        return ids;
    }

    public String getJ2EEVersion() {
        return this.j2eeVersion;
    }

    private boolean getIsExistingServer() {
        return this.isExistingServer_;
    }

    private void setIsExistingServer(boolean isExisting) {
        this.isExistingServer_ = isExisting;
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        parent.getShell().pack();
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        this.validateOn_ = false;
        this.thisShell = parent.getShell();
        if (this.thisShell == null) {
            this.thisShell = this.createShell();
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.selectionMode_ == 0) {
            this.thisShell.setText(RuntimeServerSelectionDialog.getMessage("%PAGE_TITLE_WS_RUNTIME_SELECTION"));
        } else {
            this.thisShell.setText(RuntimeServerSelectionDialog.getMessage("%PAGE_TITLE_WS_CLIENT_RUNTIME_SELECTION"));
        }
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.thisShell, this.INFOPOP_PWRS_DIALOG);
        this.messageBanner_ = new Text(composite, 72);
        this.messageBanner_.setText(String.valueOf(RuntimeServerSelectionDialog.getMessage("%PAGE_DESC_WS_RUNTIME_SELECTION")) + "\n" + "      ");
        this.messageBanner_.setToolTipText(RuntimeServerSelectionDialog.getMessage("%PAGE_DESC_WS_RUNTIME_SELECTION"));
        GridData gd = new GridData(768);
        this.messageBanner_.setLayoutData((Object)gd);
        new Label(composite, 256);
        this.thisShell.setToolTipText(RuntimeServerSelectionDialog.getMessage("%TOOLTIP_PWRS_PAGE"));
        this.viewSelectionGroup_ = new Group(composite, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.viewSelectionGroup_.setLayout((Layout)gl);
        gd = new GridData(768);
        this.viewSelectionGroup_.setLayoutData((Object)gd);
        if (this.selectionMode_ == 0) {
            this.viewSelectionGroup_.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_SELECTION_VIEW_TITLE"));
        } else {
            this.viewSelectionGroup_.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_CLIENT_SELECTION_VIEW_TITLE"));
        }
        this.viewSelectionByServerButton_ = new Button((Composite)this.viewSelectionGroup_, 16);
        this.viewSelectionByServerButton_.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_SELECTION_VIEW_SERVER"));
        this.viewSelectionByServerButton_.addListener(13, (Listener)this);
        this.viewSelectionByServerButton_.setToolTipText(RuntimeServerSelectionDialog.getMessage("%TOOLTIP_PWRS_RADIO_SERVER"));
        this.viewSelectionByServerButton_.setSelection(true);
        helpSystem.setHelp((Control)this.viewSelectionByServerButton_, this.INFOPOP_PWRS_RADIO_SERVER);
        this.viewSelectionByRuntimeButton_ = new Button((Composite)this.viewSelectionGroup_, 16);
        this.viewSelectionByRuntimeButton_.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_SELECTION_VIEW_RUNTIME"));
        this.viewSelectionByRuntimeButton_.addListener(13, (Listener)this);
        this.viewSelectionByRuntimeButton_.setToolTipText(RuntimeServerSelectionDialog.getMessage("%TOOLTIP_PWRS_RADIO_RUNTIME"));
        helpSystem.setHelp((Control)this.viewSelectionByRuntimeButton_, this.INFOPOP_PWRS_RADIO_RUNTIME);
        this.viewSelectionByExploreButton_ = new Button((Composite)this.viewSelectionGroup_, 16);
        this.viewSelectionByExploreButton_.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_SELECTION_VIEW_EXPLORE"));
        this.viewSelectionByExploreButton_.addListener(13, (Listener)this);
        this.viewSelectionByExploreButton_.setToolTipText(RuntimeServerSelectionDialog.getMessage("%TOOLTIP_PWRS_RADIO_EXPLORE"));
        helpSystem.setHelp((Control)this.viewSelectionByExploreButton_, this.INFOPOP_PWRS_RADIO_EXPLORE);
        this.primaryGroup_ = new Composite(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 1;
        gl.makeColumnsEqualWidth = true;
        gd = new GridData(1808);
        this.primaryGroup_.setLayout((Layout)gl);
        this.primaryGroup_.setLayoutData((Object)gd);
        this.runtimesGroup_ = new Group(this.primaryGroup_, 0);
        gl = new GridLayout();
        this.runtimesGroup_.setLayout((Layout)gl);
        gd = new GridData(1808);
        this.runtimesGroup_.setLayoutData((Object)gd);
        this.runtimesGroup_.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_RUNTIMES_LIST"));
        this.runtimesList_ = new Tree((Composite)this.runtimesGroup_, 2820);
        gd = new GridData(1808);
        this.runtimesList_.setLayoutData((Object)gd);
        this.runtimesList_.addListener(13, (Listener)this);
        this.runtimesList_.setToolTipText(RuntimeServerSelectionDialog.getMessage("%TOOLTIP_PWRS_LIST_RUNTIMES"));
        helpSystem.setHelp((Control)this.runtimesList_, this.INFOPOP_PWRS_LIST_RUNTIMES);
        this.serversGroup_ = new Group(this.primaryGroup_, 0);
        gl = new GridLayout();
        this.serversGroup_.setLayout((Layout)gl);
        gd = new GridData(1808);
        this.serversGroup_.setLayoutData((Object)gd);
        this.serversGroup_.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_SERVERS_LIST"));
        this.serverList_ = new Tree((Composite)this.serversGroup_, 2820);
        this.serverList_.setLayoutData((Object)new GridData(1808));
        this.serverList_.addListener(13, (Listener)this);
        this.serverList_.setToolTipText(RuntimeServerSelectionDialog.getMessage("%TOOLTIP_PWRS_LIST_SERVERS"));
        ServersList serverList = new ServersList();
        serverList.setServerTreeItems(this.serverList_);
        helpSystem.setHelp((Control)this.serverList_, this.INFOPOP_PWRS_LIST_SERVERS);
        this.setRuntimesGroup();
        Composite j2eeVersionComposite = new Composite(composite, 0);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        gd = new GridData(768);
        j2eeVersionComposite.setLayout((Layout)gl);
        j2eeVersionComposite.setLayoutData((Object)gd);
        Label j2eeVersionLabel = new Label(j2eeVersionComposite, 0);
        j2eeVersionLabel.setText(RuntimeServerSelectionDialog.getMessage("%LABEL_J2EE_VERSION"));
        this.j2eeVersionCombo = new Combo(j2eeVersionComposite, 12);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gd = new GridData(768);
        this.j2eeVersionCombo.setLayout((Layout)gl);
        this.j2eeVersionCombo.setLayoutData((Object)gd);
        this.j2eeVersionCombo.addListener(13, (Listener)this);
        this.j2eeVersionCombo.setToolTipText(RuntimeServerSelectionDialog.getMessage("%TOOLTIP_PWRS_J2EE_VERSION"));
        helpSystem.setHelp((Control)this.j2eeVersionCombo, this.INFOPOP_PWRS_J2EE_VERSION);
        new Label(composite, 256);
        this.validateOn_ = true;
        Dialog.applyDialogFont((Control)parent);
        this.setJ2EEVersions();
        return composite;
    }

    private void setJ2EEVersions() {
        this.j2eeVersionCombo.setEnabled(true);
        this.j2eeVersionCombo.removeAll();
        String[] versions = null;
        if (this.selectedRuntime_ != null) {
            versions = this.selectedRuntime_.getJ2eeLevels();
        }
        if (versions != null) {
            int i;
            this.setJ2EEComboItems(versions);
            this.j2eeVersionCombo.select(0);
            if (this.j2eeVersion != null && (i = this.j2eeVersionCombo.indexOf(J2EEUtils.getLabelFromJ2EEVersion((String)this.j2eeVersion))) > 0) {
                this.j2eeVersionCombo.select(i);
            }
        } else {
            this.j2eeVersionCombo.setEnabled(false);
        }
    }

    private void setJ2EEComboItems(String[] versions) {
        String[] j2eeLabels = new String[versions.length];
        int i = 0;
        while (i < versions.length) {
            String label = J2EEUtils.getLabelFromJ2EEVersion((String)versions[i]);
            j2eeLabels[i] = label != null && label.length() > 0 ? J2EEUtils.getLabelFromJ2EEVersion((String)versions[i]) : RuntimeServerSelectionDialog.getMessage("%LABEL_NA");
            ++i;
        }
        this.j2eeVersionCombo.setItems(j2eeLabels);
    }

    private void setJ2EEVersionBasedOnServer() {
        String[] versions = null;
        if (this.selectedRuntime_ == null || this.selectedServerFactoryID_ == null) {
            return;
        }
        versions = this.selectedRuntime_.getJ2eeLevels();
        if (versions == null) {
            return;
        }
        int i = 0;
        while (i < versions.length) {
            if (this.isServerValid(this.selectedServerFactoryID_, versions[i])) {
                String label = J2EEUtils.getLabelFromJ2EEVersion((String)versions[i]);
                this.j2eeVersionCombo.setText(label);
                this.setJ2EEVersionFromJ2EEVersionCombo();
            }
            ++i;
        }
    }

    private boolean isServerValid(String serverFactoryId, String j2eeVersion) {
        String stJ2EEVersion = ServerUtils.getServerTargetJ2EEVersion((String)j2eeVersion);
        if (stJ2EEVersion == null) {
            return false;
        }
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType != null) {
            IRuntimeType serverRuntime = serverType.getRuntimeType();
            IModuleType[] mTypes = serverRuntime.getModuleTypes();
            int i = 0;
            while (i < mTypes.length) {
                IModuleType mType = mTypes[i];
                String type = mType.getId();
                String moduleVersion = mType.getVersion();
                if (type.equals("j2ee.web") && moduleVersion.equals(stJ2EEVersion)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void validateServerRuntimeSelection() {
        TreeItem[] serverSel;
        String currentSelection;
        TreeItem[] runtimeSel;
        if (this.selectionMode_ == 0) {
            if (this.selectedServerFactoryID_ != null && this.selectedRuntime_ != null) {
                boolean wssrtSupported = WebServiceRuntimeExtensionUtils.isServerRuntimeTypeSupported(this.selectedServerFactoryID_, this.selectedRuntime_.getId(), this.typeId_);
                if (wssrtSupported && WebServiceRuntimeExtensionUtils.isServerSupportedForChosenType(this.typeId_, this.selectedServerFactoryID_)) {
                    this.setOKStatusMessage();
                } else {
                    this.setERRORStatusMessage("%MSG_INVALID_SRT_SELECTIONS");
                }
            }
        } else {
            String clientId = this.typeId_;
            if (this.selectedServerFactoryID_ == null || this.selectedRuntime_ == null || !WebServiceRuntimeExtensionUtils.webServiceClientRuntimeTypeExists(this.selectedServerFactoryID_, this.selectedRuntime_.getId(), clientId)) {
                this.setERRORStatusMessage("%MSG_INVALID_SRT_SELECTIONS");
            } else {
                this.setOKStatusMessage();
            }
        }
        if ((runtimeSel = this.runtimesList_.getSelection()) == null || runtimeSel.length <= 0 || runtimeSel[0].getText().length() == 0) {
            this.disableOKButton();
        }
        String string = currentSelection = (serverSel = this.serverList_.getSelection()) != null && serverSel.length > 0 ? serverSel[0].getText() : "";
        if (serverSel == null || currentSelection.length() == 0) {
            this.disableOKButton();
        }
        if (!this.serverLabels_.containsKey(currentSelection) || !this.existingServersTable_.containsKey(currentSelection)) {
            this.disableOKButton();
            this.setOKStatusMessage();
        }
        if (serverSel.length > 0 && serverSel[0].getItemCount() != 0) {
            this.disableOKButton();
        } else {
            this.enableOKButton();
        }
    }

    private void setOKStatusMessage() {
        this.messageBanner_.setText(RuntimeServerSelectionDialog.getMessage("%PAGE_DESC_WS_RUNTIME_SELECTION"));
        Color black = new Color((Device)this.thisShell.getDisplay(), 0, 0, 0);
        this.messageBanner_.setForeground(black);
        this.enableOKButton();
    }

    private void setERRORStatusMessage(String message) {
        this.messageBanner_.setText(RuntimeServerSelectionDialog.getMessage(message));
        Color red = new Color((Device)this.thisShell.getDisplay(), 255, 0, 0);
        this.messageBanner_.setForeground(red);
        this.disableOKButton();
    }

    private void disableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
    }

    private void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void okPressed() {
        this.setJ2EEVersionFromJ2EEVersionCombo();
        this.setReturnCode(0);
        this.close();
    }

    private void setJ2EEVersionFromJ2EEVersionCombo() {
        String j2eeLabel;
        String j2eeVersionString;
        this.j2eeVersion = this.j2eeVersionCombo.getEnabled() ? ((j2eeVersionString = J2EEUtils.getJ2EEVersionFromLabel((String)(j2eeLabel = this.j2eeVersionCombo.getText()))) != null && j2eeVersionString.length() > 0 ? j2eeVersionString : null) : null;
    }

    public void handleEvent(Event event) {
        if (!this.validateOn_) {
            return;
        }
        this.enableOKButton();
        if (this.viewSelectionByRuntimeButton_ == event.widget) {
            this.handleRuntimeViewSelectionEvent();
            return;
        }
        if (this.viewSelectionByServerButton_ == event.widget) {
            this.handleServerViewSelectionEvent();
            return;
        }
        if (this.viewSelectionByExploreButton_ == event.widget) {
            this.handleExploreViewSelectionEvent();
            return;
        }
        if (this.j2eeVersionCombo == event.widget) {
            this.setJ2EEVersionFromJ2EEVersionCombo();
            return;
        }
        if (this.runtimesList_ == event.widget) {
            TreeItem[] runtimeSel = this.runtimesList_.getSelection();
            this.processRuntimeListSelection(runtimeSel[0].getText());
            this.validateServerRuntimeSelection();
            this.setJ2EEVersions();
            this.setJ2EEVersionBasedOnServer();
        } else if (this.serverList_ == event.widget) {
            this.processServerListSelection();
            this.validateServerRuntimeSelection();
            this.setJ2EEVersionBasedOnServer();
        }
    }

    private void handleRuntimeViewSelectionEvent() {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.makeColumnsEqualWidth = true;
        GridData gd = new GridData(1808);
        this.primaryGroup_.setLayout((Layout)gl);
        this.primaryGroup_.setLayoutData((Object)gd);
        this.primaryGroup_.layout();
    }

    public void handleServerViewSelectionEvent() {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.makeColumnsEqualWidth = true;
        GridData gd = new GridData(1808);
        this.primaryGroup_.setLayout((Layout)gl);
        this.primaryGroup_.setLayoutData((Object)gd);
        this.primaryGroup_.layout();
        this.serversGroup_.setLocation(5, 5);
        this.runtimesGroup_.setLocation(4, 100);
        this.serversGroup_.layout();
        this.runtimesGroup_.layout();
    }

    private void handleExploreViewSelectionEvent() {
        GridLayout gl = (GridLayout)this.primaryGroup_.getLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        GridData gd = new GridData(1808);
        this.primaryGroup_.setLayout((Layout)gl);
        this.primaryGroup_.setLayoutData((Object)gd);
        this.primaryGroup_.layout();
    }

    private void processRuntimeListSelection(String runtimeName) {
        this.selectedRuntime_ = this.selectionMode_ == 0 ? WebServiceRuntimeExtensionUtils.getWebServiceRuntimeByLabel(runtimeName) : WebServiceRuntimeExtensionUtils.getWebServiceRuntimeByLabel(runtimeName);
    }

    private void processServerListSelection() {
        TreeItem[] serverSel = this.serverList_.getSelection();
        if (serverSel != null && serverSel.length > 0) {
            String currentSelection = serverSel[0].getText();
            if (this.serverLabels_.containsKey(currentSelection) || this.existingServersTable_.containsKey(currentSelection)) {
                TreeItem parentItem;
                if (this.existingServersTable_.containsKey(currentSelection)) {
                    this.selectedServer_ = (IServer)this.existingServersTable_.get(currentSelection);
                    this.selectedServerLabel_ = currentSelection;
                    this.selectedServerFactoryID_ = this.selectedServer_.getServerType().getId();
                } else if (this.serverLabels_.containsKey(currentSelection) && (parentItem = serverSel[0].getParentItem()) != null && !parentItem.getText().equalsIgnoreCase(RuntimeServerSelectionDialog.getMessage("%LABEL_TREE_EXISTING_SERVERS"))) {
                    this.selectedServerLabel_ = currentSelection;
                    this.selectedServer_ = null;
                    this.selectedServerFactoryID_ = (String)this.serverLabels_.get(currentSelection);
                }
                parentItem = serverSel[0].getParentItem();
                if (parentItem != null && parentItem.getText().equalsIgnoreCase(RuntimeServerSelectionDialog.getMessage("%LABEL_TREE_EXISTING_SERVERS"))) {
                    this.setIsExistingServer(true);
                } else {
                    this.setIsExistingServer(false);
                }
            } else {
                this.selectedServer_ = null;
                this.selectedServerLabel_ = null;
                this.selectedServerFactoryID_ = null;
                this.setIsExistingServer(false);
                return;
            }
        }
    }

    private static String getMessage(String key) {
        return WebServiceConsumptionUIPlugin.getMessage(key);
    }

    private static String getMessage(String key, Object[] args) {
        return WebServiceConsumptionUIPlugin.getMessage(key, args);
    }

    private void setRuntimesGroup() {
        this.runtimesList_.removeAll();
        String[] runtimes = null;
        runtimes = this.selectionMode_ == 0 ? WebServiceRuntimeExtensionUtils.getRuntimesByType(this.typeId_) : WebServiceRuntimeExtensionUtils.getAllClientRuntimes();
        TreeItem[] runtimeName = new TreeItem[runtimes.length];
        if (runtimes != null) {
            int i = 0;
            while (i < runtimes.length) {
                String runtimeLabel = this.getRuntimeLabel(runtimes[i]);
                runtimeName[i] = new TreeItem(this.runtimesList_, 0);
                runtimeName[i].setText(runtimeLabel);
                if (runtimes[i].equalsIgnoreCase(this.defaultRuntime_)) {
                    this.runtimesList_.setSelection(new TreeItem[]{runtimeName[i]});
                    this.selectedRuntime_ = this.getRuntime(runtimes[i]);
                }
                ++i;
            }
        }
    }

    private String getRuntimeLabel(String type) {
        return this.getRuntime(type).getLabel();
    }

    private WebServiceRuntimeInfo getRuntime(String type) {
        if (this.selectionMode_ == 0) {
            return WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(type);
        }
        return WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(type);
    }

    private String getServerSelectionFactoryId(String selectedServerName) {
        if (this.serverLabels_.containsKey(selectedServerName) && !this.isExistingServer_) {
            return (String)this.serverLabels_.get(selectedServerName);
        }
        return ((IServer)this.existingServersTable_.get(selectedServerName)).getServerType().getId();
    }

    public class ServersList {
        private TreeItem[] existingServersTree;
        private TreeItem[] serverTypesTree;
        boolean existingServer = false;

        public void setServerTreeItems(Tree serversList) {
            this.setExistingServersTree(serversList);
            this.setServerTypesTree(serversList);
        }

        public void setExistingServersTree(Tree serverList) {
            String[] serverIds = this.getAllExistingServers();
            this.existingServersTree = new TreeItem[1];
            TreeItem[] existingServerItems = new TreeItem[serverIds.length];
            this.existingServersTree[0] = new TreeItem(serverList, 0);
            this.existingServersTree[0].setText(RuntimeServerSelectionDialog.getMessage("%LABEL_TREE_EXISTING_SERVERS"));
            ImageDescriptor id = WebServiceConsumptionUIPlugin.getImageDescriptor("icons/servers/existing_server_obj.gif");
            if (id != null) {
                this.existingServersTree[0].setImage(id.createImage());
            }
            int k = 0;
            while (k < serverIds.length) {
                IServerType serverType = ServerCore.findServerType((String)((IServer)RuntimeServerSelectionDialog.this.existingServersTable_.get(serverIds[k])).getServerType().getId());
                if (serverType != null) {
                    existingServerItems[k] = new TreeItem(this.existingServersTree[0], 0);
                    existingServerItems[k].setText(serverIds[k]);
                    if (serverIds[k].equalsIgnoreCase(RuntimeServerSelectionDialog.this.defaultServer_) && RuntimeServerSelectionDialog.this.getIsExistingServer()) {
                        this.existingServersTree[0].setExpanded(true);
                        serverList.setSelection(new TreeItem[]{existingServerItems[k]});
                        this.existingServer = true;
                        RuntimeServerSelectionDialog.this.setIsExistingServer(true);
                        RuntimeServerSelectionDialog.this.selectedServer_ = (IServer)RuntimeServerSelectionDialog.this.existingServersTable_.get(RuntimeServerSelectionDialog.this.defaultServer_);
                        RuntimeServerSelectionDialog.this.selectedServerLabel_ = serverIds[k];
                        RuntimeServerSelectionDialog.this.selectedServerFactoryID_ = RuntimeServerSelectionDialog.this.selectedServer_.getServerType().getId();
                    }
                    existingServerItems[k].setImage(ServerUICore.getLabelProvider().getImage((Object)serverType));
                }
                ++k;
            }
        }

        public void setServerTypesTree(Tree serverList) {
            TreeItem[] serverTypesTree = new TreeItem[]{new TreeItem(serverList, 0)};
            serverTypesTree[0].setText(RuntimeServerSelectionDialog.getMessage("%LABEL_TREE_SERVER_TYPES"));
            ImageDescriptor id = WebServiceConsumptionUIPlugin.getImageDescriptor("icons/servers/servers_obj.gif");
            if (id != null) {
                serverTypesTree[0].setImage(id.createImage());
            }
            Hashtable<IServerType, IRuntimeType> categories_ = new Hashtable<IServerType, IRuntimeType>();
            Hashtable<IRuntimeType, TreeItem> categoryTreeItem = new Hashtable<IRuntimeType, TreeItem>();
            String[] serverIds = null;
            serverIds = RuntimeServerSelectionDialog.this.selectionMode_ == 0 ? WebServiceRuntimeExtensionUtils.getServerFactoryIdsByType(RuntimeServerSelectionDialog.this.typeId_) : WebServiceRuntimeExtensionUtils.getAllClientServerFactoryIds();
            if (serverIds == null) {
                serverIds = this.getAllServerTypes();
            }
            TreeItem[] parent = new TreeItem[serverIds.length];
            TreeItem[] item = new TreeItem[serverIds.length];
            if (serverIds != null) {
                int i = 0;
                while (i < serverIds.length) {
                    String server = ServerUtils.getInstance().getServerLabelForId(serverIds[i]);
                    if (server != null) {
                        RuntimeServerSelectionDialog.this.serverLabels_.put(server, serverIds[i]);
                        IServerType serverType = ServerCore.findServerType((String)serverIds[i]);
                        IRuntimeType runtimeType = serverType.getRuntimeType();
                        if (!categories_.containsKey(serverType) && runtimeType != null) {
                            categories_.put(serverType, runtimeType);
                            if (categoryTreeItem.get(runtimeType) == null) {
                                String categoryText = runtimeType.getName();
                                Image categoryImage = ServerUICore.getLabelProvider().getImage((Object)runtimeType);
                                parent[i] = new TreeItem(serverTypesTree[0], 0);
                                parent[i].setText(categoryText);
                                parent[i].setImage(categoryImage);
                                categoryTreeItem.put(runtimeType, parent[i]);
                            } else {
                                parent[i] = (TreeItem)categoryTreeItem.get(runtimeType);
                            }
                            String factoryText = serverType.getName();
                            Image factoryImage = ServerUICore.getLabelProvider().getImage((Object)serverType);
                            item[i] = new TreeItem(parent[i], 0);
                            item[i].setText(factoryText);
                            item[i].setImage(factoryImage);
                            item[i].setData((Object)serverType);
                            if (factoryText.equalsIgnoreCase(RuntimeServerSelectionDialog.this.defaultServer_) && !this.existingServer) {
                                serverList.setSelection(new TreeItem[]{item[i]});
                                RuntimeServerSelectionDialog.this.selectedServer_ = null;
                                RuntimeServerSelectionDialog.this.selectedServerLabel_ = factoryText;
                                RuntimeServerSelectionDialog.this.selectedServerFactoryID_ = (String)RuntimeServerSelectionDialog.this.serverLabels_.get(RuntimeServerSelectionDialog.this.selectedServerLabel_);
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        private String[] getAllExistingServers() {
            Vector<String> serverIds = new Vector<String>();
            IServer[] servers = ServerCore.getServers();
            if (servers != null && servers.length != 0) {
                int i = 0;
                while (i < servers.length) {
                    IServer server = servers[i];
                    serverIds.add(server.getName());
                    RuntimeServerSelectionDialog.this.existingServersTable_.put(server.getName(), server);
                    ++i;
                }
            }
            return serverIds.toArray(new String[serverIds.size()]);
        }

        private String[] getAllServerTypes() {
            Vector<String> serverTypes_ = new Vector<String>();
            IServerType[] defaultServersList = ServerCore.getServerTypes();
            int i = 0;
            while (i < defaultServersList.length) {
                IServerType serverType = defaultServersList[i];
                serverTypes_.add(serverType.getId());
                ++i;
            }
            return serverTypes_.toArray(new String[serverTypes_.size()]);
        }
    }
}

