/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ClasspathUtils {
    public static final String copyright = "(c) Copyright IBM Corporation 2003.";
    private static ClasspathUtils instance_;
    private static String DIR_CLASSES;
    private static String DIR_LIB;
    private static String DOT_JAR;
    private static String JAR;
    private static String WEBINF_LIB;
    private static String WEBINF;

    static {
        DIR_CLASSES = "classes";
        DIR_LIB = "lib";
        DOT_JAR = ".jar";
        JAR = "jar";
        WEBINF_LIB = "/WEB-INF/lib";
        WEBINF = "WEB-INF";
    }

    private ClasspathUtils() {
    }

    public static ClasspathUtils getInstance() {
        if (instance_ == null) {
            instance_ = new ClasspathUtils();
        }
        return instance_;
    }

    public String getClasspathString(IProject project, String module) {
        StringBuffer classpath = new StringBuffer();
        String[] classpathEntries = this.getClasspath(project, false, module);
        Vector<String> classpathVector = new Vector<String>();
        int i = 0;
        while (i < classpathEntries.length) {
            if (!classpathVector.contains(classpathEntries[i])) {
                classpathVector.add(classpathEntries[i]);
                classpath.append(classpathEntries[i]);
                classpath.append(";");
            }
            ++i;
        }
        return classpath.toString();
    }

    /*
     * Exception decompiling
     */
    private String[] getClasspath(IProject project, boolean isDependent, String inputModule) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 380->383)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String[] getUtilityJarClasspath(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 125->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] getClasspathForEARProject(IProject project, String module) {
        IPath projectPath = project.getProject().getLocation().addTrailingSeparator().append(module).addTrailingSeparator();
        return this.getDirectoryJarFiles(projectPath);
    }

    private String[] getDirectoryJarFiles(IPath iPath) {
        File dir = iPath.toFile();
        Vector<String> jarsVector = new Vector<String>();
        if (dir.exists() && dir.isDirectory()) {
            String[] filenames = dir.list();
            int i = 0;
            while (i < filenames.length) {
                if (filenames[i].endsWith(DOT_JAR)) {
                    jarsVector.add(String.valueOf(this.path2String(iPath)) + filenames[i]);
                }
                ++i;
            }
        }
        Object[] jars = new String[jarsVector.size()];
        jarsVector.copyInto(jars);
        return jars;
    }

    private String[] getWEBINFLib(IProject project, String module) {
        String[] webinfLibJars = new String[]{};
        ArrayList<String> anArrayList = new ArrayList<String>();
        try {
            IVirtualFolder webInfLib;
            IVirtualComponent component = ComponentCore.createComponent((IProject)project, (String)module);
            if (component != null && (webInfLib = component.getRootFolder().getFolder((IPath)new Path(WEBINF_LIB))) != null) {
                IVirtualResource[] resources = webInfLib.members();
                IResource aResource = null;
                int i = 0;
                while (i < resources.length) {
                    aResource = resources[i].getUnderlyingResource();
                    if (JAR.equalsIgnoreCase(aResource.getFileExtension())) {
                        anArrayList.add(aResource.getLocation().toOSString());
                    }
                    ++i;
                }
                if (anArrayList.size() != 0) {
                    webinfLibJars = anArrayList.toArray(new String[anArrayList.size()]);
                }
            }
        }
        catch (CoreException coreException) {}
        return webinfLibJars;
    }

    private String[] getClasspathForJavaProject(IJavaProject javaProject) {
        ArrayList<String> projectClasspath = new ArrayList<String>();
        try {
            IClasspathEntry[] buildPath = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < buildPath.length) {
                String[] buildPathString = this.classpathEntry2String(buildPath[i], javaProject.getProject());
                int j = 0;
                while (j < buildPathString.length) {
                    if (!buildPathString[j].endsWith("activation.jar") && !buildPathString[j].endsWith("mail.jar")) {
                        projectClasspath.add(buildPathString[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        IProject project = javaProject.getProject();
        IProject[] referencingProjects = project.getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            String[] utilityJarsClasspath = this.getUtilityJarClasspath(referencingProjects[i]);
            int j = 0;
            while (j < utilityJarsClasspath.length) {
                projectClasspath.add(utilityJarsClasspath[j]);
                ++j;
            }
            ++i;
        }
        return projectClasspath.toArray(new String[projectClasspath.size()]);
    }

    private String[] classpathEntry2String(IClasspathEntry entry, IProject project) {
        switch (entry.getEntryKind()) {
            case 1: {
                return new String[]{this.path2String(entry.getPath())};
            }
            case 2: {
                return this.getClasspath(ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment()), true, "");
            }
            case 3: {
                IPath path = entry.getPath();
                if (path.segment(0).equals(project.getName())) {
                    path = path.removeFirstSegments(1);
                }
                return new String[]{this.path2String(project.getLocation().addTrailingSeparator().append(path))};
            }
            case 4: {
                return this.classpathEntry2String(JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry), project);
            }
        }
        return new String[]{this.path2String(entry.getPath())};
    }

    private String path2String(IPath path) {
        return path.toOSString();
    }
}

