/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.frameworks.internal.operations.IProjectCreationProperties;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public class NewProjectGroup
implements IProjectCreationProperties {
    private IDataModel model;
    public Text projectNameField = null;
    protected Text locationPathField = null;
    protected Button browseButton = null;
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    private String defProjectNameLabel = WTPCommonUIResourceHandler.getString("Name_");
    private String defBrowseButtonLabel = WTPCommonUIResourceHandler.getString("Browse_");
    private static final String defDirDialogLabel = "Directory";
    private DataModelSynchHelper synchHelper;

    public NewProjectGroup(Composite parent, int style, IDataModel model, DataModelSynchHelper helper) {
        this.model = model;
        this.synchHelper = helper;
        this.buildComposites(parent);
    }

    public void buildComposites(Composite parent) {
        this.createProjectNameGroup(parent);
        this.createProjectLocationGroup(parent);
        this.projectNameField.setFocus();
    }

    private void createProjectNameGroup(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText(this.defProjectNameLabel);
        GridData data = new GridData();
        projectNameLabel.setLayoutData((Object)data);
        this.projectNameField = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.projectNameField.setLayoutData((Object)data);
        new Label(parent, 0);
        this.synchHelper.synchText(this.projectNameField, "IProjectCreationProperties.PROJECT_NAME", new Control[]{projectNameLabel});
    }

    private void createProjectLocationGroup(Composite parent) {
        Label locationPathLabel = new Label(parent, 0);
        locationPathLabel.setText(WTPCommonUIResourceHandler.getString("Project_location_"));
        GridData data = new GridData();
        locationPathLabel.setLayoutData((Object)data);
        this.locationPathField = new Text(parent, 2056);
        data = new GridData(768);
        data.widthHint = 305;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText(this.defBrowseButtonLabel);
        this.browseButton.setLayoutData((Object)new GridData(768));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectGroup.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(true);
        this.synchHelper.synchText(this.locationPathField, "IProjectCreationProperties.PROJECT_LOCATION", null);
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(defDirDialogLabel);
        String dirName = this.model.getStringProperty("IProjectCreationProperties.PROJECT_LOCATION");
        if (dirName != null && dirName.length() != 0 && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.model.setProperty("IProjectCreationProperties.PROJECT_LOCATION", (Object)selectedDirectory);
        }
    }

    public void dispose() {
        this.model.removeListener((IDataModelListener)this.synchHelper);
        this.synchHelper.dispose();
        this.model = null;
    }
}

