/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.MasterDescriptor;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.UIOperationExtensionRegistry;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WTPOptionalOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.ComposedOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public class WTPOperationAction
extends Action
implements IActionDelegate,
IViewActionDelegate {
    private IStructuredSelection selection;
    private IViewPart viewPart;
    private IWorkbenchSite workbenchSite;
    protected IStatus status;

    public WTPOperationAction() {
    }

    public WTPOperationAction(String id, String name) {
        super(name);
        this.init(id, null);
    }

    public WTPOperationAction(String id, String name, ImageDescriptor imgDescriptor) {
        super(name, imgDescriptor);
        this.init(id, null);
    }

    public WTPOperationAction(String id, String name, IWorkbenchSite site) {
        super(name);
        this.init(id, site);
    }

    public WTPOperationAction(String id, String name, ImageDescriptor imgDescriptor, IWorkbenchSite site) {
        super(name, imgDescriptor);
        this.init(id, site);
    }

    private void init(String id, IWorkbenchSite site) {
        this.setId(id);
        this.setWorkbenchSite(site);
    }

    protected boolean updateSelection(IAction action, IStructuredSelection selection1) {
        this.selection = selection1;
        MasterDescriptor[] masters = UIOperationExtensionRegistry.INSTANCE.getExtendedUIOperations(action.getId(), this.selection);
        action.setEnabled(masters.length > 0);
        return masters.length > 0;
    }

    public void run() {
        this.run((IAction)this);
    }

    public final void run(IAction action) {
        if (action == null) {
            return;
        }
        WTPOptionalOperationDataModel operationDataModel = WTPOptionalOperationDataModel.createDataModel(action.getId(), this.selection);
        operationDataModel.setProperty("IWORKBENCH_SITE", this.getWorkbenchSite());
        this.executeCompoundOperation(operationDataModel);
    }

    public IWorkbenchSite getWorkbenchSite() {
        if (this.workbenchSite != null) {
            return this.workbenchSite;
        }
        if (this.viewPart != null) {
            return this.viewPart.getSite();
        }
        return null;
    }

    protected void executeCompoundOperation(WTPOptionalOperationDataModel operationDataModel) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            WTPOperation operation = operationDataModel.getDefaultOperation();
            operationDataModel.setOperationValidationEnabled(true);
            List runnables = ((ComposedOperation)operation).getRunnables();
            IProgressMonitor submonitor = null;
            int i = 0;
            while (i < runnables.size()) {
                WTPOperation op = (WTPOperation)runnables.get(i);
                if (op != null) {
                    op.run(submonitor);
                }
                ++i;
            }
            this.status = operation.getStatus();
            if (!this.status.isOK()) {
                ErrorDialog.openError((Shell)shell, (String)WTPCommonUIResourceHandler.getString("WTPOperationAction_UI_0"), (String)WTPCommonUIResourceHandler.getString("WTPOperationAction_UI_1"), (IStatus)this.status);
            }
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
            this.status = new Status(4, "org.eclipse.wst.common.frameworks.ui", 0, e.toString(), (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection1) {
        if (selection1 instanceof IStructuredSelection) {
            this.setEnabled(this.updateSelection(action, (IStructuredSelection)selection1));
        } else {
            action.setEnabled(false);
        }
    }

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void setWorkbenchSite(IWorkbenchSite workbenchSite) {
        this.workbenchSite = workbenchSite;
    }

    public IStatus getStatus() {
        return this.status;
    }
}

