/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.MnemonicAssigner;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class DialogProblemFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;
    private SeverityGroup severityGroup;

    public DialogProblemFilter(Shell parentShell, ProblemFilter filter) {
        super(parentShell, filter);
    }

    protected void createAttributesArea(Composite parent, MnemonicAssigner mnemonics) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(5, false);
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        this.descriptionGroup = new DescriptionGroup(composite, mnemonics);
        this.severityGroup = new SeverityGroup(composite, mnemonics);
    }

    protected void updateFilterFromUI() {
        ProblemFilter filter = (ProblemFilter)this.getFilter();
        filter.setContains(this.descriptionGroup.getContains());
        filter.setDescription(this.descriptionGroup.getDescription().trim());
        filter.setSelectBySeverity(this.severityGroup.isEnabled());
        int severity = 0;
        if (this.severityGroup.isErrorSelected()) {
            severity |= 4;
        }
        if (this.severityGroup.isWarningSelected()) {
            severity |= 2;
        }
        if (this.severityGroup.isInfoSelected()) {
            severity |= 1;
        }
        filter.setSeverity(severity);
        super.updateFilterFromUI();
    }

    protected void updateUIFromFilter() {
        ProblemFilter filter = (ProblemFilter)this.getFilter();
        this.descriptionGroup.setContains(filter.getContains());
        this.descriptionGroup.setDescription(filter.getDescription());
        this.severityGroup.setEnabled(filter.getSelectBySeverity());
        int severity = filter.getSeverity();
        this.severityGroup.setErrorSelected((severity & 4) > 0);
        this.severityGroup.setWarningSelected((severity & 2) > 0);
        this.severityGroup.setInfoSelected((severity & 1) > 0);
        super.updateUIFromFilter();
    }

    protected void updateEnabledState() {
        super.updateEnabledState();
        this.descriptionGroup.updateEnablement();
        this.severityGroup.updateEnablement();
    }

    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        this.severityGroup.setEnabled(false);
        this.severityGroup.setErrorSelected(false);
        this.severityGroup.setWarningSelected(false);
        this.severityGroup.setInfoSelected(false);
        super.resetPressed();
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = Messages.getString("filtersDialog.contains");
        private String doesNotContain = Messages.getString("filtersDialog.doesNotContain");

        public DescriptionGroup(Composite parent, MnemonicAssigner mnemonics) {
            this.descriptionLabel = new Label(parent, 0);
            this.descriptionLabel.setFont(parent.getFont());
            this.descriptionLabel.setText(mnemonics.assign(Messages.getString("filtersDialog.descriptionLabel")));
            this.combo = new Combo(parent, 8);
            this.combo.setFont(parent.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener(DialogProblemFilter.this.selectionListener);
            this.combo.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.description = new Text(parent, 2052);
            this.description.setFont(parent.getFont());
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.description.setLayoutData((Object)data);
            this.description.addModifyListener(new ModifyListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void modifyText(ModifyEvent e) {
                    DescriptionGroup.access$0(this.this$1).markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean value) {
            if (value) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String text) {
            if (text == null) {
                this.description.setText("");
            } else {
                this.description.setText(text);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement() {
            this.descriptionLabel.setEnabled(DialogProblemFilter.this.isFilterEnabled());
            this.combo.setEnabled(DialogProblemFilter.this.isFilterEnabled());
            this.description.setEnabled(DialogProblemFilter.this.isFilterEnabled());
        }

        static /* synthetic */ DialogProblemFilter access$0(DescriptionGroup descriptionGroup) {
            return descriptionGroup.DialogProblemFilter.this;
        }
    }

    private class SeverityGroup {
        private Button enablementButton;
        private Button errorButton;
        private Button warningButton;
        private Button infoButton;

        public SeverityGroup(Composite parent, MnemonicAssigner mnemonics) {
            SelectionAdapter listener = new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.updateEnablement();
                    SeverityGroup.access$0(this.this$1).markDirty();
                }
            };
            this.enablementButton = new Button(parent, 32);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.enablementButton.setLayoutData((Object)data);
            this.enablementButton.setFont(parent.getFont());
            this.enablementButton.setText(mnemonics.assign(Messages.getString("filtersDialog.severityLabel")));
            this.enablementButton.addSelectionListener((SelectionListener)listener);
            this.errorButton = new Button(parent, 32);
            this.errorButton.setFont(parent.getFont());
            this.errorButton.setText(mnemonics.assign(Messages.getString("filtersDialog.severityError")));
            this.errorButton.setLayoutData((Object)new GridData(768));
            this.errorButton.addSelectionListener(DialogProblemFilter.this.selectionListener);
            this.warningButton = new Button(parent, 32);
            this.warningButton.setFont(parent.getFont());
            this.warningButton.setText(mnemonics.assign(Messages.getString("filtersDialog.severityWarning")));
            this.warningButton.setLayoutData((Object)new GridData(768));
            this.warningButton.addSelectionListener(DialogProblemFilter.this.selectionListener);
            this.infoButton = new Button(parent, 32);
            this.infoButton.setFont(parent.getFont());
            this.infoButton.setText(mnemonics.assign(Messages.getString("filtersDialog.severityInfo")));
            this.infoButton.setLayoutData((Object)new GridData(768));
            this.infoButton.addSelectionListener(DialogProblemFilter.this.selectionListener);
        }

        public boolean isEnabled() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean enabled) {
            this.enablementButton.setSelection(enabled);
        }

        public boolean isErrorSelected() {
            return this.errorButton.getSelection();
        }

        public void setErrorSelected(boolean selected) {
            this.errorButton.setSelection(selected);
        }

        public boolean isWarningSelected() {
            return this.warningButton.getSelection();
        }

        public void setWarningSelected(boolean selected) {
            this.warningButton.setSelection(selected);
        }

        public boolean isInfoSelected() {
            return this.infoButton.getSelection();
        }

        public void setInfoSelected(boolean selected) {
            this.infoButton.setSelection(selected);
        }

        public void updateEnablement() {
            this.enablementButton.setEnabled(DialogProblemFilter.this.isFilterEnabled());
            this.errorButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
            this.warningButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
            this.infoButton.setEnabled(this.enablementButton.isEnabled() && this.isEnabled());
        }

        static /* synthetic */ DialogProblemFilter access$0(SeverityGroup severityGroup) {
            return severityGroup.DialogProblemFilter.this;
        }
    }
}

