/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormInputException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.response.ServiceList;
import org.uddi4j.transport.TransportException;

public class RegFindServicesSimpleAction
extends FindAction {
    public RegFindServicesSimpleAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(1));
        this.propertyTable_.put("queryStyleServices", String.valueOf(0));
    }

    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String name = parser.getParameter("simpleServiceName");
        boolean inputsValid = true;
        if (name != null) {
            this.propertyTable_.put("simpleServiceName", name);
        } else {
            inputsValid = false;
        }
        return inputsValid;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            boolean shouldAddQueryNode = this.propertyTable_.get("overrideAddQueryNode") == null;
            String name = (String)this.propertyTable_.get("simpleServiceName");
            Vector<Name> nameVector = new Vector<Name>();
            nameVector.addElement(new Name(name));
            this.getSelectedNavigatorNode();
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            ServiceList serviceList = proxy.find_service("", nameVector, null, null, null, 100);
            ServiceInfos sInfos = serviceList.getServiceInfos();
            int finalNumberOfBusinessServices = Math.min(10, sInfos.size());
            Vector<String> serviceKeyVector = new Vector<String>();
            int i = 0;
            while (i < finalNumberOfBusinessServices) {
                ServiceInfo sInfo = sInfos.get(i);
                serviceKeyVector.addElement(sInfo.getServiceKey());
                ++i;
            }
            if (finalNumberOfBusinessServices > 0) {
                if (shouldAddQueryNode) {
                    ServiceDetail serviceDetail = proxy.get_serviceDetail(serviceKeyVector);
                    Vector businessServiceVector = serviceDetail.getBusinessServiceVector();
                    String queryName = (String)this.propertyTable_.get("queryName");
                    BusinessService[] bsArray = new BusinessService[finalNumberOfBusinessServices];
                    businessServiceVector.toArray(bsArray);
                    this.queryElement_ = new QueryElement(bsArray, queryName, regElement.getModel());
                    this.addQueryNode();
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICES_FOUND", String.valueOf(bsArray.length)));
                }
                return true;
            }
            throw new FormInputException(uddiPerspective.getMessage("MSG_ERROR_NO_SERVICES_FOUND"));
        }
        catch (UDDIException e) {
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
        }
        catch (FormInputException e) {
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

