/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletEjbAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletWebAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.util.AntLauncherUtility;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class XDocletAntProjectBuilder {
    protected URL templateUrl;

    protected String asClassPath(IJavaProject project) throws CoreException {
        String[] cp = this.createClassPath(project);
        StringBuffer buf = new StringBuffer(256);
        int i = 0;
        while (i < cp.length) {
            String string = cp[i];
            buf.append(string);
            if (i != cp.length - 1) {
                buf.append(File.pathSeparatorChar);
            }
            ++i;
        }
        return buf.toString();
    }

    protected String[] createClassPath(IJavaProject project) throws CoreException {
        String[] cp = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        return cp;
    }

    public void buildUsingAnt(IResource beanClass, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)beanClass.getProject());
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)beanClass));
        try {
            IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot(compilationUnit);
            String beanPath = this.constructAnnotatedClassList(packageFragmentRoot, beanClass);
            Properties properties = this.createAntBuildProperties(beanClass, javaProject, packageFragmentRoot, beanPath);
            HashMap templates = this.createTemplates(beanPath);
            AntLauncherUtility antLauncher = new AntLauncherUtility(this.templateUrl, beanClass.getParent().getLocation(), properties, templates);
            antLauncher.setUseLauncher(true);
            antLauncher.launch(this.getTaskName(), monitor);
            this.refreshProjects(beanClass.getProject(), monitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    protected abstract String getTaskName();

    protected abstract void refreshProjects(IProject var1, IProgressMonitor var2) throws CoreException;

    protected abstract HashMap createTemplates(String var1);

    protected abstract Properties createAntBuildProperties(IResource var1, IJavaProject var2, IPackageFragmentRoot var3, String var4);

    protected abstract String constructAnnotatedClassList(IPackageFragmentRoot var1, IResource var2);

    protected IPath makeRelativeTo(IPath path, IPackageFragmentRoot root) {
        try {
            IPath rpath = root.getCorrespondingResource().getProjectRelativePath();
            if (rpath.isPrefixOf(path)) {
                return path.removeFirstSegments(rpath.matchingFirstSegments(path));
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return path;
    }

    protected IPackageFragmentRoot getPackageFragmentRoot(ICompilationUnit res) {
        ICompilationUnit current = res;
        do {
            if (!(current instanceof IPackageFragmentRoot)) continue;
            return (IPackageFragmentRoot)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected IPath getJavaProjectOutputContainer(IJavaProject proj) throws JavaModelException {
        IPath path = proj.getOutputLocation();
        if (path == null) {
            return null;
        }
        if (path.segmentCount() == 1) {
            return path;
        }
        return proj.getProject().getFolder(path.removeFirstSegments(1)).getProjectRelativePath();
    }

    public static class Factory {
        public static XDocletAntProjectBuilder newInstance(IResource resource) {
            IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
            if (vResources.length == 0) {
                return null;
            }
            String moduleType = vResources[0].getComponent().getComponentTypeId();
            if (moduleType.equals("jst.ejb")) {
                return new XDocletEjbAntProjectBuilder();
            }
            if (moduleType.equals("jst.web")) {
                return new XDocletWebAntProjectBuilder();
            }
            return null;
        }
    }
}

