/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PerspectiveManager
implements ILaunchListener,
IDebugEventSetListener {
    private Map fPreferenceMap;
    private static final String ELEMENT_PERSPECTIVES = "launchPerspectives";
    private static final String ELEMENT_PERSPECTIVE = "launchPerspective";
    private static final String ATTR_TYPE_ID = "configurationType";
    private static final String ATTR_MODE_ID = "mode";
    private static final String ATTR_PERSPECTIVE_ID = "perspective";
    private boolean fPrompting;
    private PerspectiveSwitchLock fPerspectiveSwitchLock = new PerspectiveSwitchLock();

    public void startup() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
        plugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    public void shutdown() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        plugin.removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        this.fPerspectiveSwitchLock.startSwitch();
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            String name = DebugUIPlugin.getModelPresentation().getText(launch);
            this.switchFailed(e, name);
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null && !LaunchConfigurationManager.isVisible(configuration)) {
            perspectiveId = null;
        }
        final String id = perspectiveId;
        this.async(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    IWorkbenchWindow window = PerspectiveManager.this.getWindowForPerspective(id);
                    if (id != null && window != null && PerspectiveManager.this.shouldSwitchPerspectiveForLaunch(window, id)) {
                        PerspectiveManager.this.switchToPerspective(window, id);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                    PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
                    return;
                }
            }
        });
    }

    protected void switchToPerspective(IWorkbenchWindow window, String id) {
        try {
            window.getWorkbench().showPerspective(id, window);
        }
        catch (WorkbenchException e) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.PerspectiveManager_Error_1, MessageFormat.format(LaunchConfigurationsMessages.PerspectiveManager_Unable_to_switch_to_perspective___0__2, id), e);
        }
    }

    protected void async(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.asyncExec(r);
        }
    }

    protected void sync(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.syncExec(r);
        }
    }

    protected void switchFailed(final Throwable t, final String launchName) {
        this.sync(new Runnable(){

            public void run() {
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.PerspectiveManager_Error_1, MessageFormat.format(LaunchConfigurationsMessages.PerspectiveManager_Unable_to_switch_perpsectives_as_specified_by_launch___0__4, launchName), t);
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 2 && !event.isEvaluation() && event.getDetail() != 8) {
                this.handleBreakpointHit(event);
            }
            ++i;
        }
    }

    protected void showDebugView(final IWorkbenchWindow window) {
        if (this.fPrompting) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (PerspectiveManager.this.fPrompting) {
                        PerspectiveManager perspectiveManager = PerspectiveManager.this;
                        synchronized (perspectiveManager) {
                            try {
                                PerspectiveManager.this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    PerspectiveManager.this.async(new Runnable(this, window){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ IWorkbenchWindow val$window;
                        {
                            this.this$1 = var1_1;
                            this.val$window = iWorkbenchWindow;
                        }

                        public void run() {
                            PerspectiveManager.access$3(3.access$0(this.this$1), this.val$window);
                        }
                    });
                }

                static /* synthetic */ PerspectiveManager access$0(3 var0) {
                    return var0.PerspectiveManager.this;
                }
            });
            thread.setDaemon(true);
            thread.start();
            return;
        }
        this.doShowDebugView(window);
    }

    private void doShowDebugView(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            try {
                page.showView("org.eclipse.debug.ui.DebugView", null, 2);
            }
            catch (PartInitException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void handleBreakpointHit(DebugEvent event) {
        this.fPerspectiveSwitchLock.startSwitch();
        ILaunch launch = null;
        Object source = event.getSource();
        if (source instanceof IDebugElement) {
            launch = ((IDebugElement)source).getLaunch();
        } else if (source instanceof IProcess) {
            launch = ((IProcess)source).getLaunch();
        }
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        final String targetId = perspectiveId;
        Runnable r = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block12: {
                    block11: {
                        IWorkbenchWindow window = null;
                        try {
                            if (targetId != null) {
                                Shell shell;
                                window = PerspectiveManager.this.getWindowForPerspective(targetId);
                                if (window == null) {
                                    Object var3_2 = null;
                                    PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
                                    return;
                                }
                                if (PerspectiveManager.this.shouldSwitchPerspectiveForSuspend(window, targetId)) {
                                    PerspectiveManager.this.switchToPerspective(window, targetId);
                                    window = PerspectiveManager.this.getWindowForPerspective(targetId);
                                    if (window == null) {
                                        break block11;
                                    }
                                }
                                if ((shell = window.getShell()) != null) {
                                    if (shell.getMinimized()) {
                                        shell.setMinimized(false);
                                    }
                                    if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH)) {
                                        shell.forceActive();
                                    }
                                }
                            }
                            if (window != null && DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_ACTIVATE_DEBUG_VIEW)) {
                                PerspectiveManager.this.showDebugView(window);
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
                            throw throwable;
                        }
                    }
                    Object var3_3 = null;
                    PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
                    return;
                }
                Object var3_5 = null;
                PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
            }
        };
        this.async(r);
    }

    private IWorkbenchWindow getWindowForPerspective(String perspectiveId) {
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (this.isWindowShowingPerspective(window, perspectiveId)) {
            return window;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            window = windows[i];
            if (this.isWindowShowingPerspective(window, perspectiveId)) {
                return window;
            }
            ++i;
        }
        window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    private boolean isWindowShowingPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        return window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null && perspectiveDescriptor.getId().equals(perspectiveId);
    }

    protected boolean shouldSwitchPerspectiveForSuspend(IWorkbenchWindow window, String perspectiveId) {
        return this.shouldSwitchPerspective(window, perspectiveId, LaunchConfigurationsMessages.PerspectiveManager_13, IInternalDebugUIConstants.PREF_SWITCH_PERSPECTIVE_ON_SUSPEND);
    }

    protected boolean shouldSwitchPerspectiveForLaunch(IWorkbenchWindow window, String perspectiveId) {
        return this.shouldSwitchPerspective(window, perspectiveId, LaunchConfigurationsMessages.PerspectiveManager_15, IInternalDebugUIConstants.PREF_SWITCH_TO_PERSPECTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldSwitchPerspective(IWorkbenchWindow window, String perspectiveId, String message, String preferenceKey) {
        MessageDialogWithToggle dialog;
        if (this.isCurrentPerspective(window, perspectiveId)) {
            return false;
        }
        String perspectiveName = this.getPerspectiveLabel(perspectiveId);
        if (perspectiveName == null) {
            return false;
        }
        String switchPerspective = DebugUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if ("always".equals(switchPerspective)) {
            return true;
        }
        if ("never".equals(switchPerspective)) {
            return false;
        }
        Shell shell = window.getShell();
        if (shell == null || this.fPrompting) {
            return false;
        }
        this.fPrompting = true;
        if (shell.getMinimized()) {
            shell.setMinimized(false);
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH)) {
            shell.forceActive();
        }
        boolean answer = (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)LaunchConfigurationsMessages.PerspectiveManager_12, (String)MessageFormat.format(message, perspectiveName), null, (boolean)false, (IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)preferenceKey)).getReturnCode() == 2;
        PerspectiveManager perspectiveManager = this;
        synchronized (perspectiveManager) {
            this.fPrompting = false;
            this.notifyAll();
        }
        if (this.isCurrentPerspective(window, perspectiveId)) {
            answer = false;
        }
        return answer;
    }

    protected boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    protected String getPerspectiveLabel(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getLabel();
    }

    protected String getPerspectiveId(ILaunch launch) throws CoreException {
        if (launch == null) {
            return null;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return null;
        }
        String perspectiveId = null;
        perspectiveId = DebugUITools.getLaunchPerspective(config.getType(), launch.getLaunchMode());
        if (perspectiveId != null && perspectiveId.equals("perspective_none")) {
            perspectiveId = null;
        }
        return perspectiveId;
    }

    public String getLaunchPerspective(ILaunchConfigurationType type, String mode) {
        String id = this.getUserSpecifiedLaunchPerspective(type, mode);
        if (id == null) {
            id = this.getDefaultLaunchPerspective(type, mode);
        } else if (id.equals("perspective_none")) {
            id = null;
        }
        return id;
    }

    public void setLaunchPerspective(ILaunchConfigurationType type, String mode, String perspective) {
        this.internalSetLaunchPerspective(type.getIdentifier(), mode, perspective);
        try {
            String xml = this.generatePerspectiveXML();
            DebugUIPlugin.getDefault().getPreferenceStore().putValue(IInternalDebugUIConstants.PREF_LAUNCH_PERSPECTIVES, xml);
            DebugUIPlugin.getDefault().savePluginPreferences();
        }
        catch (IOException e) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus(LaunchConfigurationsMessages.PerspectiveManager_9, e));
        }
        catch (ParserConfigurationException e) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus(LaunchConfigurationsMessages.PerspectiveManager_9, e));
        }
        catch (TransformerException e) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus(LaunchConfigurationsMessages.PerspectiveManager_9, e));
        }
    }

    private void internalSetLaunchPerspective(String type, String mode, String perspective) {
        HashMap<String, String> modeMap;
        if (this.fPreferenceMap == null) {
            this.initPerspectives();
        }
        if ((modeMap = (HashMap<String, String>)this.fPreferenceMap.get(type)) == null) {
            modeMap = new HashMap<String, String>();
            this.fPreferenceMap.put(type, modeMap);
        }
        if (perspective.equals("perspective_default")) {
            modeMap.remove(mode);
        } else {
            modeMap.put(mode, perspective);
        }
    }

    private String generatePerspectiveXML() throws ParserConfigurationException, TransformerException, IOException {
        Document doc = DebugUIPlugin.getDocument();
        Element configRootElement = doc.createElement(ELEMENT_PERSPECTIVES);
        doc.appendChild(configRootElement);
        Iterator configTypes = this.fPreferenceMap.keySet().iterator();
        while (configTypes.hasNext()) {
            String type = (String)configTypes.next();
            Map modeMap = (Map)this.fPreferenceMap.get(type);
            if (modeMap == null || modeMap.isEmpty()) continue;
            Iterator modes = modeMap.keySet().iterator();
            while (modes.hasNext()) {
                String mode = (String)modes.next();
                String perspective = (String)modeMap.get(mode);
                Element element = doc.createElement(ELEMENT_PERSPECTIVE);
                element.setAttribute(ATTR_TYPE_ID, type);
                element.setAttribute(ATTR_MODE_ID, mode);
                element.setAttribute(ATTR_PERSPECTIVE_ID, perspective);
                configRootElement.appendChild(element);
            }
        }
        return DebugUIPlugin.serializeDocument(doc);
    }

    protected String getDefaultLaunchPerspective(ILaunchConfigurationType type, String mode) {
        LaunchConfigurationTabGroupExtension extension = LaunchConfigurationPresentationManager.getDefault().getExtension(type.getIdentifier(), mode);
        if (extension != null) {
            String id = extension.getPerspective(mode);
            if (id == null) {
                if (mode.equals("debug")) {
                    return IDebugUIConstants.ID_DEBUG_PERSPECTIVE;
                }
            } else {
                return id;
            }
        }
        return null;
    }

    protected String getUserSpecifiedLaunchPerspective(ILaunchConfigurationType type, String mode) {
        Map modeMap;
        String id = null;
        if (this.fPreferenceMap == null) {
            this.initPerspectives();
        }
        if ((modeMap = (Map)this.fPreferenceMap.get(type.getIdentifier())) != null) {
            id = (String)modeMap.get(mode);
        }
        return id;
    }

    private void initPerspectives() {
        this.fPreferenceMap = new HashMap();
        String xml = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_LAUNCH_PERSPECTIVES);
        if (xml != null && xml.length() > 0) {
            try {
                Element root = null;
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                StringReader reader = new StringReader(xml);
                InputSource source = new InputSource(reader);
                root = parser.parse(source).getDocumentElement();
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element element;
                    String nodeName;
                    Node node = list.item(i);
                    short nt = node.getNodeType();
                    if (nt == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase(ELEMENT_PERSPECTIVE)) {
                        String type = element.getAttribute(ATTR_TYPE_ID);
                        String mode = element.getAttribute(ATTR_MODE_ID);
                        String perpsective = element.getAttribute(ATTR_PERSPECTIVE_ID);
                        this.internalSetLaunchPerspective(type, mode, perpsective);
                    }
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
                DebugUIPlugin.log(e);
            }
            catch (SAXException e) {
                DebugUIPlugin.log(e);
            }
            catch (IOException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    public void schedulePostSwitch(Job job) {
        this.fPerspectiveSwitchLock.schedulePostSwitch(job);
    }

    static /* synthetic */ void access$3(PerspectiveManager perspectiveManager, IWorkbenchWindow iWorkbenchWindow) {
        perspectiveManager.doShowDebugView(iWorkbenchWindow);
    }

    public class PerspectiveSwitchLock {
        private int fSwitch = 0;
        private List fJobs = new ArrayList();

        public synchronized void startSwitch() {
            ++this.fSwitch;
        }

        public synchronized void endSwitch() {
            --this.fSwitch;
            if (this.fSwitch == 0) {
                Iterator jobs = this.fJobs.iterator();
                while (jobs.hasNext()) {
                    ((Job)jobs.next()).schedule();
                }
                this.fJobs.clear();
            }
        }

        public synchronized void schedulePostSwitch(Job job) {
            if (this.fSwitch > 0) {
                this.fJobs.add(job);
            } else {
                job.schedule();
            }
        }
    }
}

