/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.text.MessageFormat;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class CommonSourceNotFoundEditorInput
extends PlatformObject
implements IEditorInput {
    protected String fLabel;
    protected Object fObject;

    public CommonSourceNotFoundEditorInput(Object object) {
        this.fObject = object;
        if (object != null) {
            IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation();
            this.fLabel = pres.getText(object);
            pres.dispose();
        }
        if (this.fLabel == null) {
            this.fLabel = "";
        }
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getDefaultImageDescriptor(this.fObject);
    }

    public String getName() {
        return this.fLabel;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return MessageFormat.format(SourceLookupUIMessages.addSourceLocation_editorMessage, this.fLabel);
    }

    public Object getObject() {
        return this.fObject;
    }
}

