/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractDebugEventHandler
implements IDebugEventSetListener {
    private AbstractDebugView fView;
    private List fEventSetQueue = new ArrayList();
    private List fDataQueue = new ArrayList();
    private Object LOCK = new Object();
    private EventProcessingJob fUpdateJob = new EventProcessingJob();
    protected static final DebugEvent[] EMPTY_EVENT_SET = new DebugEvent[0];
    private Object NULL = new Object();

    public AbstractDebugEventHandler(AbstractDebugView view) {
        this.setView(view);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        if (!this.isAvailable()) {
            return;
        }
        if ((events = this.filterEvents(events)).length == 0) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            events = this.doPreprocessEvents(events);
            if (events.length == 0) {
                return;
            }
            this.fEventSetQueue.add(events);
            if (this.fDataQueue.size() < this.fEventSetQueue.size()) {
                this.fDataQueue.add(this.NULL);
            }
        }
        this.fUpdateJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueData(Object data) {
        Object object = this.LOCK;
        synchronized (object) {
            this.fDataQueue.add(data);
        }
    }

    protected DebugEvent[] doPreprocessEvents(DebugEvent[] events) {
        return events;
    }

    protected DebugEvent[] filterEvents(DebugEvent[] events) {
        return events;
    }

    protected void updateForDebugEvents(DebugEvent[] events, Object data) {
    }

    protected abstract void doHandleDebugEvents(DebugEvent[] var1, Object var2);

    protected void insert(Object element) {
        Object parent;
        if (this.isAvailable() && (parent = ((ITreeContentProvider)this.getTreeViewer().getContentProvider()).getParent(element)) != null) {
            this.getView().showViewer();
            this.getTreeViewer().add(parent, element);
        }
    }

    protected void remove(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().remove(element);
        }
    }

    protected void labelChanged(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().update(element, new String[]{"org.eclipse.jface.text"});
        }
    }

    protected void refresh(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().refresh(element);
        }
    }

    public void refresh() {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().refresh();
        }
    }

    protected void selectAndReveal(Object element) {
        if (this.isAvailable()) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(element), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.removeDebugEventListener((IDebugEventSetListener)this);
        Object object = this.LOCK;
        synchronized (object) {
            this.fEventSetQueue.clear();
            this.fDataQueue.clear();
        }
    }

    protected AbstractDebugView getView() {
        return this.fView;
    }

    private void setView(AbstractDebugView view) {
        this.fView = view;
    }

    protected Viewer getViewer() {
        return this.getView().getViewer();
    }

    protected TreeViewer getTreeViewer() {
        if (this.getViewer() instanceof TreeViewer) {
            return (TreeViewer)this.getViewer();
        }
        return null;
    }

    protected boolean isAvailable() {
        return this.getView().isAvailable();
    }

    protected boolean isViewVisible() {
        return this.getView().isVisible();
    }

    protected void viewBecomesVisible() {
        this.refresh();
    }

    protected void viewBecomesHidden() {
    }

    private class EventProcessingJob
    extends UIJob {
        private static final int TIMEOUT = 200;

        public EventProcessingJob() {
            super(DebugUIViewsMessages.AbstractDebugEventHandler_0);
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            boolean more = true;
            long start = System.currentTimeMillis();
            while (more) {
                long current;
                DebugEvent[] eventSet = null;
                Object data = null;
                Object object = AbstractDebugEventHandler.this.LOCK;
                synchronized (object) {
                    if (AbstractDebugEventHandler.this.fEventSetQueue.isEmpty()) {
                        return Status.OK_STATUS;
                    }
                    eventSet = (DebugEvent[])AbstractDebugEventHandler.this.fEventSetQueue.remove(0);
                    more = !AbstractDebugEventHandler.this.fEventSetQueue.isEmpty();
                    data = AbstractDebugEventHandler.this.fDataQueue.remove(0);
                    if (data == AbstractDebugEventHandler.this.NULL) {
                        data = null;
                    }
                }
                if (AbstractDebugEventHandler.this.isAvailable()) {
                    if (AbstractDebugEventHandler.this.isViewVisible()) {
                        AbstractDebugEventHandler.this.doHandleDebugEvents(eventSet, data);
                    }
                    AbstractDebugEventHandler.this.updateForDebugEvents(eventSet, data);
                }
                if (more && (current = System.currentTimeMillis()) - start > 200L) break;
            }
            if (more) {
                this.schedule(50L);
            }
            return Status.OK_STATUS;
        }
    }
}

