/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IActivityPatternBinding;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.contexts.ContextManagerEvent;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IContextManagerListener;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.contexts.NotDefinedException;
import org.eclipse.ui.progress.UIJob;

public class LaunchViewContextListener
implements IContextManagerListener,
IActivityManagerListener {
    private static final String DEBUG_MODEL_ACTIVITY_SUFFIX = "/debugModel";
    public static final String ID_CONTEXT_VIEW_BINDINGS = "contextViewBindings";
    public static final String ID_DEBUG_MODEL_CONTEXT_BINDINGS = "debugModelContextBindings";
    public static final String ATTR_CONTEXT_ID = "contextId";
    public static final String ATTR_VIEW_ID = "viewId";
    public static final String ATTR_DEBUG_MODEL_ID = "debugModelId";
    public static final String ATTR_AUTO_OPEN = "autoOpen";
    public static final String ATTR_AUTO_CLOSE = "autoClose";
    private LaunchView launchView;
    private Map modelsToContexts = new HashMap();
    private List modelPatternBindings = new ArrayList();
    private Set enabledActivities;
    private Map modelsToActivities = new HashMap();
    private Map contextViews = new HashMap();
    private Set managedViewIds = new HashSet();
    private Set viewIdsToNotOpen = new HashSet();
    private Map openedViewIds = new HashMap();
    private Map fContextSubmissions = new HashMap();
    public static final String DEBUG_CONTEXT = "org.eclipse.debug.ui.debugging";
    public static final String PREF_VIEWS_TO_NOT_OPEN = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".views_to_not_open";
    public static final String PREF_OPENED_VIEWS = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".opened_views";
    private List lastEnabledIds = new ArrayList();
    private boolean fIsTrackingPartChanges;
    private List fAutoManagePerspectives = new ArrayList();
    static /* synthetic */ Class class$0;

    public LaunchViewContextListener(LaunchView view) {
        this.launchView = view;
        this.loadTrackViews();
        this.loadDebugModelContextExtensions();
        this.loadDebugModelActivityExtensions();
        this.loadContextToViewExtensions(true);
        this.loadOpenedViews();
        this.loadViewsToNotOpen();
        this.loadAutoManagePerspectives();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getContextSupport().getContextManager().addContextManagerListener((IContextManagerListener)this);
        IActivityManager activityManager = workbench.getActivitySupport().getActivityManager();
        activityManager.addActivityManagerListener((IActivityManagerListener)this);
        this.enabledActivities = activityManager.getEnabledActivityIds();
    }

    private void loadContextToViewExtensions(boolean reloadContextMappings) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_CONTEXT_VIEW_BINDINGS);
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            block6: {
                String viewId;
                block5: {
                    IConfigurationElement element = configurationElements[i];
                    viewId = LaunchViewContextListener.getViewId(element);
                    if (!reloadContextMappings) break block5;
                    String contextId = element.getAttribute(ATTR_CONTEXT_ID);
                    if (contextId == null || viewId == null) break block6;
                    ArrayList<IConfigurationElement> elements = (ArrayList<IConfigurationElement>)this.contextViews.get(contextId);
                    if (elements == null) {
                        elements = new ArrayList<IConfigurationElement>();
                        this.contextViews.put(contextId, elements);
                    }
                    elements.add(element);
                }
                this.managedViewIds.add(viewId);
            }
            ++i;
        }
    }

    private void loadDebugModelContextExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_DEBUG_MODEL_CONTEXT_BINDINGS);
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            String modelIdentifier = element.getAttribute(ATTR_DEBUG_MODEL_ID);
            String contextId = element.getAttribute(ATTR_CONTEXT_ID);
            if (modelIdentifier != null && contextId != null) {
                ArrayList<String> contextIds = (ArrayList<String>)this.modelsToContexts.get(modelIdentifier);
                if (contextIds == null) {
                    contextIds = new ArrayList<String>();
                    this.modelsToContexts.put(modelIdentifier, contextIds);
                }
                contextIds.add(contextId);
            }
            ++i;
        }
    }

    private void loadDebugModelActivityExtensions() {
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        Set activityIds = activityManager.getDefinedActivityIds();
        Iterator activityIterator = activityIds.iterator();
        while (activityIterator.hasNext()) {
            String activityId = (String)activityIterator.next();
            IActivity activity = activityManager.getActivity(activityId);
            if (activity == null) continue;
            Set patternBindings = activity.getActivityPatternBindings();
            Iterator patternIterator = patternBindings.iterator();
            while (patternIterator.hasNext()) {
                IActivityPatternBinding patternBinding = (IActivityPatternBinding)patternIterator.next();
                String pattern = patternBinding.getPattern().pattern();
                if (!pattern.endsWith(DEBUG_MODEL_ACTIVITY_SUFFIX)) continue;
                this.modelPatternBindings.add(patternBinding);
            }
        }
    }

    private List getConfigurationElements(String contextId) {
        ArrayList<String> configuredViewIds = new ArrayList<String>();
        ArrayList<IConfigurationElement> allConfigurationElements = new ArrayList<IConfigurationElement>();
        IContextManager contextManager = PlatformUI.getWorkbench().getContextSupport().getContextManager();
        while (contextId != null) {
            IContext context;
            List configurationElements = (List)this.contextViews.get(contextId);
            if (configurationElements != null) {
                ListIterator iter = configurationElements.listIterator();
                while (iter.hasNext()) {
                    IConfigurationElement element = (IConfigurationElement)iter.next();
                    String viewId = element.getAttribute(ATTR_VIEW_ID);
                    if (viewId == null) continue;
                    if (!configuredViewIds.contains(viewId)) {
                        allConfigurationElements.add(element);
                    }
                    configuredViewIds.add(viewId);
                }
            }
            if ((context = contextManager.getContext(contextId)) == null) continue;
            try {
                contextId = context.getParentId();
            }
            catch (NotDefinedException notDefinedException) {
                contextId = null;
            }
        }
        return allConfigurationElements;
    }

    private void saveViewsToNotOpen() {
        this.saveViewCollection(PREF_VIEWS_TO_NOT_OPEN, this.viewIdsToNotOpen);
    }

    private void saveOpenedViews() {
        this.saveViewMap(PREF_OPENED_VIEWS, this.openedViewIds);
    }

    public void saveViewCollection(String attribute, Set collection) {
        StringBuffer views = new StringBuffer();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            views.append((String)iter.next()).append(',');
        }
        if (views.length() > 0) {
            IPreferenceStore preferenceStore = DebugUITools.getPreferenceStore();
            preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.launchView);
            preferenceStore.setValue(attribute, views.toString());
            preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.launchView);
        }
    }

    private void saveViewMap(String attribute, Map map) {
        StringBuffer views = new StringBuffer();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String perspId = (String)iter.next();
            Set viewIds = (Set)map.get(perspId);
            views.append("/");
            views.append(perspId);
            if (viewIds == null || viewIds.isEmpty()) continue;
            views.append(":");
            Iterator viewsIter = viewIds.iterator();
            while (viewsIter.hasNext()) {
                String viewId = (String)viewsIter.next();
                views.append(viewId);
                views.append(",");
            }
        }
        if (views.length() > 0) {
            IPreferenceStore preferenceStore = DebugUITools.getPreferenceStore();
            preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.launchView);
            preferenceStore.setValue(attribute, views.toString());
            preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.launchView);
        }
    }

    public void loadViewsToNotOpen() {
        this.loadViewCollection(PREF_VIEWS_TO_NOT_OPEN, this.viewIdsToNotOpen);
    }

    public void loadOpenedViews() {
        this.loadViewMap(PREF_OPENED_VIEWS, this.openedViewIds);
    }

    public void loadViewCollection(String attribute, Set collection) {
        collection.clear();
        String views = DebugUITools.getPreferenceStore().getString(attribute);
        int startIndex = 0;
        int endIndex = views.indexOf(44);
        if (endIndex == -1) {
            endIndex = views.length();
        }
        while (startIndex < views.length() - 1) {
            String viewId = views.substring(startIndex, endIndex);
            if (viewId.length() > 0) {
                collection.add(viewId);
            }
            startIndex = endIndex + 1;
            endIndex = views.indexOf(44, startIndex);
        }
    }

    private void loadViewMap(String attribute, Map map) {
        map.clear();
        String views = DebugUITools.getPreferenceStore().getString(attribute);
        if (views.startsWith("/")) {
            String[] viewsStr = views.split("/");
            int i = 0;
            while (i < viewsStr.length) {
                String[] data;
                if (viewsStr[i].length() != 0 && (data = viewsStr[i].split(":")).length == 2) {
                    String perspId = data[0];
                    String[] viewIds = data[1].split(",");
                    HashSet<String> list = new HashSet<String>();
                    int j = 0;
                    while (j < viewIds.length) {
                        list.add(viewIds[j]);
                        ++j;
                    }
                    this.openedViewIds.put(perspId, list);
                }
                ++i;
            }
        }
    }

    public void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
        Set enabled = this.getNewlyEnabledContexts(contextManagerEvent);
        Set disabled = this.getNewlyDisabledContexts(contextManagerEvent);
        this.contextEnabled(enabled);
        this.contextsDisabled(disabled);
    }

    private Set getNewlyEnabledContexts(ContextManagerEvent contextManagerEvent) {
        HashSet set = new HashSet(contextManagerEvent.getContextManager().getEnabledContextIds());
        set.removeAll(contextManagerEvent.getPreviouslyEnabledContextIds());
        return set;
    }

    private Set getNewlyDisabledContexts(ContextManagerEvent contextManagerEvent) {
        HashSet set = new HashSet(contextManagerEvent.getPreviouslyEnabledContextIds());
        set.removeAll(contextManagerEvent.getContextManager().getEnabledContextIds());
        return set;
    }

    public void contextEnabled(final Set contextIds) {
        if (!this.isAutoManageViews()) {
            return;
        }
        UIJob openViewsJob = new UIJob("Open Context-Enabled Views"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IViewPart view;
                IWorkbenchPage page = LaunchViewContextListener.this.getPage();
                if (page == null) {
                    return Status.OK_STATUS;
                }
                if (page.getPerspective() == null) {
                    return Status.OK_STATUS;
                }
                contextIds.remove(LaunchViewContextListener.DEBUG_CONTEXT);
                if (page == null || contextIds.size() == 0) {
                    return Status.OK_STATUS;
                }
                HashSet<IViewPart> viewsToShow = new HashSet<IViewPart>();
                HashSet viewsToOpen = new HashSet();
                LaunchViewContextListener.this.computeViewActivation(contextIds, viewsToOpen, viewsToShow);
                boolean resetTrackingPartChanges = false;
                if (LaunchViewContextListener.this.fIsTrackingPartChanges) {
                    LaunchViewContextListener.this.fIsTrackingPartChanges = false;
                    resetTrackingPartChanges = true;
                }
                Iterator iterator = viewsToOpen.iterator();
                String id = page.getPerspective().getId();
                HashSet<String> views = (HashSet<String>)LaunchViewContextListener.this.openedViewIds.get(id);
                if (views == null) {
                    views = new HashSet<String>();
                }
                while (iterator.hasNext()) {
                    String viewId = (String)iterator.next();
                    try {
                        view = page.showView(viewId, null, 3);
                        views.add(viewId);
                        viewsToShow.add(view);
                    }
                    catch (PartInitException e) {
                        DebugUIPlugin.log(e.getStatus());
                    }
                }
                if (!viewsToOpen.isEmpty()) {
                    LaunchViewContextListener.this.openedViewIds.put(id, views);
                    LaunchViewContextListener.this.saveOpenedViews();
                }
                iterator = viewsToShow.iterator();
                while (iterator.hasNext()) {
                    boolean activate = true;
                    view = (IViewPart)iterator.next();
                    IViewPart[] stackedViews = page.getViewStack(view);
                    if (stackedViews == null) continue;
                    int i = 0;
                    while (i < stackedViews.length) {
                        IViewPart stackedView = stackedViews[i];
                        if (view == stackedView) break;
                        if (viewsToShow.contains(stackedView)) {
                            activate = false;
                            break;
                        }
                        ++i;
                    }
                    if (!activate) continue;
                    page.bringToTop((IWorkbenchPart)view);
                }
                if (resetTrackingPartChanges) {
                    LaunchViewContextListener.this.loadTrackViews();
                }
                return Status.OK_STATUS;
            }
        };
        openViewsJob.setSystem(true);
        PerspectiveManager manager = DebugUIPlugin.getDefault().getPerspectiveManager();
        if (this.isBoundToViews(contextIds)) {
            manager.schedulePostSwitch((Job)openViewsJob);
        }
    }

    private boolean isBoundToViews(Set contextIds) {
        HashSet possibleViewsToShow = new HashSet();
        Iterator iter = contextIds.iterator();
        while (iter.hasNext()) {
            String contextId = (String)iter.next();
            Set viewIds = this.getApplicableViewIds(contextId);
            possibleViewsToShow.addAll(viewIds);
        }
        return !possibleViewsToShow.isEmpty();
    }

    private void computeViewActivation(Set contextIds, Set viewIdsToOpen, Set viewIdsShow) {
        IWorkbenchPage page = this.getPage();
        if (page == null) {
            return;
        }
        Iterator contexts = contextIds.iterator();
        while (contexts.hasNext()) {
            String contextId = (String)contexts.next();
            Iterator configurationElements = this.getConfigurationElements(contextId).iterator();
            while (configurationElements.hasNext()) {
                IViewReference reference;
                IConfigurationElement element = (IConfigurationElement)configurationElements.next();
                String viewId = LaunchViewContextListener.getViewId(element);
                if (viewId == null || (reference = page.findViewReference(viewId)) != null && reference.isFastView()) continue;
                IViewPart view = page.findView(viewId);
                if (view != null) {
                    viewIdsShow.add(view);
                    continue;
                }
                if (!LaunchViewContextListener.isAutoOpen(element) || this.viewIdsToNotOpen.contains(viewId)) continue;
                viewIdsToOpen.add(viewId);
            }
        }
    }

    public void contextsDisabled(Set contexts) {
        IWorkbenchPage page = this.getPage();
        if (page == null || contexts.size() == 0 || !this.isAutoManageViews()) {
            return;
        }
        Set viewsToClose = this.getViewIdsToClose(contexts);
        if (viewsToClose.isEmpty()) {
            return;
        }
        boolean resetTrackingPartChanges = false;
        if (this.fIsTrackingPartChanges) {
            this.fIsTrackingPartChanges = false;
            resetTrackingPartChanges = true;
        }
        Iterator iter = viewsToClose.iterator();
        String perspId = page.getPerspective().getId();
        Set viewIds = (Set)this.openedViewIds.get(perspId);
        while (iter.hasNext()) {
            String viewId = (String)iter.next();
            IViewReference view = page.findViewReference(viewId);
            if (view == null) continue;
            page.hideView(view);
            if (viewIds == null) continue;
            viewIds.remove(viewId);
        }
        this.saveOpenedViews();
        if (resetTrackingPartChanges) {
            this.loadTrackViews();
        }
    }

    public Set getViewIdsToClose(Set contextIds) {
        HashSet<String> viewIdsToClose = new HashSet<String>();
        Set viewIdsToKeepOpen = this.getViewIdsForEnabledContexts();
        Iterator contexts = contextIds.iterator();
        IWorkbenchPage page = this.getPage();
        if (page == null) {
            return viewIdsToClose;
        }
        if (page.getPerspective() == null) {
            return viewIdsToClose;
        }
        String currentPerspId = page.getPerspective().getId();
        Set viewIds = (Set)this.openedViewIds.get(currentPerspId);
        while (contexts.hasNext()) {
            String contextId = (String)contexts.next();
            List list = this.getConfigurationElements(contextId);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String viewId;
                IConfigurationElement element = (IConfigurationElement)iter.next();
                if (!LaunchViewContextListener.isAutoClose(element) || (viewId = LaunchViewContextListener.getViewId(element)) == null || viewIds == null || !viewIds.contains(viewId) || viewIdsToKeepOpen.contains(viewId)) continue;
                viewIdsToClose.add(viewId);
            }
        }
        return viewIdsToClose;
    }

    protected Set getViewIdsForEnabledContexts() {
        HashSet viewIds = new HashSet();
        Iterator enabledContexts = PlatformUI.getWorkbench().getContextSupport().getContextManager().getEnabledContextIds().iterator();
        while (enabledContexts.hasNext()) {
            String contextId = (String)enabledContexts.next();
            if (contextId.equals(DEBUG_CONTEXT)) continue;
            viewIds.addAll(this.getApplicableViewIds(contextId));
        }
        return viewIds;
    }

    public Set getApplicableViewIds(String contextId) {
        HashSet<String> viewIds = new HashSet<String>();
        Iterator elements = this.getConfigurationElements(contextId).iterator();
        while (elements.hasNext()) {
            String viewId = LaunchViewContextListener.getViewId((IConfigurationElement)elements.next());
            if (viewId == null) continue;
            viewIds.add(viewId);
        }
        return viewIds;
    }

    public void updateForSelection(Object selection) {
        ILaunch launch = LaunchViewContextListener.getLaunch(selection);
        if (launch == null) {
            return;
        }
        String[] modelIds = this.getDebugModelIdsForSelection(selection);
        this.enableContexts(this.getContextsForModels(modelIds), launch);
        this.enableActivitiesFor(modelIds);
    }

    protected static ILaunch getLaunch(Object selection) {
        ILaunch launch = null;
        if (selection instanceof ILaunch) {
            launch = (ILaunch)selection;
        } else if (selection instanceof IDebugElement) {
            launch = ((IDebugElement)selection).getLaunch();
        } else if (selection instanceof IProcess) {
            launch = ((IProcess)selection).getLaunch();
        }
        return launch;
    }

    protected String[] getDebugModelIdsForSelection(Object selection) {
        if (selection instanceof IAdaptable) {
            String[] modelIds;
            IDebugModelProvider modelProvider;
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((modelProvider = (IDebugModelProvider)iAdapterManager.getAdapter(selection, (Class)clazz)) != null && (modelIds = modelProvider.getModelIdentifiers()) != null) {
                return modelIds;
            }
        }
        if (selection instanceof IStackFrame) {
            return new String[]{((IStackFrame)selection).getModelIdentifier()};
        }
        return new String[0];
    }

    protected List getContextsForModels(String[] modelIds) {
        ArrayList contextIds = new ArrayList();
        int i = 0;
        while (i < modelIds.length) {
            ArrayList<String> ids = (ArrayList<String>)this.modelsToContexts.get(modelIds[i]);
            if (ids == null) {
                ids = new ArrayList<String>();
                ids.add(DEBUG_CONTEXT);
                this.modelsToContexts.put(modelIds[i], ids);
            }
            contextIds.addAll(ids);
            ++i;
        }
        return contextIds;
    }

    protected void enableActivitiesFor(String[] modelIds) {
        HashSet newActivities = null;
        int i = 0;
        while (i < modelIds.length) {
            String id = modelIds[i];
            HashSet<String> ids = (HashSet<String>)this.modelsToActivities.get(id);
            if (ids == null) {
                ids = new HashSet<String>();
                this.modelsToActivities.put(id, ids);
                Iterator bindings = this.modelPatternBindings.iterator();
                while (bindings.hasNext()) {
                    IActivityPatternBinding binding = (IActivityPatternBinding)bindings.next();
                    String regex = binding.getPattern().pattern();
                    if (!Pattern.matches(regex = regex.substring(0, regex.length() - DEBUG_MODEL_ACTIVITY_SUFFIX.length()), id)) continue;
                    ids.add(binding.getActivityId());
                }
            }
            if (!this.enabledActivities.containsAll(ids)) {
                if (newActivities == null) {
                    newActivities = new HashSet();
                }
                newActivities.addAll(ids);
            }
            ++i;
        }
        if (newActivities != null) {
            IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
            HashSet idsToEnable = new HashSet(this.enabledActivities.size() + newActivities.size());
            idsToEnable.addAll(this.enabledActivities);
            idsToEnable.addAll(newActivities);
            activitySupport.setEnabledActivityIds(idsToEnable);
        }
    }

    protected void enableContexts(List contextIds, ILaunch launch) {
        if (contextIds.isEmpty()) {
            return;
        }
        SortedSet enabledContexts = PlatformUI.getWorkbench().getContextSupport().getContextManager().getEnabledContextIds();
        HashSet<String> contextsAlreadyEnabled = new HashSet<String>();
        Iterator iter = contextIds.iterator();
        while (iter.hasNext()) {
            String contextId = (String)iter.next();
            if (!enabledContexts.contains(contextId) || this.lastEnabledIds.contains(contextId)) continue;
            contextsAlreadyEnabled.add(contextId);
        }
        this.lastEnabledIds.clear();
        this.lastEnabledIds.addAll(contextIds);
        this.submitContexts(contextIds, launch);
        this.contextEnabled(contextsAlreadyEnabled);
    }

    protected void submitContexts(List contextIds, ILaunch launch) {
        ArrayList submissions = (ArrayList)this.fContextSubmissions.get(launch);
        if (submissions == null) {
            submissions = new ArrayList();
            this.fContextSubmissions.put(launch, submissions);
        }
        ArrayList<EnabledSubmission> newSubmissions = new ArrayList<EnabledSubmission>();
        Iterator iter = contextIds.iterator();
        while (iter.hasNext()) {
            newSubmissions.add(new EnabledSubmission(null, null, null, (String)iter.next()));
        }
        IWorkbenchContextSupport contextSupport = PlatformUI.getWorkbench().getContextSupport();
        if (!newSubmissions.isEmpty()) {
            contextSupport.addEnabledSubmissions(newSubmissions);
            ArrayList<EnabledSubmission> submissionsToRemove = new ArrayList<EnabledSubmission>();
            ListIterator oldSubmissions = submissions.listIterator();
            while (oldSubmissions.hasNext()) {
                EnabledSubmission oldSubmission = (EnabledSubmission)oldSubmissions.next();
                String contextId = oldSubmission.getContextId();
                if (!contextIds.contains(contextId)) continue;
                oldSubmissions.remove();
                submissionsToRemove.add(oldSubmission);
            }
            contextSupport.removeEnabledSubmissions(submissionsToRemove);
            submissions.addAll(newSubmissions);
        }
    }

    protected void launchesTerminated(ILaunch[] launches) {
        ArrayList allSubmissions = new ArrayList();
        int i = 0;
        while (i < launches.length) {
            List submissions = (List)this.fContextSubmissions.remove(launches[i]);
            if (submissions != null) {
                allSubmissions.addAll(submissions);
            }
            ++i;
        }
        PlatformUI.getWorkbench().getContextSupport().removeEnabledSubmissions(allSubmissions);
    }

    public static String getViewId(IConfigurationElement element) {
        return element.getAttribute(ATTR_VIEW_ID);
    }

    public static boolean isAutoOpen(IConfigurationElement element) {
        String autoOpen = element.getAttribute(ATTR_AUTO_OPEN);
        return autoOpen == null || Boolean.valueOf(autoOpen) != false;
    }

    public static boolean isAutoClose(IConfigurationElement element) {
        String autoClose = element.getAttribute(ATTR_AUTO_CLOSE);
        return autoClose == null || Boolean.valueOf(autoClose) != false;
    }

    private boolean isAutoManageViews() {
        IPerspectiveDescriptor descriptor;
        IWorkbenchPage page = this.launchView.getViewSite().getPage();
        if (page != null && (descriptor = page.getPerspective()) != null) {
            return this.fAutoManagePerspectives.contains(descriptor.getId());
        }
        return false;
    }

    public IWorkbenchPage getPage() {
        return this.launchView.getSite().getPage();
    }

    public void perspectiveChanged(String changeId) {
        if (changeId.equals("reset")) {
            this.fIsTrackingPartChanges = false;
        } else if (changeId.equals("resetComplete")) {
            this.loadTrackViews();
        }
    }

    public void perspectiveChanged(IWorkbenchPartReference ref, String changeId) {
        if (!this.fIsTrackingPartChanges) {
            return;
        }
        if ("viewHide".equals(changeId) && ref instanceof IViewReference) {
            String id = ((IViewReference)ref).getId();
            if (this.managedViewIds.contains(id)) {
                this.viewIdsToNotOpen.add(id);
                this.saveViewsToNotOpen();
            }
            this.removeFromOpenedViews(id);
            this.saveOpenedViews();
        } else if ("viewShow".equals(changeId) && ref instanceof IViewReference) {
            String id = ((IViewReference)ref).getId();
            this.removeFromOpenedViews(id);
            this.saveOpenedViews();
        }
    }

    private void removeFromOpenedViews(String viewId) {
        Iterator keys = this.openedViewIds.keySet().iterator();
        while (keys.hasNext()) {
            String perspId = (String)keys.next();
            Set views = (Set)this.openedViewIds.get(perspId);
            if (views == null) continue;
            views.remove(viewId);
        }
    }

    public void loadTrackViews() {
        this.fIsTrackingPartChanges = DebugUITools.getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_TRACK_VIEWS);
    }

    private void loadAutoManagePerspectives() {
        String prefString = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES);
        this.fAutoManagePerspectives = LaunchViewContextListener.parseList(prefString);
    }

    public void reloadAutoManagePerspectives(Object selection) {
        String[] modelIds = this.getDebugModelIdsForSelection(selection);
        List contextIds = this.getContextsForModels(modelIds);
        this.lastEnabledIds.removeAll(contextIds);
        this.loadAutoManagePerspectives();
        this.updateForSelection(selection);
    }

    public void reloadViewsToNotOpen(Object selection) {
        String[] modelIds = this.getDebugModelIdsForSelection(selection);
        List contextIds = this.getContextsForModels(modelIds);
        this.lastEnabledIds.removeAll(contextIds);
        this.loadViewsToNotOpen();
        this.updateForSelection(selection);
    }

    public static List parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    public void dispose() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getContextSupport().getContextManager().removeContextManagerListener((IContextManagerListener)this);
        workbench.getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
    }

    protected void clearLastEnabledContexts() {
        this.lastEnabledIds.clear();
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
            this.enabledActivities = activityManagerEvent.getActivityManager().getEnabledActivityIds();
        }
    }
}

