/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLine;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class TableRenderingCellModifier
implements ICellModifier {
    private boolean editActionInvoked = false;
    private AbstractTableRendering fRendering;

    public TableRenderingCellModifier(AbstractTableRendering rendering) {
        this.fRendering = rendering;
    }

    public boolean canModify(Object element, String property) {
        boolean canModify = true;
        try {
            if (!(element instanceof TableRenderingLine)) {
                return false;
            }
            if (!this.editActionInvoked) {
                return false;
            }
            if (this.fRendering == null) {
                return false;
            }
            if (!this.fRendering.getMemoryBlock().supportsValueModification()) {
                return false;
            }
            TableRenderingLine line = (TableRenderingLine)element;
            if ("address".equals(property)) {
                return false;
            }
            int addressableSize = this.getAddressableSize();
            int offset = Integer.valueOf(property, 16) * addressableSize;
            int end = offset + this.fRendering.getBytesPerColumn();
            int i = offset;
            while (i < end) {
                MemoryByte oneByte = line.getByte(i);
                if (!oneByte.isWritable()) {
                    canModify = false;
                }
                ++i;
            }
            return canModify;
        }
        catch (NumberFormatException numberFormatException) {
            canModify = false;
            return canModify;
        }
    }

    private int getAddressableSize() {
        int addressableSize = this.fRendering.getAddressableSize();
        if (addressableSize < 1) {
            addressableSize = 1;
        }
        return addressableSize;
    }

    public Object getValue(Object element, String property) {
        if (!(element instanceof TableRenderingLine)) {
            return null;
        }
        TableRenderingLine line = (TableRenderingLine)element;
        try {
            if ("address".equals(property)) {
                return line.getAddress();
            }
            int offset = Integer.valueOf(property, 16) * this.getAddressableSize();
            int end = offset + this.fRendering.getBytesPerColumn();
            MemoryByte[] memory = line.getBytes(offset, end);
            if (line.isAvailable(offset, end)) {
                offset = Integer.valueOf(property, 16);
                BigInteger address = new BigInteger(((TableRenderingLine)element).getAddress(), 16);
                address = address.add(BigInteger.valueOf(offset));
                return this.fRendering.getString(this.fRendering.getRenderingId(), address, memory);
            }
            return this.getPaddedString(offset, end);
        }
        catch (NumberFormatException numberFormatException) {
            return "00";
        }
    }

    public void modify(Object element, String property, Object value) {
        TableRenderingLine line = null;
        line = !(element instanceof TableRenderingLine) ? (TableRenderingLine)((TableItem)element).getData() : (TableRenderingLine)element;
        if (!(value instanceof String)) {
            return;
        }
        try {
            IMemoryBlock memoryBlk = this.fRendering.getMemoryBlock();
            int lineOffset = Integer.valueOf(property, 16);
            BigInteger offset = this.getOffset(memoryBlk, line.getAddress(), lineOffset);
            byte[] bytes = null;
            String oldValue = (String)this.getValue(line, property);
            if (!oldValue.equals(value)) {
                int offsetToLine = Integer.valueOf(property, 16) * this.getAddressableSize();
                int end = offsetToLine + this.fRendering.getBytesPerColumn();
                MemoryByte[] oldArray = line.getBytes(offsetToLine, end);
                BigInteger address = new BigInteger(line.getAddress(), 16);
                address = address.add(BigInteger.valueOf(offsetToLine));
                bytes = this.fRendering.getBytes(this.fRendering.getRenderingId(), address, oldArray, (String)value);
                if (bytes == null) {
                    return;
                }
                if (bytes.length == 0) {
                    return;
                }
                if (bytes.length <= oldArray.length) {
                    boolean changed = false;
                    int i = 0;
                    while (i < bytes.length) {
                        if (bytes[i] != oldArray[i].getValue()) {
                            changed = true;
                            break;
                        }
                        ++i;
                    }
                    if (!changed) {
                        return;
                    }
                }
            } else {
                return;
            }
            if (memoryBlk instanceof IMemoryBlockExtension) {
                ((IMemoryBlockExtension)memoryBlk).setValue(offset, bytes);
            } else {
                memoryBlk.setValue(offset.longValue(), bytes);
            }
        }
        catch (DebugException e) {
            MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_failed, (Exception)((Object)e));
        }
        catch (NumberFormatException numberFormatException) {
            MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, String.valueOf(DebugUIMessages.MemoryViewCellModifier_failed) + "\n" + DebugUIMessages.MemoryViewCellModifier_data_is_invalid, null);
        }
    }

    private BigInteger getOffset(IMemoryBlock memory, String lineAddress, int lineOffset) throws DebugException {
        BigInteger lineAddr = new BigInteger(lineAddress, 16);
        BigInteger memoryAddr = memory instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)memory).getBigBaseAddress() : BigInteger.valueOf(memory.getStartAddress());
        if (memoryAddr == null) {
            memoryAddr = new BigInteger("0");
        }
        return lineAddr.subtract(memoryAddr).add(BigInteger.valueOf(lineOffset));
    }

    public void setEditActionInvoked(boolean editActionInvoked) {
        this.editActionInvoked = editActionInvoked;
    }

    public String getPaddedString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_PADDED_STR);
        int i = start;
        while (i < end) {
            buf.append(paddedStr);
            ++i;
        }
        return buf.toString();
    }
}

