/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.internal.ui.views.RemoteTreeContentManager;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.AbstractDebugView;

public class VariablesViewEventHandler
extends AbstractDebugEventHandler {
    private RemoteTreeContentManager fContentManager = null;

    public VariablesViewEventHandler(AbstractDebugView view) {
        super(view);
    }

    protected void doHandleDebugEvents(DebugEvent[] events, Object data) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 2: {
                    this.doHandleSuspendEvent(event);
                    break;
                }
                case 16: {
                    this.doHandleChangeEvent(event);
                    break;
                }
                case 1: {
                    this.doHandleResumeEvent(event);
                }
            }
            ++i;
        }
    }

    protected void updateForDebugEvents(DebugEvent[] events, Object data) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 8: {
                    this.doHandleTerminateEvent(event);
                }
            }
            ++i;
        }
    }

    protected void doHandleResumeEvent(DebugEvent event) {
        Object input;
        if (!event.isStepStart() && !event.isEvaluation()) {
            this.getVariablesView().clearExpandedVariables(event.getSource());
        }
        if (!event.isEvaluation() && (input = this.getVariablesView().getVariablesViewer().getInput()) instanceof IStackFrame) {
            IStackFrame frame = (IStackFrame)input;
            if (event.getSource().equals(frame.getThread())) {
                this.fContentManager.cancel();
            }
        }
    }

    protected void doHandleTerminateEvent(DebugEvent event) {
        this.getVariablesView().clearExpandedVariables(event.getSource());
    }

    protected void doHandleSuspendEvent(DebugEvent event) {
        if (event.getDetail() != 128) {
            if (event.getSource() instanceof ISuspendResume && !((ISuspendResume)event.getSource()).isSuspended()) {
                return;
            }
            this.refresh();
            this.getVariablesView().populateDetailPane();
        }
    }

    protected void doHandleChangeEvent(DebugEvent event) {
        if (event.getDetail() == 256) {
            if (event.getSource() instanceof IVariable) {
                this.refresh(event.getSource());
                this.getVariablesView().populateDetailPane();
            }
        } else if (!(event.getSource() instanceof IExpression)) {
            if (event.getSource() instanceof IVariable) {
                this.refresh(event.getSource());
            } else {
                this.refresh();
            }
            this.getVariablesView().populateDetailPane();
        }
    }

    protected VariablesView getVariablesView() {
        return (VariablesView)this.getView();
    }

    protected void viewBecomesVisible() {
        super.viewBecomesVisible();
        this.getVariablesView().populateDetailPane();
    }

    protected DebugEvent[] filterEvents(DebugEvent[] events) {
        ArrayList<DebugEvent> filtered = null;
        int i = 0;
        while (i < events.length) {
            if (this.isFiltered(events[i])) {
                if (events.length == 1) {
                    return EMPTY_EVENT_SET;
                }
                if (filtered == null) {
                    filtered = new ArrayList<DebugEvent>();
                }
                filtered.add(events[i]);
            }
            ++i;
        }
        if (filtered == null) {
            return events;
        }
        if (filtered.size() == events.length) {
            return EMPTY_EVENT_SET;
        }
        ArrayList<DebugEvent> all = new ArrayList<DebugEvent>(events.length);
        int i2 = 0;
        while (i2 < events.length) {
            all.add(events[i2]);
            ++i2;
        }
        all.removeAll(filtered);
        return all.toArray(new DebugEvent[all.size()]);
    }

    public void setContentManager(RemoteTreeContentManager manager) {
        this.fContentManager = manager;
    }

    protected boolean isFiltered(DebugEvent event) {
        if (event.getKind() == 16) {
            Object source = event.getSource();
            switch (event.getDetail()) {
                case 512: {
                    return !(source instanceof IVariable) && !(source instanceof IStackFrame) && !(source instanceof IThread) && !(source instanceof IDebugTarget);
                }
                case 256: {
                    return !(source instanceof IVariable);
                }
            }
            return true;
        }
        return false;
    }
}

