/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.validation.internal.core.IMessageAccess;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DelegatingSourceValidator
implements IValidator {
    protected static final String ALL_ATTRIBUTES = "ALL_ATTRIBUTES";
    protected static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    protected static final String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    protected static final String START_TAG = "START_TAG";
    protected static final String TEXT = "TEXT";
    protected static final String FIRST_NON_WHITESPACE_TEXT = "FIRST_NON_WHITESPACE_TEXT";
    protected static final String TEXT_ENTITY_REFERENCE = "TEXT_ENTITY_REFERENCE";
    protected static final String VALUE_OF_ATTRIBUTE_WITH_GIVEN_VALUE = "VALUE_OF_ATTRIBUTE_WITH_GIVEN_VALUE";
    protected static final String COLUMN_NUMBER_ATTRIBUTE = "columnNumber";
    protected static final String SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = "squiggleSelectionStrategy";
    protected static final String SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = "squiggleNameOrValue";

    public void cleanup(IReporter arg0) {
    }

    protected abstract IValidator getDelegateValidator();

    /*
     * Exception decompiling
     */
    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 161->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateValidationMessages(List messages, IDOMDocument document, IReporter reporter) {
        int i = 0;
        while (i < messages.size()) {
            IMessage message = (IMessage)messages.get(i);
            try {
                if (message.getAttribute(COLUMN_NUMBER_ATTRIBUTE) != null) {
                    int column = (Integer)message.getAttribute(COLUMN_NUMBER_ATTRIBUTE);
                    String selectionStrategy = (String)message.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE);
                    String nameOrValue = (String)message.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE);
                    int start = document.getStructuredDocument().getLineOffset(message.getLineNumber() - 1) + column - 1;
                    int[] result = this.computeStartEndLocation(start, message.getText(), selectionStrategy, nameOrValue, document);
                    if (result != null) {
                        message.setOffset(result[0]);
                        message.setLength(result[1] - result[0]);
                        reporter.addMessage((IValidator)this, message);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            ++i;
        }
    }

    public IFile getFile(String delta) {
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta));
        return res instanceof IFile ? res : null;
    }

    protected IDOMModel getModelForResource(IFile file) {
        IStructuredModel model = null;
        IModelManager manager = StructuredModelManager.getModelManager();
        try {
            model = manager.getModelForRead(file);
        }
        catch (Exception exception) {}
        return model instanceof IDOMModel ? (IDOMModel)model : null;
    }

    protected int[] computeStartEndLocation(int startOffset, String errorMessage, String selectionStrategy, String nameOrValue, IDOMDocument document) {
        try {
            int[] startEndPositions = new int[2];
            IndexedRegion region = document.getModel().getIndexedRegion(startOffset);
            IndexedRegion prevRegion = document.getModel().getIndexedRegion(startOffset - 1);
            if (prevRegion != region) {
                region = prevRegion;
            }
            if (region != null) {
                startEndPositions[0] = region.getStartOffset();
                startEndPositions[1] = startEndPositions[0];
            } else {
                startEndPositions[0] = 0;
                startEndPositions[1] = 0;
            }
            if (region instanceof Node) {
                Node node = (Node)region;
                if (selectionStrategy.equals(START_TAG)) {
                    if (node.getNodeType() == 1) {
                        IDOMElement element = (IDOMElement)node;
                        startEndPositions[0] = element.getStartOffset() + 1;
                        startEndPositions[1] = startEndPositions[0] + element.getTagName().length();
                    }
                } else if (selectionStrategy.equals(ATTRIBUTE_NAME)) {
                    IDOMElement element;
                    IDOMNode attributeNode;
                    if (node.getNodeType() == 1 && (attributeNode = (IDOMNode)(element = (IDOMElement)node).getAttributeNode(nameOrValue)) != null) {
                        startEndPositions[0] = attributeNode.getStartOffset();
                        startEndPositions[1] = attributeNode.getStartOffset() + nameOrValue.length();
                    }
                } else if (selectionStrategy.equals(ATTRIBUTE_VALUE)) {
                    IDOMElement element;
                    IDOMAttr attributeNode;
                    if (node.getNodeType() == 1 && (attributeNode = (IDOMAttr)(element = (IDOMElement)node).getAttributeNode(nameOrValue)) != null) {
                        startEndPositions[0] = attributeNode.getValueRegionStartOffset();
                        startEndPositions[1] = startEndPositions[0] + attributeNode.getValueRegionText().length();
                    }
                } else if (selectionStrategy.equals(ALL_ATTRIBUTES)) {
                    IDOMElement element;
                    NamedNodeMap attributes;
                    if (node.getNodeType() == 1 && (attributes = (element = (IDOMElement)node).getAttributes()) != null) {
                        IDOMNode first = (IDOMNode)attributes.item(0);
                        IDOMNode last = (IDOMNode)attributes.item(attributes.getLength() - 1);
                        if (first != null && last != null) {
                            startEndPositions[0] = first.getStartOffset();
                            startEndPositions[1] = last.getEndOffset();
                        }
                    }
                } else if (selectionStrategy.equals(TEXT)) {
                    IDOMElement element;
                    Node child;
                    if (node.getNodeType() == 3) {
                        IDOMText textNode = (IDOMText)node;
                        int start = textNode.getStartOffset();
                        String value = textNode.getNodeValue();
                        int index = 0;
                        char curChar = value.charAt(index);
                        while (curChar == '\n' || curChar == '\t' || curChar == '\r' || curChar == ' ') {
                            curChar = value.charAt(index);
                            ++index;
                        }
                        if (index > 0) {
                            --index;
                        }
                        startEndPositions[0] = (start += index) + index;
                        startEndPositions[1] = start + value.trim().length();
                    } else if (node.getNodeType() == 1 && (child = (element = (IDOMElement)node).getFirstChild()) instanceof IDOMNode) {
                        IDOMNode xmlChild = (IDOMNode)child;
                        startEndPositions[0] = xmlChild.getStartOffset();
                        startEndPositions[1] = xmlChild.getEndOffset();
                    }
                } else if (selectionStrategy.equals(FIRST_NON_WHITESPACE_TEXT)) {
                    if (node.getNodeType() == 1) {
                        NodeList nodes = node.getChildNodes();
                        int i = 0;
                        while (i < nodes.getLength()) {
                            IDOMText textNode;
                            Node currentNode = nodes.item(i);
                            if (currentNode.getNodeType() == 3 && (textNode = (IDOMText)currentNode).getNodeValue().trim().length() > 0) {
                                String value = textNode.getNodeValue();
                                int index = 0;
                                int start = textNode.getStartOffset();
                                char curChar = value.charAt(index);
                                while (curChar == '\n' || curChar == '\t' || curChar == '\r' || curChar == ' ') {
                                    curChar = value.charAt(index);
                                    ++index;
                                }
                                if (index > 0) {
                                    --index;
                                }
                                startEndPositions[0] = start += index;
                                startEndPositions[1] = start + value.trim().length();
                                break;
                            }
                            ++i;
                        }
                    }
                } else if (selectionStrategy.equals(TEXT_ENTITY_REFERENCE)) {
                    if (node.getNodeType() == 5) {
                        startEndPositions[0] = region.getStartOffset();
                        startEndPositions[1] = region.getEndOffset();
                    }
                } else if (selectionStrategy.equals(VALUE_OF_ATTRIBUTE_WITH_GIVEN_VALUE) && node.getNodeType() == 1) {
                    NamedNodeMap attributes = node.getAttributes();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        IDOMAttr attr = (IDOMAttr)attributes.item(i);
                        String nodeValue = attr.getNodeValue().trim();
                        if (nodeValue.equals(nameOrValue)) {
                            startEndPositions[0] = attr.getValueRegionStartOffset() + 1;
                            startEndPositions[1] = startEndPositions[0] + nodeValue.length();
                            break;
                        }
                        ++i;
                    }
                }
            }
            return startEndPositions;
        }
        catch (Exception exception) {
            return null;
        }
    }

    class MyHelper
    implements IValidationContext {
        InputStream inputStream;
        IFile file;

        public MyHelper(InputStream inputStream, IFile file) {
            this.inputStream = inputStream;
            this.file = file;
        }

        public Object loadModel(String symbolicName, Object[] parms) {
            if (symbolicName.equals("getFile")) {
                return this.file;
            }
            return null;
        }

        public Object loadModel(String symbolicName) {
            if (symbolicName.equals("inputStream")) {
                return this.inputStream;
            }
            return null;
        }

        public String[] getURIs() {
            if (this.file != null) {
                return new String[]{this.file.getFullPath().toString()};
            }
            return new String[0];
        }
    }

    class MyReporter
    implements IReporter {
        List list = new ArrayList();

        public void addMessage(IValidator origin, IMessage message) {
            this.list.add(message);
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public IMessageAccess getMessageAccess() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }

        public List getMessages() {
            return this.list;
        }
    }
}

