/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.ui.StyledTextColorPicker;

public abstract class AbstractColorPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected OverlayPreferenceStore fOverlayStore;
    protected StyledTextColorPicker fPicker = null;

    protected Composite createColoringComposite(Composite parent) {
        Composite coloringComposite = this.createComposite(parent, 1);
        return coloringComposite;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
        sc1.setLayoutData((Object)new GridData(1808));
        Composite pageComponent = this.createComposite((Composite)sc1, 1);
        sc1.setContent((Control)pageComponent);
        Label descLabel = this.createDescriptionLabel(pageComponent, SSEUIMessages.AbstractColorPageDescription);
        Composite coloringComposite = this.createColoringComposite(pageComponent);
        this.createContentsForPicker(coloringComposite);
        GridData gd = (GridData)descLabel.getLayoutData();
        gd.widthHint = coloringComposite.computeSize((int)-1, (int)-1).x;
        this.setSize(pageComponent);
        return pageComponent;
    }

    protected void createContentsForPicker(Composite parent) {
        this.fPicker = new StyledTextColorPicker(parent, 0);
        GridData data = new GridData(1808);
        this.fPicker.setLayoutData(data);
        this.fPicker.setPreferenceStore(this.fOverlayStore);
        this.setupPicker(this.fPicker);
        this.fPicker.setText(this.getSampleText());
    }

    protected Label createDescriptionLabel(Composite parent, String description) {
        Label label = new Label(parent, 16448);
        label.setText(description);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData(4);
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        return null;
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(4);
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Text createTextField(Composite parent, String text) {
        Text textfield = new Text(parent, 16384);
        textfield.setText(text);
        GridData data = new GridData(4);
        data.horizontalAlignment = 4;
        textfield.setLayoutData((Object)data);
        return textfield;
    }

    public void dispose() {
        super.dispose();
        if (this.fPicker != null && !this.fPicker.isDisposed()) {
            this.fPicker.releasePickerResources();
        }
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
        }
    }

    public StyledTextColorPicker getPicker() {
        return this.fPicker;
    }

    public abstract String getSampleText();

    public void init(IWorkbench workbench) {
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.fPicker.refresh();
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        this.savePreferences();
        return true;
    }

    protected void savePreferences() {
    }

    protected void setSize(Composite composite) {
        if (composite != null) {
            Point minSize = composite.computeSize(-1, -1);
            composite.setSize(minSize);
            if (composite.getParent() instanceof ScrolledComposite) {
                ScrolledComposite sc1 = (ScrolledComposite)composite.getParent();
                sc1.setMinSize(minSize);
                sc1.setExpandHorizontal(true);
                sc1.setExpandVertical(true);
            }
        }
    }

    protected abstract void setupPicker(StyledTextColorPicker var1);

    public void setVisible(boolean visible) {
        boolean doShrink = false;
        if (visible) {
            this.getPicker().refresh();
            int x = Math.min(this.getControl().getShell().getSize().x, this.getControl().getDisplay().getClientArea().width * 9 / 10);
            int y = Math.min(this.getControl().getShell().getSize().y, this.getControl().getDisplay().getClientArea().height * 9 / 10);
            boolean shrinkWidth = x != this.getControl().getShell().getSize().x;
            boolean shrinkHeight = y != this.getControl().getShell().getSize().y;
            boolean bl = doShrink = shrinkWidth || shrinkHeight;
            if (doShrink) {
                if (shrinkHeight && !shrinkWidth) {
                    this.getShell().setBounds(this.getShell().getLocation().x, 0, this.getShell().getSize().x, this.getControl().getDisplay().getClientArea().height);
                } else if (!shrinkHeight && shrinkWidth) {
                    this.getShell().setBounds(0, this.getShell().getLocation().y, this.getControl().getDisplay().getClientArea().width, this.getShell().getSize().y);
                } else {
                    this.getShell().setBounds(0, 0, this.getControl().getDisplay().getClientArea().width, this.getControl().getDisplay().getClientArea().height);
                }
            }
        }
        super.setVisible(visible);
        if (doShrink) {
            this.getControl().getShell().redraw();
            this.getControl().getShell().update();
        }
    }
}

