/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalHelper;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ReconcileStepForValidator
extends StructuredReconcileStep {
    protected static final boolean DEBUG;
    private final IReconcileResult[] EMPTY_RECONCILE_RESULT_SET = new IReconcileResult[0];
    private IncrementalHelper fHelper = null;
    private IncrementalReporter fReporter = null;
    private int fScope = -1;
    private IValidator fValidator = null;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public ReconcileStepForValidator(IValidator v, int scope) {
        if (v == null) {
            throw new IllegalArgumentException("validator cannot be null");
        }
        this.fValidator = v;
        this.fScope = scope;
    }

    public ReconcileStepForValidator(IValidator v, IReconcileStep step, int scope) {
        super(step);
        this.fValidator = v;
        this.fScope = scope;
    }

    protected IReconcileResult[] createAnnotations(List messageList) {
        ArrayList<TemporaryAnnotation> annotations = new ArrayList<TemporaryAnnotation>();
        int i = 0;
        while (i < messageList.size()) {
            block11: {
                IMessage validationMessage = (IMessage)messageList.get(i);
                int offset = validationMessage.getOffset();
                if (offset >= 0) {
                    String messageText = null;
                    try {
                        messageText = validationMessage.getText(validationMessage.getClass().getClassLoader());
                    }
                    catch (Exception t) {
                        Logger.logException("exception reporting message from validator", t);
                        break block11;
                    }
                    String type = "org.eclipse.wst.sse.ui.temp.info";
                    switch (validationMessage.getSeverity()) {
                        case 1: {
                            type = "org.eclipse.wst.sse.ui.temp.error";
                            break;
                        }
                        case 2: {
                            type = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 4: {
                            type = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 3: {
                            type = "org.eclipse.wst.sse.ui.temp.warning";
                        }
                    }
                    int length = validationMessage.getLength();
                    if (length >= 0) {
                        Position p = new Position(offset, length);
                        ReconcileAnnotationKey key = this.createKey(this.getPartitionType(this.getDocument(), offset), this.getScope());
                        annotations.add(new TemporaryAnnotation(p, type, messageText, key));
                    }
                }
            }
            ++i;
        }
        return annotations.toArray(new IReconcileResult[annotations.size()]);
    }

    /*
     * Exception decompiling
     */
    private IFile getFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 103->106)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IncrementalHelper getHelper(IProject project) {
        if (this.fHelper == null) {
            this.fHelper = new IncrementalHelper((IDocument)this.getStructuredDocument(), project);
        }
        return this.fHelper;
    }

    private IncrementalReporter getReporter() {
        if (this.fReporter == null) {
            this.fReporter = new IncrementalReporter(this.getProgressMonitor());
        }
        return this.fReporter;
    }

    public int getScope() {
        return this.fScope;
    }

    public void initialReconcile() {
    }

    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (DEBUG) {
            System.out.println("[trace reconciler] > reconciling model in VALIDATOR step w/ dirty region: [" + dirtyRegion.getText() + "]");
        }
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        if (dirtyRegion != null) {
            try {
                results = this.validate();
            }
            catch (Exception ex) {
                Logger.logException("EXEPTION IN RECONCILE STEP FOR VALIDATOR", ex);
            }
        }
        if (DEBUG) {
            System.out.println("[trace reconciler] > VALIDATOR step done");
        }
        return results;
    }

    public String toString() {
        StringBuffer debugString = new StringBuffer("ValidatorStep: ");
        if (this.fValidator != null) {
            debugString.append(this.fValidator.getClass().toString());
        }
        return debugString.toString();
    }

    protected IReconcileResult[] validate() {
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        IFile file = this.getFile();
        if (file != null) {
            try {
                IProject project = file.getProject();
                IncrementalHelper helper = this.getHelper(project);
                IncrementalReporter reporter = this.getReporter();
                helper.setURI(file.getFullPath().toString());
                this.fValidator.validate((IValidationContext)helper, (IReporter)reporter);
                results = this.createAnnotations(reporter.getMessages());
                reporter.removeAllMessages(this.fValidator);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return results;
    }
}

