/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.internal.commands.util.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public final class DefaultOperationHistory
implements IOperationHistory {
    public static boolean DEBUG_OPERATION_HISTORY_NOTIFICATION = false;
    public static boolean DEBUG_OPERATION_HISTORY_UNEXPECTED = false;
    public static boolean DEBUG_OPERATION_HISTORY_DISPOSE = false;
    public static boolean DEBUG_OPERATION_HISTORY_OPENOPERATION = false;
    public static boolean DEBUG_OPERATION_HISTORY_APPROVAL = false;
    static final int DEFAULT_LIMIT = 20;
    List approvers = Collections.synchronizedList(new ArrayList());
    private Map limits = Collections.synchronizedMap(new HashMap());
    List listeners = Collections.synchronizedList(new ArrayList());
    private List redoList = Collections.synchronizedList(new ArrayList());
    private List undoList = Collections.synchronizedList(new ArrayList());
    final Object undoRedoHistoryLock = new Object();
    private ICompositeOperation openComposite = null;
    final Object openCompositeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IUndoableOperation operation) {
        Assert.isNotNull(operation);
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null && this.openComposite != operation) {
                this.openComposite.add(operation);
                return;
            }
        }
        if (this.checkUndoLimit(operation)) {
            object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.undoList.add(operation);
            }
            this.notifyAdd(operation);
            IUndoContext[] contexts = operation.getContexts();
            int i = 0;
            while (i < contexts.length) {
                this.flushRedo(contexts[i]);
                ++i;
            }
        }
    }

    public void addOperationApprover(IOperationApprover approver) {
        this.approvers.add(approver);
    }

    public void addOperationHistoryListener(IOperationHistoryListener listener) {
        this.listeners.add(listener);
    }

    public boolean canRedo(IUndoContext context) {
        IUndoableOperation operation = this.getRedoOperation(context);
        return operation != null && operation.canRedo();
    }

    public boolean canUndo(IUndoContext context) {
        IUndoableOperation operation = this.getUndoOperation(context);
        return operation != null && operation.canUndo();
    }

    private boolean checkRedoLimit(IUndoableOperation operation) {
        IUndoContext[] contexts = operation.getContexts();
        int i = 0;
        while (i < contexts.length) {
            int limit = this.getLimit(contexts[i]);
            if (limit > 0) {
                this.forceRedoLimit(contexts[i], limit - 1);
            } else {
                operation.removeContext(contexts[i]);
            }
            ++i;
        }
        return operation.getContexts().length > 0;
    }

    private boolean checkUndoLimit(IUndoableOperation operation) {
        IUndoContext[] contexts = operation.getContexts();
        int i = 0;
        while (i < contexts.length) {
            int limit = this.getLimit(contexts[i]);
            if (limit > 0) {
                this.forceUndoLimit(contexts[i], limit - 1);
            } else {
                operation.removeContext(contexts[i]);
            }
            ++i;
        }
        return operation.getContexts().length > 0;
    }

    public void dispose(IUndoContext context, boolean flushUndo, boolean flushRedo, boolean flushContext) {
        if (flushContext) {
            if (DEBUG_OPERATION_HISTORY_DISPOSE) {
                System.out.print("OPERATIONHISTORY >>> Flushing context ");
                System.out.print(context);
                System.out.println();
            }
            this.flushUndo(context);
            this.flushRedo(context);
            this.limits.remove(context);
            return;
        }
        if (flushUndo) {
            this.flushUndo(context);
        }
        if (flushRedo) {
            this.flushRedo(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus doRedo(IProgressMonitor monitor, IAdaptable info, IUndoableOperation operation) throws ExecutionException {
        IStatus status = this.getRedoApproval(operation, info);
        if (status.isOK()) {
            this.notifyAboutToRedo(operation);
            try {
                status = operation.redo(monitor, info);
            }
            catch (OperationCanceledException operationCanceledException) {
                status = Status.CANCEL_STATUS;
            }
            catch (ExecutionException e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    System.out.print("OPERATIONHISTORY >>> ExecutionException while redoing ");
                    System.out.print(operation);
                    System.out.println();
                }
                throw e;
            }
            catch (Exception e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    System.out.print("OPERATIONHISTORY >>> Exception while redoing ");
                    System.out.print(operation);
                    System.out.println();
                }
                throw new ExecutionException("While redoing the operation, an exception occurred", e);
            }
        }
        if (status.isOK()) {
            boolean addToUndoStack = operation.canUndo();
            Object object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.redoList.remove(operation);
                if (addToUndoStack && this.checkUndoLimit(operation)) {
                    this.undoList.add(operation);
                }
            }
            if (!addToUndoStack) {
                operation.dispose();
            }
            this.notifyRedone(operation);
        } else {
            this.notifyNotOK(operation);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus doUndo(IProgressMonitor monitor, IAdaptable info, IUndoableOperation operation) throws ExecutionException {
        IStatus status = this.getUndoApproval(operation, info);
        if (status.isOK()) {
            this.notifyAboutToUndo(operation);
            try {
                status = operation.undo(monitor, info);
            }
            catch (OperationCanceledException operationCanceledException) {
                status = Status.CANCEL_STATUS;
            }
            catch (ExecutionException e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    System.out.print("OPERATIONHISTORY >>> ExecutionException while undoing ");
                    System.out.print(operation);
                    System.out.println();
                }
                throw e;
            }
            catch (Exception e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    System.out.print("OPERATIONHISTORY >>> Exception while undoing ");
                    System.out.print(operation);
                    System.out.println();
                }
                throw new ExecutionException("While undoing the operation, an exception occurred", e);
            }
        }
        if (status.isOK()) {
            boolean addToRedoStack = operation.canRedo();
            Object object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.undoList.remove(operation);
                if (addToRedoStack && this.checkRedoLimit(operation)) {
                    this.redoList.add(operation);
                }
            }
            if (!addToRedoStack) {
                operation.dispose();
            }
            this.notifyUndone(operation);
        } else {
            this.notifyNotOK(operation);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        Assert.isNotNull(operation);
        if (!operation.canExecute()) {
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        boolean merging = false;
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null) {
                if (this.openComposite == operation) {
                    return IOperationHistory.OPERATION_INVALID_STATUS;
                }
                this.openComposite.add(operation);
                merging = true;
            }
        }
        if (!merging) {
            this.notifyAboutToExecute(operation);
        }
        try {
            status = operation.execute(monitor, info);
        }
        catch (OperationCanceledException operationCanceledException) {
            status = Status.CANCEL_STATUS;
        }
        catch (ExecutionException e) {
            this.notifyNotOK(operation);
            throw e;
        }
        catch (Exception e) {
            this.notifyNotOK(operation);
            throw new ExecutionException("While executing the operation, an exception occurred", e);
        }
        if (!merging) {
            if (status.isOK()) {
                this.notifyDone(operation);
                if (operation.canUndo()) {
                    this.add(operation);
                } else {
                    operation.dispose();
                }
            } else {
                this.notifyNotOK(operation);
                operation.dispose();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IUndoableOperation[] filter(List list, IUndoContext context) {
        ArrayList<IUndoableOperation> filtered = new ArrayList<IUndoableOperation>();
        Iterator iterator = list.iterator();
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            while (iterator.hasNext()) {
                IUndoableOperation operation = (IUndoableOperation)iterator.next();
                if (!operation.hasContext(context)) continue;
                filtered.add(operation);
            }
        }
        return filtered.toArray(new IUndoableOperation[filtered.size()]);
    }

    private void flushRedo(IUndoContext context) {
        if (DEBUG_OPERATION_HISTORY_DISPOSE) {
            System.out.print("OPERATIONHISTORY >>> Flushing redo history for ");
            System.out.print(context);
            System.out.println();
        }
        IUndoableOperation[] filtered = this.filter(this.redoList, context);
        int i = 0;
        while (i < filtered.length) {
            IUndoableOperation operation = filtered[i];
            if (context == GLOBAL_UNDO_CONTEXT || operation.getContexts().length == 1) {
                this.redoList.remove(operation);
                this.internalRemove(operation);
            } else {
                operation.removeContext(context);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushUndo(IUndoContext context) {
        if (DEBUG_OPERATION_HISTORY_DISPOSE) {
            System.out.print("OPERATIONHISTORY >>> Flushing undo history for ");
            System.out.print(context);
            System.out.println();
        }
        IUndoableOperation[] filtered = this.filter(this.undoList, context);
        int i = 0;
        while (i < filtered.length) {
            IUndoableOperation operation = filtered[i];
            if (context == GLOBAL_UNDO_CONTEXT || operation.getContexts().length == 1) {
                this.undoList.remove(operation);
                this.internalRemove(operation);
            } else {
                operation.removeContext(context);
            }
            ++i;
        }
        ICompositeOperation endedComposite = null;
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null && this.openComposite.hasContext(context)) {
                if (context == GLOBAL_UNDO_CONTEXT || this.openComposite.getContexts().length == 1) {
                    endedComposite = this.openComposite;
                    this.openComposite = null;
                } else {
                    this.openComposite.removeContext(context);
                }
            }
        }
        if (endedComposite != null) {
            this.notifyNotOK(endedComposite);
        }
    }

    private void forceRedoLimit(IUndoContext context, int max) {
        IUndoableOperation[] filtered = this.filter(this.redoList, context);
        int size = filtered.length;
        if (size > 0) {
            int index = 0;
            while (size > max) {
                IUndoableOperation removed = filtered[index];
                if (context == GLOBAL_UNDO_CONTEXT || removed.getContexts().length == 1) {
                    this.redoList.remove(removed);
                    this.internalRemove(removed);
                } else {
                    removed.removeContext(context);
                }
                --size;
                ++index;
            }
        }
    }

    private void forceUndoLimit(IUndoContext context, int max) {
        IUndoableOperation[] filtered = this.filter(this.undoList, context);
        int size = filtered.length;
        if (size > 0) {
            int index = 0;
            while (size > max) {
                IUndoableOperation removed = filtered[index];
                if (context == GLOBAL_UNDO_CONTEXT || removed.getContexts().length == 1) {
                    this.undoList.remove(removed);
                    this.internalRemove(removed);
                } else {
                    removed.removeContext(context);
                }
                --size;
                ++index;
            }
        }
    }

    public int getLimit(IUndoContext context) {
        if (!this.limits.containsKey(context)) {
            return 20;
        }
        return (Integer)this.limits.get(context);
    }

    private IStatus getRedoApproval(IUndoableOperation operation, IAdaptable info) {
        IOperationApprover[] approverArray = this.approvers.toArray(new IOperationApprover[this.approvers.size()]);
        int i = 0;
        while (i < approverArray.length) {
            IOperationApprover approver = approverArray[i];
            IStatus approval = approver.proceedRedoing(operation, this, info);
            if (!approval.isOK()) {
                if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                    System.out.print("OPERATIONHISTORY >>> Redo not approved by ");
                    System.out.print(approver);
                    System.out.print("for operation ");
                    System.out.print(operation);
                    System.out.print(approval);
                    System.out.println();
                }
                return approval;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public IUndoableOperation[] getRedoHistory(IUndoContext context) {
        Assert.isNotNull(context);
        return this.filter(this.redoList, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUndoableOperation getRedoOperation(IUndoContext context) {
        Assert.isNotNull(context);
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            int i = this.redoList.size() - 1;
            while (i >= 0) {
                IUndoableOperation operation = (IUndoableOperation)this.redoList.get(i);
                if (operation.hasContext(context)) {
                    return operation;
                }
                --i;
            }
        }
        return null;
    }

    private IStatus getUndoApproval(IUndoableOperation operation, IAdaptable info) {
        IOperationApprover[] approverArray = this.approvers.toArray(new IOperationApprover[this.approvers.size()]);
        int i = 0;
        while (i < approverArray.length) {
            IOperationApprover approver = approverArray[i];
            IStatus approval = approver.proceedUndoing(operation, this, info);
            if (!approval.isOK()) {
                if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                    System.out.print("OPERATIONHISTORY >>> Undo not approved by ");
                    System.out.print(approver);
                    System.out.print("for operation ");
                    System.out.print(operation);
                    System.out.print(" with status ");
                    System.out.print(approval);
                    System.out.println();
                }
                return approval;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public IUndoableOperation[] getUndoHistory(IUndoContext context) {
        Assert.isNotNull(context);
        return this.filter(this.undoList, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUndoableOperation getUndoOperation(IUndoContext context) {
        Assert.isNotNull(context);
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            int i = this.undoList.size() - 1;
            while (i >= 0) {
                IUndoableOperation operation = (IUndoableOperation)this.undoList.get(i);
                if (operation.hasContext(context)) {
                    return operation;
                }
                --i;
            }
        }
        return null;
    }

    private void internalRemove(IUndoableOperation operation) {
        operation.dispose();
        this.notifyRemoved(operation);
    }

    private void notifyListeners(OperationHistoryEvent event) {
        this.preNotifyOperation(event.getOperation(), event);
        IOperationHistoryListener[] listenerArray = this.listeners.toArray(new IOperationHistoryListener[this.listeners.size()]);
        int i = 0;
        while (i < listenerArray.length) {
            try {
                listenerArray[i].historyNotification(event);
            }
            catch (Exception e) {
                this.handleNotificationException(e);
            }
            ++i;
        }
    }

    private void notifyAboutToExecute(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> ABOUT_TO_EXECUTE ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(1, this, operation));
    }

    private void notifyAboutToRedo(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> ABOUT_TO_REDO ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(2, this, operation));
    }

    private void notifyAboutToUndo(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> ABOUT_TO_UNDO ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(3, this, operation));
    }

    private void notifyAdd(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> OPERATION_ADDED ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(5, this, operation));
    }

    private void notifyDone(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> DONE ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(4, this, operation));
    }

    private void notifyNotOK(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> OPERATION_NOT_OK ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(7, this, operation));
    }

    private void notifyRedone(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> REDONE ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(9, this, operation));
    }

    private void notifyRemoved(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> OPERATION_REMOVED ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(8, this, operation));
    }

    private void notifyUndone(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> UNDONE ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(10, this, operation));
    }

    private void notifyChanged(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            System.out.print("OPERATIONHISTORY >>> OPERATION_CHANGED ");
            System.out.print(operation);
            System.out.println();
        }
        this.notifyListeners(new OperationHistoryEvent(6, this, operation));
    }

    private void preNotifyOperation(IUndoableOperation operation, OperationHistoryEvent event) {
        if (operation instanceof IAdvancedUndoableOperation) {
            try {
                ((IAdvancedUndoableOperation)((Object)operation)).aboutToNotify(event);
            }
            catch (Exception e) {
                this.handleNotificationException(e);
            }
        }
    }

    public IStatus redo(IUndoContext context, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull(context);
        IUndoableOperation operation = this.getRedoOperation(context);
        if (operation == null) {
            return IOperationHistory.NOTHING_TO_REDO_STATUS;
        }
        if (!operation.canRedo()) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                System.out.print("OPERATIONHISTORY >>> Redo operation not valid - ");
                System.out.print(operation);
                System.out.println();
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return this.doRedo(monitor, info, operation);
    }

    public IStatus redoOperation(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        Assert.isNotNull(operation);
        if (operation.canRedo()) {
            status = this.getRedoApproval(operation, info);
            if (status.isOK()) {
                status = this.doRedo(monitor, info, operation);
            }
        } else {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                System.out.print("OPERATIONHISTORY >>> Redo operation not valid - ");
                System.out.print(operation);
                System.out.println();
            }
            status = IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return status;
    }

    public void removeOperationApprover(IOperationApprover approver) {
        this.approvers.remove(approver);
    }

    public void removeOperationHistoryListener(IOperationHistoryListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceOperation(IUndoableOperation operation, IUndoableOperation[] replacements) {
        IUndoContext context;
        int j;
        IUndoContext[] opContexts;
        int i;
        ArrayList<IUndoContext> allContexts;
        int index;
        boolean inUndo = false;
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            index = this.undoList.indexOf(operation);
            if (index > -1) {
                inUndo = true;
                this.undoList.remove(operation);
                allContexts = new ArrayList<IUndoContext>(replacements.length);
                i = 0;
                while (i < replacements.length) {
                    opContexts = replacements[i].getContexts();
                    j = 0;
                    while (j < opContexts.length) {
                        allContexts.add(opContexts[j]);
                        ++j;
                    }
                    this.undoList.add(index, replacements[i]);
                    ++i;
                }
                i = 0;
                while (i < allContexts.size()) {
                    context = (IUndoContext)allContexts.get(i);
                    this.forceUndoLimit(context, this.getLimit(context));
                    ++i;
                }
            }
        }
        if (inUndo) {
            this.internalRemove(operation);
            int i2 = 0;
            while (i2 < replacements.length) {
                this.notifyAdd(replacements[i2]);
                ++i2;
            }
            return;
        }
        Object i2 = this.undoRedoHistoryLock;
        synchronized (i2) {
            index = this.redoList.indexOf(operation);
            if (index == -1) {
                return;
            }
            allContexts = new ArrayList(replacements.length);
            this.redoList.remove(operation);
            i = 0;
            while (i < replacements.length) {
                opContexts = replacements[i].getContexts();
                j = 0;
                while (j < opContexts.length) {
                    allContexts.add(opContexts[j]);
                    ++j;
                }
                this.redoList.add(index, replacements[i]);
                ++i;
            }
            i = 0;
            while (i < allContexts.size()) {
                context = (IUndoContext)allContexts.get(i);
                this.forceRedoLimit(context, this.getLimit(context));
                ++i;
            }
        }
        this.internalRemove(operation);
        int i22 = 0;
        while (i22 < replacements.length) {
            this.notifyAdd(replacements[i22]);
            ++i22;
        }
    }

    public void setLimit(IUndoContext context, int limit) {
        Assert.isTrue(limit >= 0);
        Assert.isNotNull(context);
        this.limits.put(context, new Integer(limit));
        this.forceUndoLimit(context, limit);
        this.forceRedoLimit(context, limit);
    }

    public IStatus undo(IUndoContext context, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull(context);
        IUndoableOperation operation = this.getUndoOperation(context);
        if (operation == null) {
            return IOperationHistory.NOTHING_TO_UNDO_STATUS;
        }
        if (!operation.canUndo()) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                System.out.print("OPERATIONHISTORY >>> Undo operation not valid - ");
                System.out.print(operation);
                System.out.println();
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return this.doUndo(monitor, info, operation);
    }

    public IStatus undoOperation(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        Assert.isNotNull(operation);
        if (operation.canUndo()) {
            status = this.getUndoApproval(operation, info);
            if (status.isOK()) {
                status = this.doUndo(monitor, info, operation);
            }
        } else {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                System.out.print("OPERATIONHISTORY >>> Undo operation not valid - ");
                System.out.print(operation);
                System.out.println();
            }
            status = IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOperation(ICompositeOperation operation, int mode) {
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null && this.openComposite != operation) {
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    System.out.print("OPERATIONHISTORY >>> Open operation called while another operation is open.  old: ");
                    System.out.print(this.openComposite);
                    System.out.print("new:  ");
                    System.out.print(operation);
                    System.out.println();
                }
                throw new IllegalStateException("Cannot open an operation while one is already open");
            }
            this.openComposite = operation;
        }
        if (DEBUG_OPERATION_HISTORY_OPENOPERATION) {
            System.out.print("OPERATIONHISTORY >>> Opening operation ");
            System.out.print(this.openComposite);
            System.out.println();
        }
        if (mode == 1) {
            this.notifyAboutToExecute(this.openComposite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOperation(boolean operationOK, boolean addToHistory, int mode) {
        ICompositeOperation endedComposite = null;
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED && this.openComposite == null) {
                System.out.print("OPERATIONHISTORY >>> Attempted to close operation when none was open ");
                System.out.println();
                return;
            }
            if (this.openComposite != null) {
                if (DEBUG_OPERATION_HISTORY_OPENOPERATION) {
                    System.out.print("OPERATIONHISTORY >>> Closing operation ");
                    System.out.print(this.openComposite);
                    System.out.println();
                }
                endedComposite = this.openComposite;
                this.openComposite = null;
            }
        }
        if (endedComposite != null) {
            if (operationOK) {
                if (mode == 1) {
                    this.notifyDone(endedComposite);
                }
                if (addToHistory) {
                    this.add(endedComposite);
                }
            } else if (mode == 1) {
                this.notifyNotOK(endedComposite);
            }
        }
    }

    public void operationChanged(IUndoableOperation operation) {
        if (this.undoList.contains(operation) || this.redoList.contains(operation)) {
            this.notifyChanged(operation);
        }
    }

    private void handleNotificationException(Throwable e) {
        if (e instanceof OperationCanceledException) {
            return;
        }
        if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
            System.out.print("OPERATIONHISTORY >>> Exception during notification callback ");
            System.out.print(e);
            System.out.println();
        }
        e.printStackTrace();
    }
}

