/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDMultiPageEditorPart;
import org.eclipse.wst.xsd.ui.internal.XSDSelectionManager;
import org.eclipse.wst.xsd.ui.internal.XSDTextEditor;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphViewer;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.wst.xsd.ui.internal.util.OpenOnSelectionHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class XSDEditor
extends XSDMultiPageEditorPart
implements ITabbedPropertySheetPageContributor {
    protected XSDTextEditor textEditor;
    IFile resourceFile;
    XSDSelectionManager xsdSelectionManager;
    XSDModelAdapter schemalNodeAdapter;
    private IStructuredModel result;
    InternalPartListener partListener = new InternalPartListener(this);
    protected CommandStackListener commandStackListener;
    protected IPropertyChangeListener preferenceStoreListener = new PreferenceStoreListener();
    int currentPage = -1;
    protected OpenOnSelectionHelper openOnSelectionHelper;
    int sourcePageIndex = -1;
    int graphPageIndex = -1;
    XSDGraphViewer graphViewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XSDEditor() {
        this.xsdSelectionManager = new XSDSelectionManager();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dw.getActivePage();
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        try {
            if (page != null) {
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
        }
        catch (PartInitException partInitException) {}
    }

    protected void createPages() {
        try {
            if (!this.loadFile()) {
                return;
            }
            this.createSourcePage();
            this.addSourcePage();
            this.buildXSDModel();
            this.createAndAddGraphPage();
            int pageIndexToShow = this.getDefaultPageTypeIndex();
            this.setActivePage(pageIndexToShow);
            this.addCommandStackListener();
            XSDEditorPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(this.preferenceStoreListener);
        }
        catch (PartInitException exception) {
            throw new SourceEditingRuntimeException((Throwable)exception, XSDEditorPlugin.getXSDString("An_error_has_occurred_when1_ERROR_"));
        }
    }

    public void buildXSDModel() {
        block7: {
            try {
                boolean schemaNodeExists;
                IDOMDocument document = ((IDOMModel)this.getModel()).getDocument();
                boolean bl = schemaNodeExists = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema").getLength() == 1;
                if (document.getChildNodes().getLength() == 0 || !schemaNodeExists) {
                    this.createDefaultSchemaNode((Document)document);
                }
                if (!(document instanceof INodeNotifier)) break block7;
                INodeNotifier notifier = (INodeNotifier)document;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.schemalNodeAdapter = (XSDModelAdapter)notifier.getAdapterFor((Object)clazz);
                if (this.schemalNodeAdapter == null) {
                    this.schemalNodeAdapter = new XSDModelAdapter();
                    notifier.addAdapter((INodeAdapter)this.schemalNodeAdapter);
                    this.schemalNodeAdapter.createSchema(document.getDocumentElement());
                }
            }
            catch (Exception exception) {}
        }
    }

    public String[] getPropertyCategories() {
        return new String[]{"general", "namespace", "other", "attributes", "documentation", "facets"};
    }

    public String getContributorId() {
        return "org.eclipse.wst.xsd.ui.internal.XSDEditor";
    }

    protected void addCommandStackListener() {
        if (this.commandStackListener == null) {
            this.getModel().getUndoManager();
            this.commandStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject event) {
                    Object obj = event.getSource();
                    if (obj instanceof BasicCommandStack) {
                        BasicCommandStack stack = (BasicCommandStack)obj;
                        Command recentCommand = stack.getMostRecentCommand();
                        Command redoCommand = stack.getRedoCommand();
                        stack.getUndoCommand();
                        if (recentCommand == redoCommand) {
                            XSDEditor.this.resetInformationTasks();
                        }
                    }
                }
            };
        }
    }

    protected void pageChange(int arg) {
        super.pageChange(arg);
    }

    protected void removeCommandStackListener() {
        if (this.commandStackListener != null) {
            this.getModel().getUndoManager();
        }
    }

    protected int getDefaultPageTypeIndex() {
        int pageIndex = this.sourcePageIndex;
        if (XSDEditorPlugin.getPlugin().getDefaultPage().equals(XSDEditorPlugin.GRAPH_PAGE) && this.graphPageIndex != -1) {
            pageIndex = this.graphPageIndex;
        }
        return pageIndex;
    }

    public String getCurrentPageType() {
        if (this.getActivePage() != -1) {
            this.currentPage = this.getActivePage();
        }
        if (this.currentPage == this.graphPageIndex) {
            return XSDEditorPlugin.GRAPH_PAGE;
        }
        return XSDEditorPlugin.SOURCE_PAGE;
    }

    public Object getActivePart() {
        return this.getSite().getWorkbenchWindow().getActivePage().getActivePart();
    }

    public void dispose() {
        this.removeCommandStackListener();
        XSDEditorPlugin.getPlugin().setDefaultPage(this.getCurrentPageType());
        XSDEditorPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(this.preferenceStoreListener);
        this.getSite().getPage().removePartListener((IPartListener)this.partListener);
        this.textEditor = null;
        this.resourceFile = null;
        this.xsdSelectionManager = null;
        this.schemalNodeAdapter = null;
        this.result = null;
        this.partListener = null;
        this.commandStackListener = null;
        this.preferenceStoreListener = null;
        this.openOnSelectionHelper = null;
        this.graphViewer = null;
        super.dispose();
    }

    protected boolean loadFile() {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            if (input instanceof ILocationProvider) {
                IPath path = ((ILocationProvider)input).getPath((Object)input);
                String ext = path.getFileExtension();
                return ext != null && ext.equals("xsd");
            }
            return false;
        }
        this.resourceFile = ((IFileEditorInput)input).getFile();
        return true;
    }

    public void openOnGlobalReference(XSDConcreteComponent comp) {
        this.openOnSelectionHelper.openOnGlobalReference(comp);
    }

    public OpenOnSelectionHelper getOpenOnSelectionHelper() {
        return this.openOnSelectionHelper;
    }

    protected StructuredTextEditor createTextEditor() {
        return new XSDTextEditor(this);
    }

    protected void createSourcePage() throws PartInitException {
        super.createSourcePage();
        this.textEditor = (XSDTextEditor)this.getTextEditor();
        this.openOnSelectionHelper = new OpenOnSelectionHelper(this.textEditor);
    }

    protected void addSourcePage() throws PartInitException {
        this.sourcePageIndex = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
        this.setPageText(this.sourcePageIndex, XSDEditorPlugin.getXSDString("_UI_TAB_SOURCE"));
        this.textEditor.update();
        this.firePropertyChange(1);
    }

    protected void createAndAddGraphPage() throws PartInitException {
        this.graphViewer = new XSDGraphViewer(this);
        this.graphViewer.setSchema(this.getXSDSchema());
        Control graphControl = this.graphViewer.createControl(this.getContainer());
        this.graphPageIndex = this.addPage(graphControl);
        this.setPageText(this.graphPageIndex, XSDEditorPlugin.getXSDString("_UI_TAB_GRAPH"));
        this.graphViewer.setSelectionManager(this.getSelectionManager());
        if (this.textEditor.getXSDSchema() != null) {
            this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.textEditor.getXSDSchema()));
        }
    }

    public Object getAdapter(Class key) {
        Object result = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result = key == clazz ? this.xsdSelectionManager : this.textEditor.getAdapter(key);
        return result;
    }

    public XSDSelectionManager getSelectionManager() {
        return this.xsdSelectionManager;
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    public void reparseSchema() {
        IDOMDocument document = ((IDOMModel)this.getModel()).getDocument();
        if (this.schemalNodeAdapter != null) {
            this.schemalNodeAdapter.createSchema(document.getDocumentElement());
        }
    }

    public XSDSchema getXSDSchema() {
        return this.schemalNodeAdapter != null ? this.schemalNodeAdapter.getSchema() : null;
    }

    public IFile getFileResource() {
        return this.resourceFile;
    }

    public IDocument getEditorIDocument() {
        IDocument document = this.textEditor.getTextViewer().getDocument();
        return document;
    }

    public void createTasksInTaskList(ArrayList messages) {
    }

    public void resetInformationTasks() {
    }

    public XSDGraphViewer getGraphViewer() {
        return this.graphViewer;
    }

    public IEditorPart getActiveEditorPage() {
        return this.getActiveEditor();
    }

    public XSDTextEditor getXSDTextEditor() {
        return this.textEditor;
    }

    public void createDefaultSchemaNode(Document document) {
        if (document.getChildNodes().getLength() == 0) {
            String encoding = "UTF-8";
            ProcessingInstruction instr = document.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"" + encoding + "\"");
            document.appendChild(instr);
        }
        String defaultPrefixForTargetNamespace = "tns";
        String prefixForSchemaNamespace = "";
        String schemaNamespaceAttribute = "xmlns";
        if (XSDEditorPlugin.getPlugin().isQualifyXMLSchemaLanguage() && XSDEditorPlugin.getPlugin().getXMLSchemaPrefix().trim().length() > 0) {
            prefixForSchemaNamespace = String.valueOf(XSDEditorPlugin.getPlugin().getXMLSchemaPrefix()) + ":";
            schemaNamespaceAttribute = String.valueOf(schemaNamespaceAttribute) + ":" + XSDEditorPlugin.getPlugin().getXMLSchemaPrefix();
        }
        document.appendChild(document.createTextNode("\n"));
        Element element = document.createElement(String.valueOf(prefixForSchemaNamespace) + "schema");
        element.setAttribute(schemaNamespaceAttribute, "http://www.w3.org/2001/XMLSchema");
        String defaultTargetURI = XSDEditorPlugin.getPlugin().getXMLSchemaTargetNamespace();
        element.setAttribute("targetNamespace", defaultTargetURI);
        element.setAttribute("xmlns:" + defaultPrefixForTargetNamespace, defaultTargetURI);
        document.appendChild(element);
    }

    private class PreferenceStoreListener
    implements IPropertyChangeListener {
        PreferenceStoreListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    class InternalPartListener
    implements IPartListener {
        XSDEditor editor;

        public InternalPartListener(XSDEditor editor) {
            this.editor = editor;
        }

        public void partActivated(IWorkbenchPart part) {
            ISelection selection;
            if (part == this.editor && (selection = XSDEditor.this.getSelectionManager().getSelection()) != null) {
                if (XSDEditor.this.getCurrentPageType().equals(XSDEditorPlugin.GRAPH_PAGE)) {
                    XSDEditor.this.getSelectionManager().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.editor.getGraphViewer().getComponentViewer(), selection));
                } else if (XSDEditor.this.getCurrentPageType().equals(XSDEditorPlugin.SOURCE_PAGE)) {
                    XSDEditor.this.getSelectionManager().setSelection(selection);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

