/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.widgets.EnumerationsDialog;
import org.w3c.dom.Element;

public class AddEnumsAction
extends CreateElementAction {
    public AddEnumsAction(String label) {
        super(label);
    }

    public Element createAndAddNewChildElement(String token) {
        String prefix = this.parentNode.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element childNode = this.getDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + this.elementTag);
        if (this.getAttributes() != null) {
            List attributes = this.getAttributes();
            int i = 0;
            while (i < attributes.size()) {
                DOMAttribute attr = (DOMAttribute)attributes.get(i);
                childNode.setAttribute(attr.getName(), attr.getValue());
                ++i;
            }
        }
        if (this.getRelativeNode() == null) {
            this.parentNode.appendChild(childNode);
        } else {
            this.parentNode.insertBefore(childNode, this.getRelativeNode());
        }
        childNode.setAttribute("value", token);
        return childNode;
    }

    public void run() {
        Display display = Display.getCurrent();
        display = display == null ? Display.getDefault() : display;
        Shell parentShell = display.getActiveShell();
        EnumerationsDialog dialog = new EnumerationsDialog(parentShell);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            this.beginRecording(this.getDescription());
            String text = dialog.getText();
            String delimiter = dialog.getDelimiter();
            StringTokenizer tokenizer = new StringTokenizer(text, delimiter);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!dialog.isPreserveWhitespace()) {
                    token = token.trim();
                }
                Element child = this.createAndAddNewChildElement(token);
                this.formatChild(child);
            }
            this.endRecording();
        }
    }
}

