/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.GraphicsConstants;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.TopLevelComponentEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SelectionHandlesEditPolicyImpl;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerLayout;
import org.eclipse.wst.xsd.ui.internal.graph.figures.FillLayout;
import org.eclipse.wst.xsd.ui.internal.graph.figures.RoundedLineBorder;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;

public class CategoryEditPart
extends BaseEditPart {
    protected ScrollPane scrollpane;
    protected Label label;
    protected ContainerFigure outerPane;
    protected ContainerFigure r;
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy;

    public int getType() {
        return ((Category)this.getModel()).getGroupType();
    }

    protected IFigure createFigure() {
        this.outerPane = new ContainerFigure();
        this.outerPane.setBorder((Border)new RoundedLineBorder(1, 6));
        this.outerPane.setForegroundColor(categoryBorderColor);
        this.r = new ContainerFigure();
        this.r.setOutline(false);
        this.r.setMinimumSize(new Dimension(0, 0));
        this.r.setFill(true);
        this.r.setBackgroundColor(GraphicsConstants.elementBackgroundColor);
        this.outerPane.add((IFigure)this.r);
        int minHeight = 250;
        switch (this.getType()) {
            case 6: 
            case 7: {
                minHeight = 50;
                break;
            }
            case 1: 
            case 5: {
                minHeight = 100;
            }
        }
        final int theMinHeight = minHeight;
        FillLayout outerLayout = new FillLayout(){

            protected Dimension calculatePreferredSize(IFigure parent, int width, int height) {
                Dimension d = super.calculatePreferredSize(parent, width, height);
                d.union(new Dimension(100, theMinHeight));
                return d;
            }
        };
        this.outerPane.setLayoutManager((LayoutManager)outerLayout);
        this.label = new Label();
        this.label.setForegroundColor(ColorConstants.black);
        this.label.setBorder((Border)new MarginBorder(2, 4, 2, 4));
        this.r.add((IFigure)this.label);
        RectangleFigure line = new RectangleFigure();
        line.setPreferredSize(20, 1);
        this.outerPane.add((IFigure)line);
        this.scrollpane = new ScrollPane();
        this.scrollpane.setForegroundColor(ColorConstants.black);
        this.scrollpane.setVerticalScrollBarVisibility(1);
        this.outerPane.add((IFigure)this.scrollpane);
        ContainerFigure pane = new ContainerFigure();
        pane.setBorder((Border)new MarginBorder(5, 8, 5, 8));
        ContainerLayout layout = new ContainerLayout();
        layout.setHorizontal(false);
        layout.setSpacing(0);
        pane.setLayoutManager((LayoutManager)layout);
        Viewport viewport = new Viewport();
        viewport.setContentsTracksHeight(true);
        ViewportLayout viewportLayout = new ViewportLayout(){

            protected Dimension calculatePreferredSize(IFigure parent, int width, int height) {
                Dimension d = super.calculatePreferredSize(parent, width, height);
                d.height = Math.min(d.height, theMinHeight - 25);
                return d;
            }
        };
        viewport.setLayoutManager((LayoutManager)viewportLayout);
        this.scrollpane.setViewport(viewport);
        this.scrollpane.setContents((IFigure)pane);
        return this.outerPane;
    }

    protected List getModelChildren() {
        return ((Category)this.getModel()).getChildren();
    }

    public void refreshVisuals() {
        this.outerPane.setBorder((Border)new RoundedLineBorder(this.isSelected ? ColorConstants.black : categoryBorderColor, this.isSelected ? 1 : 1, 6));
        this.outerPane.repaint();
        Category category = (Category)this.getModel();
        this.label.setText("  " + category.getName() + "                                                    ");
    }

    public ScrollPane getScrollPane() {
        return this.scrollpane;
    }

    public IFigure getContentPane() {
        return this.scrollpane.getContents();
    }

    public void scrollTo(AbstractGraphicalEditPart topLevel) {
        Rectangle topLevelBounds = topLevel.getFigure().getBounds();
        Rectangle categoryBounds = this.getFigure().getBounds();
        int scrollValue = this.scrollpane.getVerticalScrollBar().getValue();
        int location = topLevelBounds.y + scrollValue - categoryBounds.y;
        this.scrollpane.scrollVerticalTo(location - categoryBounds.height / 2);
    }

    protected EditPart createChild(Object model) {
        TopLevelComponentEditPart editPart = new TopLevelComponentEditPart();
        editPart.setModel(model);
        editPart.setParent((EditPart)this);
        return editPart;
    }

    protected void createEditPolicies() {
        this.selectionHandlesEditPolicy = new SelectionHandlesEditPolicyImpl();
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
    }
}

