/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelGroupPropertySource
extends BasePropertySource
implements IPropertySource {
    private String[] modelGroupComboValues = new String[]{"sequence", "choice", "all"};

    public ModelGroupPropertySource() {
    }

    public ModelGroupPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public ModelGroupPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<XSDComboBoxPropertyDescriptor> list = new ArrayList<XSDComboBoxPropertyDescriptor>();
        XSDComboBoxPropertyDescriptor modelGroupDescriptor = new XSDComboBoxPropertyDescriptor("model group", "model group", this.modelGroupComboValues);
        list.add(modelGroupDescriptor);
        TextPropertyDescriptor minOccursDescriptor = new TextPropertyDescriptor((Object)"minOccurs", "minOccurs");
        list.add((XSDComboBoxPropertyDescriptor)minOccursDescriptor);
        TextPropertyDescriptor maxOccursDescriptor = new TextPropertyDescriptor((Object)"maxOccurs", "maxOccurs");
        list.add((XSDComboBoxPropertyDescriptor)maxOccursDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            String attributeName = (String)id;
            if (result == null) {
                result = "";
            }
            if (attributeName.equals("model group")) {
                result = this.element.getLocalName();
                return result;
            }
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        String property = (String)id;
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            if (property.equals("model group")) {
                this.element.getOwnerDocument();
                Element parent = (Element)this.element.getParentNode();
                String prefix = this.element.getPrefix();
                prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_GROUP_SCOPE_CHANGE"), parent);
                this.changeContentModel(parent, newValue);
                this.endRecording(parent);
                XSDDOMHelper domHelper = new XSDDOMHelper();
                this.setInput(domHelper.getContentModelFromParent(parent));
            } else if (property.equals("maxOccurs")) {
                String max = (String)value;
                this.element.getAttribute("minOccurs");
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MAXOCCURS_CHANGE"), this.element);
                if (max.length() > 0) {
                    this.element.setAttribute("maxOccurs", max);
                } else {
                    this.element.removeAttribute("maxOccurs");
                }
                this.endRecording(this.element);
            } else if (((String)id).equals("minOccurs")) {
                String min = (String)value;
                this.element.getAttribute("maxOccurs");
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MINOCCURS_CHANGE"), this.element);
                if (min.length() > 0) {
                    this.element.setAttribute("minOccurs", min);
                } else {
                    this.element.removeAttribute("minOccurs");
                }
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (ModelGroupPropertySource.this.viewer != null) {
                    ModelGroupPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    public void setInput(Element element) {
        super.setInput(element);
        if (element != null) {
            boolean parentIsSequence = false;
            boolean parentIsChoice = false;
            Node parent = element.getParentNode();
            if (XSDDOMHelper.inputEquals(parent, "sequence", false)) {
                parentIsSequence = true;
            } else if (XSDDOMHelper.inputEquals(parent, "choice", false)) {
                parentIsChoice = true;
            }
            if (parentIsChoice || parentIsSequence) {
                this.modelGroupComboValues = new String[2];
                this.modelGroupComboValues[0] = "sequence";
                this.modelGroupComboValues[1] = "choice";
            } else {
                this.modelGroupComboValues = new String[3];
                this.modelGroupComboValues[0] = "sequence";
                this.modelGroupComboValues[1] = "choice";
                this.modelGroupComboValues[2] = "all";
            }
        }
    }

    private void changeContentModel(Element parent, String contentModel) {
        Document doc = parent.getOwnerDocument();
        XSDDOMHelper domHelper = new XSDDOMHelper();
        String prefix = parent.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element contentModelElement = domHelper.getContentModelFromParent(parent);
        if (contentModelElement.getLocalName().equals(contentModel)) {
            return;
        }
        Element newNode = doc.createElementNS(XSDDOMHelper.XMLSchemaURI, String.valueOf(prefix) + contentModel);
        if (contentModelElement.hasChildNodes()) {
            NodeList nodes = contentModelElement.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                newNode.appendChild(node.cloneNode(true));
                ++i;
            }
        }
        parent.replaceChild(newNode, contentModelElement);
    }
}

