/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.MakeAnonymousTypeGlobalAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.MakeLocalElementGlobalAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RenameAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.xsd.XSDSchema;

public class RefactorActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.wst.xsd.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String RENAME_ELEMENT = "org.eclipse.wst.xsd.ui.refactor.rename.element";
    public static final String MAKE_ELEMENT_GLOBAL = "org.eclipse.wst.xsd.ui.refactor.makeElementGlobal";
    public static final String MAKE_TYPE_GLOBAL = "org.eclipse.wst.xsd.ui.refactor.makeTypeGlobal";
    public static final String RENAME = "org.eclipse.wst.xsd.ui.refactoring.actions.Rename";
    public static final String GROUP_REORGANIZE = "group.reorganize";
    private IWorkbenchSite fSite;
    private ISelectionProvider fSelectionProvider;
    private XSDSchema fSchema;
    private String fGroupName = "group.reorganize";
    private SelectionDispatchAction fRenameAction;
    private SelectionDispatchAction fMakeLocalElementGlobal;
    private SelectionDispatchAction fMakeLocalTypeGlobal;
    private List fEditorActions;
    private IMenuManager fRefactorSubmenu;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactorActionGroup(ISelectionProvider selectionProvider, XSDSchema schema, String groupName) {
        this(selectionProvider, schema);
        this.fGroupName = groupName;
    }

    public RefactorActionGroup(ISelectionProvider selectionProvider, XSDSchema schema) {
        this.fSelectionProvider = selectionProvider;
        this.fSchema = schema;
        this.fEditorActions = new ArrayList();
        this.fRenameAction = new RenameAction(selectionProvider, schema);
        this.fRenameAction.setActionDefinitionId(RENAME_ELEMENT);
        this.fEditorActions.add(this.fRenameAction);
        this.fMakeLocalElementGlobal = new MakeLocalElementGlobalAction(selectionProvider, schema);
        this.fMakeLocalElementGlobal.setActionDefinitionId(MAKE_ELEMENT_GLOBAL);
        this.fEditorActions.add(this.fMakeLocalElementGlobal);
        this.fMakeLocalTypeGlobal = new MakeAnonymousTypeGlobalAction(selectionProvider, schema);
        this.fMakeLocalTypeGlobal.setActionDefinitionId(MAKE_TYPE_GLOBAL);
        this.fEditorActions.add(this.fMakeLocalTypeGlobal);
        RefactorActionGroup.initAction(this.fRenameAction, this.fSelectionProvider);
        RefactorActionGroup.initAction(this.fMakeLocalElementGlobal, this.fSelectionProvider);
        RefactorActionGroup.initAction(this.fMakeLocalTypeGlobal, this.fSelectionProvider);
    }

    private static void initAction(SelectionDispatchAction action, ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        Assert.isNotNull((Object)((Object)action));
        action.update(provider.getSelection());
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(RENAME, (IAction)this.fRenameAction);
        this.retargetFileMenuActions(actionBars);
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        this.disposeAction(this.fRenameAction, this.fSelectionProvider);
        this.disposeAction(this.fMakeLocalElementGlobal, this.fSelectionProvider);
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String menuText = RefactoringMessages.getString("RefactorMenu.label");
        this.fRefactorSubmenu = new MenuManager(menuText, MENU_ID);
        this.fRefactorSubmenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RefactorActionGroup.this.refactorMenuShown(manager);
            }
        });
        this.fRefactorSubmenu.add((IAction)this.fNoActionAvailable);
        if (menu.find(this.fRefactorSubmenu.getId()) == null) {
            if (menu.find(this.fGroupName) == null) {
                menu.add((IContributionItem)this.fRefactorSubmenu);
            } else {
                menu.appendToGroup(this.fGroupName, (IContributionItem)this.fRefactorSubmenu);
            }
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            added += this.addAction(refactorSubmenu, (IAction)action);
        }
        return added;
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    public int addAction(IAction action) {
        if (action != null && action.isEnabled()) {
            this.fEditorActions.add(action);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ISelection selection = this.fSelectionProvider.getSelection();
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (!(action instanceof SelectionDispatchAction)) continue;
            SelectionDispatchAction selectionAction = (SelectionDispatchAction)action;
            selectionAction.update(selection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ISelection selection = this.fSelectionProvider.getSelection();
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (!(action instanceof SelectionDispatchAction)) continue;
            SelectionDispatchAction selectionAction = (SelectionDispatchAction)action;
            selectionAction.update(selection);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(RefactoringMessages.getString("RefactorActionGroup.no_refactoring_available"));
        }
    }
}

