/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class OVMessageAreaMenu
implements MenuListener,
SelectionListener {
    protected StyledText myTextArea;
    protected Menu myMenu;
    protected MenuItem copyItem;
    protected MenuItem selectAllItem;
    protected MenuItem saveItem;
    protected MenuItem printItem;
    protected MenuItem menuSeparator1;
    protected MenuItem menuSeparator2;
    protected MenuItem menuSeparator3;

    public OVMessageAreaMenu(StyledText aMessageArea) {
        this.myTextArea = aMessageArea;
        this.myMenu = new Menu((Control)this.myTextArea);
        this.copyItem = new MenuItem(this.myMenu, 0);
        this.copyItem.setText(OutputViewPlugin.getString("OV_MESSAGE_COPY"));
        this.menuSeparator1 = new MenuItem(this.myMenu, 2);
        this.selectAllItem = new MenuItem(this.myMenu, 0);
        this.selectAllItem.setText(OutputViewPlugin.getString("OV_MESSAGE_SELECTALL"));
        this.menuSeparator2 = new MenuItem(this.myMenu, 2);
        this.saveItem = new MenuItem(this.myMenu, 0);
        this.saveItem.setText(OutputViewPlugin.getString("OV_MESSAGE_SAVE_AS"));
        this.menuSeparator3 = new MenuItem(this.myMenu, 2);
        this.printItem = new MenuItem(this.myMenu, 0);
        this.printItem.setText(OutputViewPlugin.getString("OV_MESSAGE_PRINT"));
        this.listenAll();
    }

    private void listenAll() {
        this.myMenu.addMenuListener((MenuListener)this);
        this.copyItem.addSelectionListener((SelectionListener)this);
        this.selectAllItem.addSelectionListener((SelectionListener)this);
        this.saveItem.addSelectionListener((SelectionListener)this);
        this.printItem.addSelectionListener((SelectionListener)this);
    }

    public Menu getMenu() {
        return this.myMenu;
    }

    private void saveOutput() {
        FileDialog fileDialog = new FileDialog(this.myTextArea.getShell(), 8192);
        String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.isDirectory()) {
                    this.displayDirectoryError(this.myTextArea.getShell(), fileName);
                    return;
                }
                if (file.exists()) {
                    Object[] obj = new Object[]{fileName};
                    String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_DESC", obj);
                    MessageBox box = new MessageBox(this.myTextArea.getShell(), 192);
                    box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_TITLE"));
                    box.setMessage(message);
                    if (box.open() != 64) {
                        return;
                    }
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write(this.myTextArea.getText());
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                MessageBox box = new MessageBox(this.myTextArea.getShell(), 1);
                box.setText(OutputViewPlugin.getString("OV_STATUS_ERROR"));
                box.setMessage(ex.getMessage());
                box.open();
            }
        }
    }

    private void displayDirectoryError(Shell aShell, String aFile) {
        Object[] obj = new Object[]{aFile};
        String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_DESC", obj);
        MessageBox box = new MessageBox(aShell, 33);
        box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_TITLE"));
        box.setMessage(message);
        box.open();
        this.saveOutput();
    }

    private void printOutput() {
        PrinterData printerData;
        PrintDialog dialog = new PrintDialog(this.myTextArea.getShell(), 0);
        if (this.myTextArea.getSelectionCount() > 0) {
            dialog.setScope(2);
        }
        if ((printerData = dialog.open()) != null) {
            Printer printer = new Printer(printerData);
            this.myTextArea.print(printer).run();
            printer.dispose();
        }
    }

    public void menuHidden(MenuEvent anEvent) {
    }

    public void menuShown(MenuEvent anEvent) {
        if (this.myTextArea.getSelectionCount() > 0) {
            this.copyItem.setEnabled(true);
        } else {
            this.copyItem.setEnabled(false);
        }
        this.selectAllItem.setEnabled(this.myTextArea.getSelectionCount() != this.myTextArea.getCharCount());
        this.saveItem.setEnabled(this.myTextArea.getCharCount() > 0);
        this.printItem.setEnabled(this.myTextArea.getCharCount() > 0);
    }

    public void widgetDefaultSelected(SelectionEvent anEvent) {
    }

    public void widgetSelected(SelectionEvent anEvent) {
        Object source = anEvent.getSource();
        if (source == this.copyItem) {
            this.myTextArea.copy();
        } else if (source == this.selectAllItem) {
            this.myTextArea.selectAll();
        } else if (source == this.saveItem) {
            this.saveOutput();
        } else if (source == this.printItem) {
            this.printOutput();
        }
    }
}

