/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.AmountOfWorkCalculator;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchVisitor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;

public class TextSearchEngine {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus search(SearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MatchLocator matchLocator) {
        Assert.isNotNull((Object)scope);
        Assert.isNotNull((Object)collector);
        Assert.isNotNull((Object)matchLocator);
        IProgressMonitor monitor = collector.getProgressMonitor();
        String message = SearchMessages.TextSearchEngine_statusMessage;
        MultiStatus status = new MultiStatus("org.eclipse.search", 0, message, null);
        int amountOfWork = new AmountOfWorkCalculator(scope, status, visitDerived).process();
        try {
            try {
                monitor.beginTask("", amountOfWork);
                if (amountOfWork > 0) {
                    Object[] args = new Integer[]{new Integer(1), new Integer(amountOfWork)};
                    monitor.setTaskName(Messages.format(SearchMessages.TextSearchEngine_scanning, args));
                }
                collector.aboutToStart();
                TextSearchVisitor visitor = new TextSearchVisitor(matchLocator, scope, visitDerived, collector, status, amountOfWork);
                visitor.process();
            }
            catch (CoreException ex) {
                status.add(ex.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            try {
                collector.done();
                throw throwable;
            }
            catch (CoreException ex) {
                status.add(ex.getStatus());
            }
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        monitor.done();
        try {}
        catch (CoreException ex) {
            status.add(ex.getStatus());
            return status;
        }
        collector.done();
        return status;
    }
}

