/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileSearchQuery
implements ISearchQuery {
    private String fSearchString;
    private String fSearchOptions;
    private SearchScope fScope;
    private FileSearchResult fResult;
    private boolean fVisitDerived;

    public FileSearchQuery(SearchScope scope, String options, String searchString, boolean visitDerived) {
        this.fVisitDerived = visitDerived;
        this.fScope = scope;
        this.fSearchOptions = options;
        this.fSearchString = searchString;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public IStatus run(IProgressMonitor pm) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, pm);
        String searchString = this.fSearchString;
        if (searchString.trim().equals(String.valueOf('*'))) {
            searchString = new String();
        }
        return new TextSearchEngine().search(this.fScope, this.fVisitDerived, collector, new MatchLocator(searchString, this.isCaseSensitive(), this.isRegexSearch()));
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_label;
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    private String getSearchOptions() {
        return this.fSearchOptions;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            if (this.fSearchString.length() > 0) {
                Object[] args = new Object[]{this.fSearchString, this.fScope.getDescription()};
                return Messages.format(SearchMessages.FileSearchQuery_singularLabel, args);
            }
            Object[] args = new Object[]{this.fScope.getFileNamePatternDescription(), this.fScope.getDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_singularLabel_fileNameSearch, args);
        }
        if (this.fSearchString.length() > 0) {
            Object[] args = new Object[]{this.fSearchString, new Integer(nMatches), this.fScope.getDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_pluralPattern, args);
        }
        Object[] args = new Object[]{this.fScope.getFileNamePatternDescription(), new Integer(nMatches), this.fScope.getDescription()};
        return Messages.format(SearchMessages.FileSearchQuery_pluralPattern_fileNameSearch, args);
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        TextSearchResultCollector collector = new TextSearchResultCollector(result, monitor);
        SearchScope scope = SearchScope.newSearchScope("", new IResource[]{file});
        return new TextSearchEngine().search(scope, this.fVisitDerived, collector, new MatchLocator(this.fSearchString, this.isCaseSensitive(), this.isRegexSearch()));
    }

    public boolean isRegexSearch() {
        return FileSearchQuery.isRegexSearch(this.getSearchOptions());
    }

    public static boolean isRegexSearch(String options) {
        return options.indexOf(114) != -1;
    }

    public boolean isCaseSensitive() {
        return FileSearchQuery.isCaseSensitive(this.getSearchOptions());
    }

    public static boolean isCaseSensitive(String options) {
        return options.indexOf(105) == -1;
    }

    public boolean canRerun() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    implements ITextSearchResultCollector {
        private final AbstractTextSearchResult fResult;
        private final IProgressMonitor fProgressMonitor;

        TextSearchResultCollector(AbstractTextSearchResult result, IProgressMonitor monitor) {
            this.fResult = result;
            this.fProgressMonitor = monitor;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public void aboutToStart() {
        }

        public void accept(IResourceProxy proxy, int start, int length) {
            IFile file = (IFile)proxy.requestResource();
            if (start < 0) {
                start = 0;
            }
            if (length < 0) {
                length = 0;
            }
            this.fResult.addMatch(new FileMatch(file, start, length));
        }

        public void done() {
        }
    }
}

