/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.autoedit;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.Logger;

public class AutoEditStrategyForTabs
implements IAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null && command.text.length() > 0 && command.text.charAt(0) == '\t') {
            this.smartInsertForTab(command, document);
        }
    }

    private void smartInsertForTab(DocumentCommand command, IDocument document) {
        Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        if ("space".equals(preferences.getString("indentationChar"))) {
            int indentationWidth = preferences.getInt("indentationSize");
            StringBuffer indent = new StringBuffer();
            if (indentationWidth != 0) {
                int indentSize = indentationWidth;
                try {
                    IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                    int offsetInLine = command.offset - firstLine.getOffset();
                    int remainder = offsetInLine % indentationWidth;
                    indentSize = indentationWidth - remainder;
                }
                catch (BadLocationException e) {
                    Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                }
                int i = 0;
                while (i < indentSize) {
                    indent.append(' ');
                    ++i;
                }
            }
            command.text = indent.toString();
        }
    }
}

