/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.Assert;
import org.eclipse.ltk.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.FinishResult;
import org.eclipse.ltk.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class RefactoringWizard
extends Wizard {
    public static final int NONE = 0;
    public static final int CHECK_INITIAL_CONDITIONS_ON_OPEN = 1;
    public static final int WIZARD_BASED_USER_INTERFACE = 2;
    public static final int DIALOG_BASED_USER_INTERFACE = 4;
    public static final int DIALOG_BASED_UESR_INTERFACE = 4;
    public static final int YES_NO_BUTTON_STYLE = 8;
    public static final int NO_PREVIEW_PAGE = 16;
    public static final int PREVIEW_EXPAND_FIRST_NODE = 32;
    public static final int NO_BACK_BUTTON_ON_STATUS_DIALOG = 64;
    private static final int LAST = 128;
    private int fFlags;
    private Refactoring fRefactoring;
    private String fDefaultPageTitle;
    private Change fChange;
    private RefactoringStatus fInitialConditionCheckingStatus = new RefactoringStatus();
    private RefactoringStatus fConditionCheckingStatus;
    private int fUserInputPages;
    private boolean fInAddPages;
    private boolean fIsChangeCreationCancelable;
    private boolean fForcePreviewReview;
    private boolean fPreviewShown;

    public RefactoringWizard(Refactoring refactoring, int flags) {
        Assert.isNotNull(refactoring);
        Assert.isTrue(flags < 128);
        if ((flags & 4) == 0) {
            flags |= 2;
        }
        Assert.isTrue((flags & 4) != 0 || (flags & 2) != 0);
        this.fRefactoring = refactoring;
        this.fFlags = flags;
        this.setNeedsProgressMonitor(true);
        this.setChangeCreationCancelable(true);
        this.setWindowTitle(RefactoringUIMessages.RefactoringWizard_title);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_REFACTOR);
    }

    public final Refactoring getRefactoring() {
        return this.fRefactoring;
    }

    public final void setDefaultPageTitle(String defaultPageTitle) {
        Assert.isNotNull(defaultPageTitle);
        this.fDefaultPageTitle = defaultPageTitle;
    }

    public final String getDefaultPageTitle() {
        return this.fDefaultPageTitle;
    }

    public final void setForcePreviewReview(boolean forcePreviewReview) {
        this.fForcePreviewReview = forcePreviewReview;
        this.getContainer().updateButtons();
    }

    public int getMessageLineWidthInChars() {
        return 80;
    }

    public final void setChangeCreationCancelable(boolean isChangeCreationCancelable) {
        this.fIsChangeCreationCancelable = isChangeCreationCancelable;
    }

    public final void setInitialConditionCheckingStatus(RefactoringStatus status) {
        Assert.isNotNull(status);
        this.fInitialConditionCheckingStatus = status;
        this.setConditionCheckingStatus(status);
    }

    public final Change getChange() {
        return this.fChange;
    }

    final RefactoringStatus getInitialConditionCheckingStatus() {
        return this.fInitialConditionCheckingStatus;
    }

    boolean needsWizardBasedUserInterface() {
        return (this.fFlags & 2) != 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addPages() {
        Assert.isNotNull(this.fRefactoring);
        try {
            this.fInAddPages = true;
            if (this.checkActivationOnOpen()) {
                this.internalCheckCondition(2);
            }
            if (this.fInitialConditionCheckingStatus.hasFatalError()) {
                this.addErrorPage();
                this.setConditionCheckingStatus(this.getConditionCheckingStatus());
            } else {
                Assert.isTrue(this.getPageCount() == 0);
                this.addUserInputPages();
                this.fUserInputPages = this.getPageCount();
                if (this.fUserInputPages > 0) {
                    IWizardPage[] pages = this.getPages();
                    ((UserInputWizardPage)pages[this.fUserInputPages - 1]).markAsLastUserInputPage();
                }
                if (this.fUserInputPages > 1) {
                    Assert.isTrue((this.fFlags & 2) != 0);
                }
                this.addErrorPage();
                this.addPreviewPage();
            }
            this.initializeDefaultPageTitles();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fInAddPages = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fInAddPages = false;
            return;
        }
    }

    public final void addPage(IWizardPage page) {
        Assert.isTrue(page instanceof RefactoringWizardPage && this.fInAddPages);
        super.addPage(page);
    }

    protected abstract void addUserInputPages();

    private void addErrorPage() {
        this.addPage((IWizardPage)new ErrorWizardPage());
    }

    private void addPreviewPage() {
        this.addPage(new PreviewWizardPage());
    }

    private boolean hasUserInput() {
        return this.fUserInputPages > 0;
    }

    private void initializeDefaultPageTitles() {
        if (this.fDefaultPageTitle == null) {
            return;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page.getTitle() == null) {
                page.setTitle(this.fDefaultPageTitle);
            }
            ++i;
        }
    }

    public IWizardPage getStartingPage() {
        if (this.hasUserInput()) {
            return super.getStartingPage();
        }
        return this.computeUserInputSuccessorPage(null, (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.hasUserInput()) {
            return super.getPreviousPage(page);
        }
        if (!page.getName().equals("ErrorPage") && this.fConditionCheckingStatus.isOK()) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    IWizardPage computeUserInputSuccessorPage(IWizardPage caller, IRunnableContext context) {
        Change change = this.createChange(new CreateChangeOperation(new CheckConditionsOperation(this.fRefactoring, 4), 4), true, context);
        RefactoringStatus status = this.getConditionCheckingStatus();
        if (change == null && status == null) {
            this.internalSetChange(InternalAPI.INSTANCE, change);
            return caller;
        }
        if (!status.hasFatalError()) {
            this.internalSetChange(InternalAPI.INSTANCE, change);
        }
        if (status.isOK()) {
            return this.getPage("PreviewPage");
        }
        return this.getPage("ErrorPage");
    }

    public boolean canFinish() {
        if (this.fForcePreviewReview && !this.fPreviewShown) {
            return false;
        }
        return super.canFinish();
    }

    final RefactoringStatus checkFinalConditions() {
        return this.internalCheckCondition(4);
    }

    private RefactoringStatus internalCheckCondition(int style) {
        CheckConditionsOperation op = new CheckConditionsOperation(this.fRefactoring, style);
        Exception exception = null;
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
        }
        catch (InterruptedException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        RefactoringStatus status = null;
        if (exception != null) {
            RefactoringUIPlugin.log(exception);
            status = new RefactoringStatus();
            status.addFatalError(RefactoringUIMessages.RefactoringWizard_internal_error_1);
        } else {
            status = op.getStatus();
        }
        this.setConditionCheckingStatus(status, style);
        return status;
    }

    private void setConditionCheckingStatus(RefactoringStatus status, int style) {
        if ((style & 6) == 6) {
            this.setConditionCheckingStatus(status);
        } else if ((style & 2) == 2) {
            this.setInitialConditionCheckingStatus(status);
        } else if ((style & 4) == 4) {
            this.setFinalConditionCheckingStatus(status);
        }
    }

    private RefactoringStatus getConditionCheckingStatus() {
        return this.fConditionCheckingStatus;
    }

    final void setConditionCheckingStatus(RefactoringStatus status) {
        ErrorWizardPage page = (ErrorWizardPage)this.getPage("ErrorPage");
        if (page != null) {
            page.setStatus(status);
        }
        this.fConditionCheckingStatus = status;
    }

    private void setFinalConditionCheckingStatus(RefactoringStatus status) {
        RefactoringStatus newStatus = new RefactoringStatus();
        if (this.fInitialConditionCheckingStatus != null) {
            newStatus.merge(this.fInitialConditionCheckingStatus);
        }
        newStatus.merge(status);
        this.setConditionCheckingStatus(newStatus);
    }

    public final Change internalCreateChange(InternalAPI api, CreateChangeOperation operation, boolean updateStatus) {
        Assert.isNotNull(api);
        return this.createChange(operation, updateStatus, (IRunnableContext)this.getContainer());
    }

    public final FinishResult internalPerformFinish(InternalAPI api, PerformChangeOperation op) {
        op.setUndoManager(RefactoringCore.getUndoManager(), this.fRefactoring.getName());
        Shell parent = this.getContainer().getShell();
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
        }
        catch (InvocationTargetException e) {
            Throwable inner = e.getTargetException();
            if (op.changeExecutionFailed()) {
                ChangeExceptionHandler handler = new ChangeExceptionHandler(parent, this.fRefactoring);
                if (inner instanceof RuntimeException) {
                    handler.handle(op.getChange(), (RuntimeException)inner);
                    return FinishResult.createException();
                }
                if (inner instanceof CoreException) {
                    handler.handle(op.getChange(), (CoreException)inner);
                    return FinishResult.createException();
                }
            }
            ExceptionHandler.handle(e, parent, RefactoringUIMessages.RefactoringWizard_refactoring, RefactoringUIMessages.RefactoringWizard_unexpected_exception_1);
            return FinishResult.createException();
        }
        catch (InterruptedException interruptedException) {
            return FinishResult.createInterrupted();
        }
        return FinishResult.createOK();
    }

    private Change createChange(CreateChangeOperation operation, boolean updateStatus, IRunnableContext context) {
        InvocationTargetException exception = null;
        try {
            context.run(true, this.fIsChangeCreationCancelable, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
        }
        catch (InterruptedException interruptedException) {
            this.setConditionCheckingStatus(null);
            return null;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        if (updateStatus) {
            RefactoringStatus status = null;
            if (exception != null) {
                status = new RefactoringStatus();
                String msg = exception.getMessage();
                if (msg != null) {
                    status.addFatalError(Messages.format(RefactoringUIMessages.RefactoringWizard_see_log, msg));
                } else {
                    status.addFatalError(RefactoringUIMessages.RefactoringWizard_Internal_error);
                }
                RefactoringUIPlugin.log(exception);
            } else {
                status = operation.getConditionCheckingStatus();
            }
            this.setConditionCheckingStatus(status, operation.getConditionCheckingStyle());
        } else if (exception != null) {
            ExceptionHandler.handle(exception, this.getContainer().getShell(), RefactoringUIMessages.RefactoringWizard_refactoring, RefactoringUIMessages.RefactoringWizard_unexpected_exception);
        }
        Change change = operation.getChange();
        return change;
    }

    public boolean performFinish() {
        Assert.isNotNull(this.fRefactoring);
        RefactoringWizardPage page = (RefactoringWizardPage)this.getContainer().getCurrentPage();
        return page.performFinish();
    }

    public boolean performCancel() {
        if (this.fChange != null) {
            this.fChange.dispose();
        }
        return super.performCancel();
    }

    public final boolean internalHasPreviewPage(InternalAPI api) {
        Assert.isNotNull(api);
        return (this.fFlags & 0x10) == 0;
    }

    public final boolean internalIsYesNoStyle(InternalAPI api) {
        Assert.isNotNull(api);
        return (this.fFlags & 8) != 0;
    }

    public final boolean internalGetExpandFirstNode(InternalAPI api) {
        Assert.isNotNull(api);
        return (this.fFlags & 0x20) != 0;
    }

    public final void internalSetChange(InternalAPI api, Change change) {
        Assert.isNotNull(api);
        IPreviewWizardPage page = (IPreviewWizardPage)this.getPage("PreviewPage");
        if (page != null) {
            page.setChange(change);
        }
        this.fChange = change;
    }

    public final void internalSetPreviewShown(InternalAPI api, boolean shown) {
        Assert.isNotNull(api);
        this.fPreviewShown = shown;
        this.getContainer().updateButtons();
    }

    public final boolean internalShowBackButtonOnStatusDialog(InternalAPI api) {
        Assert.isNotNull(api);
        return (this.fFlags & 0x40) == 0;
    }

    private boolean checkActivationOnOpen() {
        return (this.fFlags & 1) != 0;
    }
}

