/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;

public class CreateChangeOperation
implements IWorkspaceRunnable {
    private Refactoring fRefactoring;
    private CheckConditionsOperation fCheckConditionOperation;
    private int fConditionCheckingFailedSeverity;
    private Change fChange;

    public CreateChangeOperation(Refactoring refactoring) {
        Assert.isNotNull((Object)refactoring);
        this.fRefactoring = refactoring;
    }

    public CreateChangeOperation(CheckConditionsOperation operation, int checkFailedSeverity) {
        Assert.isNotNull(operation);
        this.fCheckConditionOperation = operation;
        this.fRefactoring = operation.getRefactoring();
        Assert.isTrue(checkFailedSeverity > 0 && checkFailedSeverity <= 4);
        this.fConditionCheckingFailedSeverity = checkFailedSeverity;
    }

    public int getConditionCheckingFailedSeverity() {
        return this.fConditionCheckingFailedSeverity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        this.fChange = null;
        try {
            this.fChange = null;
            if (this.fCheckConditionOperation != null) {
                pm.beginTask("", 7);
                pm.subTask("");
                this.fCheckConditionOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 4));
                RefactoringStatus status = this.fCheckConditionOperation.getStatus();
                if (status != null && status.getSeverity() < this.fConditionCheckingFailedSeverity) {
                    this.fChange = this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2));
                    this.fChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(3);
                }
            } else {
                pm.beginTask("", 3);
                this.fChange = this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2));
                this.fChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
    }

    public Change getChange() {
        return this.fChange;
    }

    public RefactoringStatus getConditionCheckingStatus() {
        if (this.fCheckConditionOperation != null) {
            return this.fCheckConditionOperation.getStatus();
        }
        return null;
    }

    public int getConditionCheckingStyle() {
        if (this.fCheckConditionOperation != null) {
            return this.fCheckConditionOperation.getStyle();
        }
        return 0;
    }
}

