/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.StartServerJob;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class StartAction
extends AbstractServerAction {
    protected String launchMode = "run";

    public StartAction(Shell shell, ISelectionProvider selectionProvider, String name, String launchMode) {
        super(shell, selectionProvider, name);
        this.launchMode = launchMode;
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    public boolean accept(IServer server) {
        return server.canStart(this.launchMode).isOK();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(IServer server) {
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        if (!ServerPreferences.getInstance().isAutoPublishing()) {
            StartServerJob startJob = new StartServerJob(server, this.launchMode);
            startJob.schedule();
            return;
        }
        IProgressMonitor pm = Platform.getJobManager().createProgressGroup();
        try {
            block8: {
                try {
                    pm.beginTask("Starting", 10);
                    PublishServerJob publishJob = new PublishServerJob(server);
                    publishJob.setProgressGroup(pm, 5);
                    StartServerJob startJob = new StartServerJob(server, this.launchMode);
                    startJob.setProgressGroup(pm, 5);
                    if (((ServerType)server.getServerType()).startBeforePublish()) {
                        startJob.schedule();
                        publishJob.setDependantJob((Job)startJob);
                        publishJob.schedule();
                        break block8;
                    }
                    publishJob.schedule();
                    startJob.setDependantJob((Job)publishJob);
                    startJob.schedule();
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Error starting server", e);
                }
            }
            Object var5_9 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
    }
}

