/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ExtractTempRefactoring
extends Refactoring {
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private CompilationUnit fCompilationUnitNode;
    private final ICompilationUnit fCu;
    private boolean fDeclareFinal;
    private String[] fExcludedVariableNames;
    private boolean fReplaceAllOccurrences;
    private IExpressionFragment fSelectedExpression;
    private String fTempTypeName;
    private final int fSelectionLength;
    private final int fSelectionStart;
    private String fTempName;
    private TextEdit fImportEdit;
    private TextChange fChange;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static boolean allArraysEqual(Object[][] arrays, int position) {
        Object element = arrays[0][position];
        int i = 0;
        while (i < arrays.length) {
            Object[] array = arrays[i];
            if (!element.equals(array[position])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (ExtractTempRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (ExtractTempRefactoring.isLeftValue(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater((Expression)node)) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    public static ExtractTempRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength) {
        return new ExtractTempRefactoring(cu, selectionStart, selectionLength);
    }

    private static Object[] getArrayPrefix(Object[] array, int prefixLength) {
        Assert.isTrue(prefixLength <= array.length);
        Assert.isTrue(prefixLength >= 0);
        Object[] prefix = new Object[prefixLength];
        int i = 0;
        while (i < prefix.length) {
            prefix[i] = array[i];
            ++i;
        }
        return prefix;
    }

    private static List getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        Iterator iter = variableDeclarations.fragments().iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    private static Object[] getLongestArrayPrefix(Object[][] arrays) {
        int length = -1;
        if (arrays.length == 0) {
            return new Object[0];
        }
        int minArrayLength = arrays[0].length;
        int i = 1;
        while (i < arrays.length) {
            minArrayLength = Math.min(minArrayLength, arrays[i].length);
            ++i;
        }
        i = 0;
        while (i < minArrayLength) {
            if (!ExtractTempRefactoring.allArraysEqual(arrays, i)) break;
            ++length;
            ++i;
        }
        if (length == -1) {
            return new Object[0];
        }
        return ExtractTempRefactoring.getArrayPrefix(arrays[0], length + 1);
    }

    private static ASTNode[] getParents(ASTNode node) {
        ASTNode current = node;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>();
        do {
            parents.add(current.getParent());
        } while ((current = current.getParent()).getParent() != null);
        Collections.reverse(parents);
        return parents.toArray(new ASTNode[parents.size()]);
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return ExtractTempRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            List initializers;
            ForStatement forStmt;
            if (parent instanceof ForStatement && ((forStmt = (ForStatement)parent).initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                List forInitializerVariables = ExtractTempRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                ForStatementChecker checker = new ForStatementChecker(forInitializerVariables);
                expression.accept((ASTVisitor)checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private static String removeTrailingSemicolons(String s) {
        String arg = s.trim();
        if (!arg.endsWith(";")) {
            return arg;
        }
        return ExtractTempRefactoring.removeTrailingSemicolons(arg.substring(0, arg.length() - 1));
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (ExtractTempRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    private ExtractTempRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
    }

    private void addReplaceExpressionWithTemp(TextChange change) throws JavaModelException {
        TextEdit[] edits = this.createReplaceExpressionWithTempEdits();
        int i = 0;
        while (i < edits.length) {
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.ExtractTempRefactoring_replace, edits[i]);
            ++i;
        }
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
            }
            return null;
        }
        if (selectedExpression instanceof ConditionalExpression) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_single_conditional_expression);
        }
        if (selectedExpression instanceof SimpleName) {
            if (((SimpleName)selectedExpression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
            }
            if (selectedExpression.getParent() instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || selectedExpression.getParent() instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        ITextFileBuffer buffer = null;
        ICompilationUnit original = WorkingCopyUtil.getOriginal(this.fCu);
        try {
            buffer = RefactoringFileBuffers.acquire(original);
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 3);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkMatchingFragments());
            if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fTempName)) {
                result.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, this.fTempName));
            }
            TextChange change = this.doCreateChange(buffer, pm);
            change.setKeepPreviewEdits(true);
            this.checkNewSource(change, result);
            this.fChange = change;
            refactoringStatus = result;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            RefactoringFileBuffers.release(original);
            pm.done();
            throw throwable;
        }
        RefactoringFileBuffers.release(original);
        pm.done();
        return refactoringStatus;
    }

    private TextChange doCreateChange(ITextFileBuffer buffer, IProgressMonitor pm) throws CoreException, JavaModelException {
        CompilationUnitChange change = new CompilationUnitChange(RefactoringCoreMessages.ExtractTempRefactoring_extract_temp, this.fCu);
        try {
            String lineDelimiter = buffer.getDocument().getLineDelimiter(buffer.getDocument().getLineOfOffset(this.fSelectionStart));
            TextEdit tempDeclarationEdit = this.createTempDeclarationEdit(lineDelimiter);
            TextChangeCompatibility.addTextEdit((TextChange)change, RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable, tempDeclarationEdit);
        }
        catch (CoreException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        pm.worked(1);
        if (this.fImportEdit != null) {
            TextChangeCompatibility.addTextEdit((TextChange)change, RefactoringCoreMessages.ExtractTempRefactoring_update_imports, this.fImportEdit);
        }
        pm.worked(1);
        this.addReplaceExpressionWithTemp((TextChange)change);
        pm.worked(1);
        return change;
    }

    private void checkNewSource(TextChange change, RefactoringStatus result) throws CoreException {
        String newCuSource = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser p = ASTParser.newParser((int)3);
        p.setSource(newCuSource.toCharArray());
        p.setUnitName(this.fCu.getElementName());
        p.setProject(this.fCu.getJavaProject());
        p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)this.fCu));
        CompilationUnit newCUNode = (CompilationUnit)p.createAST(null);
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(JavaRefactorings.createStatusEntry(problem, newCuSource));
            }
            ++i;
        }
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode, IProgressMonitor pm) throws JavaModelException {
        this.fCompilationUnitNode = rootNode;
        return this.checkSelection(pm);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block6: {
            block5: {
                RefactoringStatus refactoringStatus;
                try {
                    pm.beginTask("", 6);
                    result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
                    if (!result.hasFatalError()) break block5;
                    refactoringStatus = result;
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
                return refactoringStatus;
            }
            if (this.fCu.isStructureKnown()) break block6;
            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_syntax_error);
            Object var4_7 = null;
            pm.done();
            return refactoringStatus;
        }
        CompilationUnit rootNode = new RefactoringASTParser(3).parse(this.fCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
        result.merge(this.checkActivationBasics(rootNode, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
        if (!result.hasFatalError() && this.isLiteralNodeSelected()) {
            this.fReplaceAllOccurrences = false;
        }
        RefactoringStatus refactoringStatus = result;
        Object var4_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkMatchingFragments() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IASTFragment[] matchingFragments = this.getMatchingFragments();
        int i = 0;
        while (i < matchingFragments.length) {
            ASTNode node = matchingFragments[i].getAssociatedNode();
            if (ExtractTempRefactoring.isLeftValue(node) && !ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
                String msg = RefactoringCoreMessages.ExtractTempRefactoring_assigned_to;
                result.addWarning(msg, JavaStatusContext.create(this.fCu, node));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            IExpressionFragment selectedExpression;
                            block12: {
                                block11: {
                                    block10: {
                                        RefactoringStatus refactoringStatus;
                                        try {
                                            pm.beginTask("", 8);
                                            selectedExpression = this.getSelectedExpression();
                                            if (selectedExpression != null) break block10;
                                            String message = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                                            refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                                            Object var5_14 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var5_23 = null;
                                            pm.done();
                                            throw throwable;
                                        }
                                        pm.done();
                                        return refactoringStatus;
                                    }
                                    pm.worked(1);
                                    if (!this.isUsedInExplicitConstructorCall()) break block11;
                                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_explicit_constructor);
                                    Object var5_15 = null;
                                    pm.done();
                                    return refactoringStatus;
                                }
                                pm.worked(1);
                                if (this.getEnclosingBodyNode() != null) break block12;
                                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_expr_in_method_or_initializer);
                                Object var5_16 = null;
                                pm.done();
                                return refactoringStatus;
                            }
                            pm.worked(1);
                            ASTNode associatedNode = selectedExpression.getAssociatedNode();
                            if (!(associatedNode instanceof Name) || !(associatedNode.getParent() instanceof ClassInstanceCreation) || associatedNode.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) break block13;
                            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
                            Object var5_17 = null;
                            pm.done();
                            return refactoringStatus;
                        }
                        pm.worked(1);
                        result = new RefactoringStatus();
                        result.merge(this.checkExpression());
                        if (!result.hasFatalError()) break block14;
                        RefactoringStatus refactoringStatus = result;
                        Object var5_18 = null;
                        pm.done();
                        return refactoringStatus;
                    }
                    pm.worked(1);
                    result.merge(this.checkExpressionFragmentIsRValue());
                    if (!result.hasFatalError()) break block15;
                    RefactoringStatus refactoringStatus = result;
                    Object var5_19 = null;
                    pm.done();
                    return refactoringStatus;
                }
                pm.worked(1);
                if (!ExtractTempRefactoring.isUsedInForInitializerOrUpdater(this.getSelectedExpression().getAssociatedExpression())) break block16;
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                Object var5_20 = null;
                pm.done();
                return refactoringStatus;
            }
            pm.worked(1);
            if (!ExtractTempRefactoring.isReferringToLocalVariableFromFor(this.getSelectedExpression().getAssociatedExpression())) break block17;
            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_refers_to_for_variable);
            Object var5_21 = null;
            pm.done();
            return refactoringStatus;
        }
        pm.worked(1);
        RefactoringStatus refactoringStatus = result;
        Object var5_22 = null;
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.checkTempName(newName);
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, newName));
        }
        return status;
    }

    private TextEdit createAndInsertTempDeclaration(String delimiter) throws CoreException {
        ASTNode insertBefore = this.getNodeToInsertTempDeclarationBefore();
        int insertOffset = insertBefore.getStartPosition();
        String text = String.valueOf(this.createTempDeclarationSource(this.getInitializerSource(), true, delimiter)) + CodeFormatterUtil.createIndentString(CodeRefactoringUtil.getIndentationLevel(insertBefore, this.fCu), this.fCu.getJavaProject());
        return new InsertEdit(insertOffset, text);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.done();
        return this.fChange;
    }

    private TextEdit[] createReplaceExpressionWithTempEdits() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        TextEdit[] result = new TextEdit[fragmentsToReplace.length];
        int i = 0;
        while (i < fragmentsToReplace.length) {
            IASTFragment fragment = fragmentsToReplace[i];
            int offset = fragment.getStartPosition();
            int length = fragment.getLength();
            result[i] = new ReplaceEdit(offset, length, this.fTempName);
            ++i;
        }
        return result;
    }

    private TextEdit createTempDeclarationEdit(String delimiter) throws CoreException {
        if (this.shouldReplaceSelectedExpressionWithTempDeclaration()) {
            return this.replaceSelectedExpressionWithTempDeclaration(delimiter);
        }
        return this.createAndInsertTempDeclaration(delimiter);
    }

    private String createTempDeclarationSource(String initializerSource, boolean addTrailingLineDelimiter, String delimiter) throws CoreException {
        String modifier = this.fDeclareFinal ? "final " : "";
        String dummyInitializer = "0";
        String semicolon = ";";
        String dummyDeclaration = String.valueOf(modifier) + this.getTempTypeName() + " " + this.fTempName + " = " + dummyInitializer + semicolon;
        int[] position = new int[]{dummyDeclaration.length() - dummyInitializer.length() - semicolon.length()};
        String formattedDeclaration = CodeFormatterUtil.format(2, dummyDeclaration, 0, position, delimiter, this.fCu.getJavaProject());
        StringBuffer formattedDummyDeclaration = new StringBuffer(formattedDeclaration);
        String tail = addTrailingLineDelimiter ? delimiter : "";
        return formattedDummyDeclaration.replace(position[0], position[0] + dummyInitializer.length(), initializerSource).append(tail).toString();
    }

    public boolean declareFinal() {
        return this.fDeclareFinal;
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes() throws JavaModelException {
        ASTNode[] matchNodes = this.getMatchNodes();
        Object[][] matchingNodesParents = new ASTNode[matchNodes.length][];
        int i = 0;
        while (i < matchNodes.length) {
            matchingNodesParents[i] = ExtractTempRefactoring.getParents(matchNodes[i]);
            ++i;
        }
        List<Object> l = Arrays.asList(ExtractTempRefactoring.getLongestArrayPrefix(matchingNodesParents));
        return l.toArray(new ASTNode[l.size()]);
    }

    private Block getEnclosingBodyNode() throws JavaModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        do {
            switch (node.getNodeType()) {
                case 31: {
                    return ((MethodDeclaration)node).getBody();
                }
                case 28: {
                    return ((Initializer)node).getBody();
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 2);
                this.fExcludedVariableNames = new String[bindings.length];
                int i = 0;
                while (i < bindings.length) {
                    this.fExcludedVariableNames[i] = bindings[i].getName();
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private IExpressionFragment getFirstReplacedExpression() throws JavaModelException {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        IASTFragment[] nodesToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        if (nodesToReplace.length == 0) {
            return this.getSelectedExpression();
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IASTFragment)o1).getStartPosition() - ((IASTFragment)o2).getStartPosition();
            }
        };
        Arrays.sort(nodesToReplace, comparator);
        return (IExpressionFragment)nodesToReplace[0];
    }

    private String getInitializerSource() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        return ExtractTempRefactoring.removeTrailingSemicolons(this.fCu.getBuffer().getText(fragment.getStartPosition(), fragment.getLength()));
    }

    private Statement getInnermostStatementInBlock(ASTNode node) {
        Block block;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Block");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((block = (Block)ASTNodes.getParent(node, clazz)) == null) {
            return null;
        }
        Iterator iter = block.statements().iterator();
        while (iter.hasNext()) {
            Statement statement = (Statement)iter.next();
            if (!ASTNodes.isParent(node, (ASTNode)statement)) continue;
            return statement;
        }
        return null;
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        if (this.fReplaceAllOccurrences) {
            IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)this.getEnclosingBodyNode()).getSubFragmentsMatching(this.getSelectedExpression());
            return allMatches;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private ASTNode[] getMatchNodes() throws JavaModelException {
        IASTFragment[] matches = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTNode[] result = new ASTNode[matches.length];
        int i = 0;
        while (i < matches.length) {
            result[i] = matches[i].getAssociatedNode();
            ++i;
        }
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractTempRefactoring_name;
    }

    private ASTNode getNodeToInsertTempDeclarationBefore() throws JavaModelException {
        if (!this.fReplaceAllOccurrences || ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments()).length <= 1) {
            return this.getInnermostStatementInBlock(this.getSelectedExpression().getAssociatedNode());
        }
        ASTNode[] firstReplaceNodeParents = ExtractTempRefactoring.getParents(this.getFirstReplacedExpression().getAssociatedNode());
        ASTNode[] commonPath = this.findDeepestCommonSuperNodePathForReplacedNodes();
        Assert.isTrue(commonPath.length <= firstReplaceNodeParents.length);
        ASTNode deepestCommonParent = firstReplaceNodeParents[commonPath.length - 1];
        if (deepestCommonParent instanceof TryStatement || deepestCommonParent instanceof IfStatement) {
            if (deepestCommonParent.getParent() instanceof Block) {
                return deepestCommonParent;
            }
            if (deepestCommonParent.getParent() instanceof SwitchStatement) {
                SwitchStatement statement = (SwitchStatement)deepestCommonParent.getParent();
                List statements = statement.statements();
                int index = 0;
                while (index < statements.size()) {
                    if (statements.get(index) == deepestCommonParent) {
                        int offset = index;
                        while (offset >= 0) {
                            if (statements.get(offset) instanceof SwitchCase) {
                                int stat = offset + 1;
                                while (stat < statements.size()) {
                                    if (!(statements.get(stat) instanceof VariableDeclarationStatement)) {
                                        return (ASTNode)statements.get(stat);
                                    }
                                    ++stat;
                                }
                            }
                            --offset;
                        }
                    }
                    ++index;
                }
            }
            if (commonPath.length < firstReplaceNodeParents.length) {
                return this.getInnermostStatementInBlock(firstReplaceNodeParents[commonPath.length]);
            }
        }
        if (deepestCommonParent instanceof Block) {
            return firstReplaceNodeParents[commonPath.length];
        }
        return this.getInnermostStatementInBlock(this.getFirstReplacedExpression().getAssociatedNode());
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null && selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
            ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
            Expression expression = exprStatement.getExpression();
            this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    public String getTempSignaturePreview() throws CoreException {
        return String.valueOf(this.getTempTypeName()) + " " + this.fTempName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTempTypeName() throws CoreException {
        if (this.fTempTypeName == null) {
            String tempTypeName;
            Expression expression = this.getSelectedExpression().getAssociatedExpression();
            if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)expression;
                tempTypeName = creation.getExpression() instanceof ClassInstanceCreation ? String.valueOf(this.getClassInstanceName((ClassInstanceCreation)creation.getExpression())) + this.getClassInstanceName(creation) : this.getClassInstanceName(creation);
            } else if (expression instanceof CastExpression) {
                CastExpression cast = (CastExpression)expression;
                tempTypeName = ASTNodes.asString((ASTNode)cast.getType());
            } else {
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                if (typeBinding.isPrimitive()) {
                    tempTypeName = typeBinding.getName();
                } else {
                    typeBinding = Bindings.normalizeForDeclarationUse(typeBinding, expression.getAST());
                    ImportRewrite importRewrite = new ImportRewrite(this.fCu);
                    tempTypeName = importRewrite.addImport(typeBinding);
                    if (!importRewrite.isEmpty()) {
                        ITextFileBuffer buffer = null;
                        ICompilationUnit original = WorkingCopyUtil.getOriginal(this.fCu);
                        try {
                            buffer = RefactoringFileBuffers.acquire(original);
                            this.fImportEdit = importRewrite.createEdit(buffer.getDocument(), (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            RefactoringFileBuffers.release(original);
                            throw throwable;
                        }
                        {
                            Object var7_11 = null;
                        }
                        RefactoringFileBuffers.release(original);
                    }
                }
            }
            this.fTempTypeName = tempTypeName;
        }
        return this.fTempTypeName;
    }

    private String getClassInstanceName(ClassInstanceCreation creation) {
        return ASTNodes.asString((ASTNode)creation.getType());
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.fTempName;
        }
        return proposals[0];
    }

    public String[] guessTempNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        try {
            Expression expression;
            String[] excludedVariableNames = this.getExcludedVariableNames();
            ASTNode associatedNode = this.getSelectedExpression().getAssociatedNode();
            if (associatedNode instanceof MethodInvocation) {
                proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)associatedNode, excludedVariableNames));
            } else if (associatedNode instanceof CastExpression && (expression = ((CastExpression)associatedNode).getExpression()) instanceof MethodInvocation) {
                proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)expression, excludedVariableNames));
            }
            if (associatedNode instanceof Expression) {
                proposals.addAll(this.guessTempNamesFromExpression((Expression)associatedNode, excludedVariableNames));
            }
        }
        catch (JavaModelException javaModelException) {}
        return proposals.toArray(new String[proposals.size()]);
    }

    private List guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = selectedExpression.resolveTypeBinding();
        String typeName = ExtractTempRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        int typeParamStart = typeName.indexOf("<");
        if (typeParamStart != -1) {
            typeName = typeName.substring(0, typeParamStart);
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fCu.getJavaProject(), typeName, expressionBinding.getDimensions(), excluded);
        return Arrays.asList(proposals);
    }

    private List guessTempNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        int i = 0;
        while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
            String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
            if (methodName.startsWith(prefix)) {
                if (methodName.length() == prefix.length()) {
                    return Collections.EMPTY_LIST;
                }
                char firstAfterPrefix = methodName.charAt(prefix.length());
                if (Character.isUpperCase(firstAfterPrefix)) {
                    String proposal;
                    methodName = proposal = String.valueOf(Character.toLowerCase(firstAfterPrefix)) + methodName.substring(prefix.length() + 1);
                    break;
                }
            }
            ++i;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fCu.getJavaProject(), methodName, 0, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.ConstructorInvocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ASTNodes.getParent((ASTNode)selectedExpression, clazz) != null) {
            return true;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.dom.SuperConstructorInvocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent((ASTNode)selectedExpression, clazz2) != null;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    private TextEdit replaceSelectedExpressionWithTempDeclaration(String delimiter) throws CoreException {
        String nodeSource = this.fCu.getBuffer().getText(this.getSelectedExpression().getStartPosition(), this.getSelectedExpression().getLength());
        String text = this.createTempDeclarationSource(nodeSource, false, delimiter);
        ASTNode parent = this.getSelectedExpression().getAssociatedNode().getParent();
        Assert.isTrue(parent instanceof ExpressionStatement);
        return new ReplaceEdit(parent.getStartPosition(), parent.getLength(), text);
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setTempName(String newName) {
        this.fTempName = newName;
    }

    private boolean shouldReplaceSelectedExpressionWithTempDeclaration() throws JavaModelException {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        return selectedFragment.getAssociatedNode().getParent() instanceof ExpressionStatement && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(selectedFragment.getAssociatedNode()));
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection forInitializerVariables) {
            Assert.isNotNull(forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }
}

