/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewrite {
    private ICompilationUnit fCu;
    private List fTextEditGroups = new ArrayList();
    private CompilationUnit fRoot;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ImportRemover fImportRemover;
    private boolean fResolveBindings = true;
    private final WorkingCopyOwner fOwner;
    static /* synthetic */ Class class$0;

    public CompilationUnitRewrite(ICompilationUnit cu) {
        this(null, cu, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu) {
        this(owner, cu, null);
    }

    public CompilationUnitRewrite(ICompilationUnit cu, CompilationUnit root) {
        this(null, cu, root);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu, CompilationUnit root) {
        this.fOwner = owner;
        this.fCu = cu;
        this.fRoot = root;
    }

    public void setResolveBindings(boolean resolve) {
        this.fResolveBindings = resolve;
    }

    public void clearASTRewrite() {
        this.fRewrite = null;
        this.fTextEditGroups = new ArrayList();
    }

    public void clearImportRewrites() {
        this.fImportRewrite = null;
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
        this.fImportRewrite = null;
    }

    public TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fTextEditGroups.add(result);
        return result;
    }

    public CompilationUnitChange createChange() throws CoreException {
        CompilationUnitChange compilationUnitChange;
        block18: {
            ITextFileBuffer buffer;
            CompilationUnitChange cuChange;
            block16: {
                CompilationUnitChange compilationUnitChange2;
                block17: {
                    boolean needsImportRewrite;
                    boolean needsAstRewrite = this.fRewrite != null;
                    boolean needsImportRemoval = this.fImportRemover != null && this.fImportRemover.hasRemovedNodes();
                    boolean bl = needsImportRewrite = this.fImportRewrite != null && !this.fImportRewrite.isEmpty();
                    if (!(needsAstRewrite || needsImportRemoval || needsImportRewrite)) {
                        return null;
                    }
                    cuChange = new CompilationUnitChange(this.fCu.getElementName(), this.fCu);
                    buffer = null;
                    IDocument document = null;
                    try {
                        TextEdit importsEdit;
                        TextEdit rewriteEdit;
                        if (!JavaModelUtil.isPrimary(this.fCu)) {
                            document = new Document(this.fCu.getBuffer().getContents());
                        } else {
                            buffer = RefactoringFileBuffers.acquire(this.fCu);
                            document = buffer.getDocument();
                        }
                        MultiTextEdit multiEdit = new MultiTextEdit();
                        cuChange.setEdit((TextEdit)multiEdit);
                        if (needsAstRewrite && !CompilationUnitRewrite.isEmptyEdit(rewriteEdit = this.fRewrite.rewriteAST(document, this.fCu.getJavaProject().getOptions(true)))) {
                            multiEdit.addChild(rewriteEdit);
                            Iterator iter = this.fTextEditGroups.iterator();
                            while (iter.hasNext()) {
                                cuChange.addTextEditGroup((TextEditGroup)iter.next());
                            }
                        }
                        if (needsImportRemoval) {
                            IBinding[] bindings = this.fImportRemover.getImportsToRemove();
                            int i = 0;
                            while (i < bindings.length) {
                                IMethodBinding binding;
                                if (bindings[i] instanceof ITypeBinding) {
                                    this.getImportRewrite().removeImport((ITypeBinding)bindings[i]);
                                } else if (bindings[i] instanceof IMethodBinding) {
                                    binding = (IMethodBinding)bindings[i];
                                    this.getImportRewrite().removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + "." + binding.getName());
                                } else if (bindings[i] instanceof IVariableBinding) {
                                    binding = (IVariableBinding)bindings[i];
                                    this.getImportRewrite().removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + "." + binding.getName());
                                }
                                ++i;
                            }
                        }
                        if (this.fImportRewrite != null && !this.fImportRewrite.isEmpty() && !CompilationUnitRewrite.isEmptyEdit(importsEdit = this.fImportRewrite.createEdit(document, null))) {
                            multiEdit.addChild(importsEdit);
                            String importUpdateName = RefactoringCoreMessages.ASTData_update_imports;
                            cuChange.addTextEditGroup(new TextEditGroup(importUpdateName, importsEdit));
                        }
                        if (!CompilationUnitRewrite.isEmptyEdit((TextEdit)multiEdit)) break block16;
                        compilationUnitChange2 = null;
                        Object var11_14 = null;
                        if (buffer == null) break block17;
                    }
                    catch (Throwable throwable) {
                        block19: {
                            Object var11_16 = null;
                            if (buffer == null) break block19;
                            RefactoringFileBuffers.release(this.fCu);
                        }
                        throw throwable;
                    }
                    RefactoringFileBuffers.release(this.fCu);
                }
                return compilationUnitChange2;
            }
            compilationUnitChange = cuChange;
            Object var11_15 = null;
            if (buffer == null) break block18;
            RefactoringFileBuffers.release(this.fCu);
        }
        return compilationUnitChange;
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        Class<?> clazz = edit.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.text.edits.MultiTextEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz == clazz2 && !edit.hasChildren();
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public CompilationUnit getRoot() {
        if (this.fRoot == null) {
            this.fRoot = new RefactoringASTParser(3).parse(this.fCu, this.fOwner, this.fResolveBindings, null);
        }
        return this.fRoot;
    }

    public AST getAST() {
        return this.getRoot().getAST();
    }

    public ASTRewrite getASTRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = ASTRewrite.create((AST)this.getRoot().getAST());
        }
        return this.fRewrite;
    }

    public ImportRewrite getImportRewrite() {
        if (this.fImportRewrite == null) {
            try {
                this.fImportRewrite = new ImportRewrite(this.fCu);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.fImportRewrite;
    }

    public ImportRemover getImportRemover() {
        if (this.fImportRemover == null) {
            this.fImportRemover = new ImportRemover(this.fCu.getJavaProject(), this.getRoot());
        }
        return this.fImportRemover;
    }
}

