/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDragAdapter
implements DragSourceListener {
    private TransferDragSourceListener[] fPossibleListeners;
    private List fActiveListeners;
    private TransferDragSourceListener fFinishListener;

    public DelegatingDragAdapter(TransferDragSourceListener[] listeners) {
        this.setPossibleListeners(listeners);
    }

    protected void setPossibleListeners(TransferDragSourceListener[] listeners) {
        Assert.isNotNull((Object)listeners);
        Assert.isTrue((this.fActiveListeners == null ? 1 : 0) != 0, (String)"Can only set possible listeners before drag operation has started");
        this.fPossibleListeners = listeners;
    }

    public void dragStart(DragSourceEvent event) {
        this.fFinishListener = null;
        boolean saveDoit = event.doit;
        Object saveData = event.data;
        boolean doIt = false;
        ArrayList<Transfer> transfers = new ArrayList<Transfer>(this.fPossibleListeners.length);
        this.fActiveListeners = new ArrayList(this.fPossibleListeners.length);
        int i = 0;
        while (i < this.fPossibleListeners.length) {
            TransferDragSourceListener listener = this.fPossibleListeners[i];
            event.doit = saveDoit;
            listener.dragStart(event);
            if (event.doit) {
                transfers.add(listener.getTransfer());
                this.fActiveListeners.add(listener);
            }
            doIt = doIt || event.doit;
            ++i;
        }
        if (doIt) {
            ((DragSource)event.widget).setTransfer(transfers.toArray(new Transfer[transfers.size()]));
        }
        event.data = saveData;
        event.doit = doIt;
    }

    public void dragSetData(DragSourceEvent event) {
        this.fFinishListener = this.getListener(event.dataType);
        if (this.fFinishListener != null) {
            this.fFinishListener.dragSetData(event);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dragFinished(DragSourceEvent event) {
        try {
            if (this.fFinishListener != null) {
                this.fFinishListener.dragFinished(event);
            } else {
                this.fFinishListener = this.getListener(event.dataType);
                if (this.fFinishListener != null) {
                    this.fFinishListener.dragFinished(event);
                }
            }
            Object var2_4 = null;
            this.fFinishListener = null;
            this.fActiveListeners = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fFinishListener = null;
            this.fActiveListeners = null;
            throw throwable;
        }
    }

    private TransferDragSourceListener getListener(TransferData type) {
        if (type == null) {
            return null;
        }
        Iterator iter = this.fActiveListeners.iterator();
        while (iter.hasNext()) {
            TransferDragSourceListener listener = (TransferDragSourceListener)iter.next();
            if (!listener.getTransfer().isSupportedType(type)) continue;
            return listener;
        }
        return null;
    }
}

