/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertyKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private String fPropertiesKey;
    private Shell fShell;
    private IStorage fStorage;
    private ITextEditor fEditor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PropertyKeyHyperlink(IRegion region, String key, ITextEditor editor) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)editor);
        this.fRegion = region;
        this.fPropertiesKey = key;
        this.fEditor = editor;
        IStorageEditorInput storageEditorInput = (IStorageEditorInput)this.fEditor.getEditorInput();
        this.fShell = this.fEditor.getEditorSite().getShell();
        try {
            this.fStorage = storageEditorInput.getStorage();
        }
        catch (CoreException coreException) {
            this.fStorage = null;
        }
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (!this.checkEnabled()) {
            return;
        }
        IResource resource = (IResource)this.fStorage;
        KeyReference[] references = null;
        if (resource != null) {
            references = this.search((IResource)resource.getProject(), this.fPropertiesKey);
        }
        if (references == null) {
            return;
        }
        if (references.length == 0) {
            String message = PropertiesFileEditorMessages.OpenAction_error_messageNoResult;
            this.showErrorInStatusLine(message);
            return;
        }
        this.open(references);
    }

    private boolean checkEnabled() {
        return this.fStorage instanceof IResource;
    }

    private void open(KeyReference[] keyReferences) {
        Assert.isLegal((keyReferences != null && keyReferences.length > 0 ? 1 : 0) != 0);
        if (keyReferences.length == 1) {
            this.open(keyReferences[0]);
        } else {
            this.open(this.select(keyReferences));
        }
    }

    private KeyReference select(final KeyReference[] keyReferences) {
        Object[] result;
        Arrays.sort(keyReferences);
        final int length = keyReferences.length;
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider(){

            public String decorateText(String input, Object element) {
                KeyReference keyRef = (KeyReference)element;
                IStorage storage = keyRef.storage;
                String name = storage.getName();
                if (name == null) {
                    return input;
                }
                int count = 0;
                int i = 0;
                while (i < length) {
                    if (keyReferences[i].storage.equals(storage)) {
                        ++count;
                    }
                    ++i;
                }
                if (count > 1) {
                    Object[] args = new Object[]{name, new Integer(count)};
                    name = Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabelWithMatchCount, args);
                }
                return name;
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.fShell, (ILabelProvider)labelProvider, (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setLowerListLabel(PropertiesFileEditorMessages.OpenAction_SelectionDialog_details);
        dialog.setMultipleSelection(false);
        dialog.setTitle(PropertiesFileEditorMessages.OpenAction_SelectionDialog_title);
        dialog.setMessage(PropertiesFileEditorMessages.OpenAction_SelectionDialog_message);
        dialog.setElements((Object[])keyReferences);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            return (KeyReference)result[0];
        }
        return null;
    }

    private void open(KeyReference keyReference) {
        if (keyReference == null) {
            return;
        }
        try {
            IEditorPart part = EditorUtility.openInEditor(keyReference.storage, true);
            EditorUtility.revealInEditor(part, keyReference.offset, keyReference.length);
        }
        catch (JavaModelException e) {
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, PropertiesFileEditorMessages.OpenAction_error_message, (Throwable)e));
            ErrorDialog.openError((Shell)this.fShell, (String)this.getErrorDialogTitle(), (String)PropertiesFileEditorMessages.OpenAction_error_messageProblems, (IStatus)e.getStatus());
        }
        catch (PartInitException x) {
            IWorkbenchAdapter wbAdapter;
            String message = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbAdapter = (IWorkbenchAdapter)keyReference.getAdapter(clazz)) != null) {
                message = Messages.format(PropertiesFileEditorMessages.OpenAction_error_messageArgs, new String[]{wbAdapter.getLabel((Object)keyReference), x.getLocalizedMessage()});
            }
            if (message == null) {
                message = Messages.format(PropertiesFileEditorMessages.OpenAction_error_message, x.getLocalizedMessage());
            }
            MessageDialog.openError((Shell)this.fShell, (String)PropertiesFileEditorMessages.OpenAction_error_messageProblems, (String)message);
        }
    }

    private String getErrorDialogTitle() {
        return PropertiesFileEditorMessages.OpenAction_error_title;
    }

    private void showError(CoreException e) {
        ExceptionHandler.handle(e, this.fShell, this.getErrorDialogTitle(), PropertiesFileEditorMessages.OpenAction_error_message);
    }

    private void showErrorInStatusLine(final String message) {
        IEditorStatusLine statusLine;
        this.fShell.getDisplay().beep();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.fEditor.getAdapter((Class)clazz)) != null) {
            this.fShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    statusLine.setMessage(true, message, null);
                }
            });
        }
    }

    private boolean useDoubleQuotedKey() {
        if (this.fStorage == null) {
            return false;
        }
        String name = this.fStorage.getName();
        return name != null && !"about.properties".equals(name) && !"feature.properties".equals(name) && !"plugin.properties".equals(name);
    }

    private KeyReference[] search(final IResource scope, String key) {
        String searchString;
        if (key == null) {
            return new KeyReference[0];
        }
        final ArrayList result = new ArrayList(5);
        if (this.useDoubleQuotedKey()) {
            StringBuffer buf = new StringBuffer("\"");
            buf.append(this.fPropertiesKey);
            buf.append('\"');
            searchString = buf.toString();
        } else {
            searchString = this.fPropertiesKey;
        }
        try {
            this.fEditor.getEditorSite().getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ResultCollector collector = new ResultCollector(result, monitor, PropertyKeyHyperlink.this.useDoubleQuotedKey());
                    TextSearchEngine engine = new TextSearchEngine();
                    engine.search(PropertyKeyHyperlink.createScope(scope), false, (ITextSearchResultCollector)collector, new MatchLocator(searchString, true, false));
                }
            });
        }
        catch (InvocationTargetException ex) {
            String message = PropertiesFileEditorMessages.OpenAction_error_messageErrorSearchingKey;
            this.showError(new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 0, message, ex.getTargetException())));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return result.toArray(new KeyReference[result.size()]);
    }

    private static SearchScope createScope(IResource scope) {
        SearchScope result = SearchScope.newSearchScope((String)"", (IResource[])new IResource[]{scope});
        result.addFileNamePattern("*.java");
        result.addFileNamePattern("*.xml");
        result.addFileNamePattern("*.ini");
        return result;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    private static class KeyReference
    extends PlatformObject
    implements IWorkbenchAdapter,
    Comparable {
        private static final Collator fgCollator = Collator.getInstance();
        private IStorage storage;
        private int offset;
        private int length;
        static /* synthetic */ Class class$0;

        KeyReference(IStorage storage, int offset, int length) {
            Assert.isNotNull((Object)storage);
            this.storage = storage;
            this.offset = offset;
            this.length = length;
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return this;
            }
            return super.getAdapter(adapter);
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkbenchAdapter wbAdapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbAdapter = (IWorkbenchAdapter)this.storage.getAdapter((Class)clazz)) != null) {
                return wbAdapter.getImageDescriptor((Object)this.storage);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getLabel(Object o) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                block6: {
                    String string;
                    manager.connect(this.storage.getFullPath(), null);
                    try {
                        ITextFileBuffer buffer = manager.getTextFileBuffer(this.storage.getFullPath());
                        IDocument document = buffer.getDocument();
                        if (document == null) break block6;
                        int line = document.getLineOfOffset(this.offset) + 1;
                        Object[] args = new Object[]{new Integer(line), this.storage.getFullPath()};
                        string = Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabel, args);
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        manager.disconnect(this.storage.getFullPath(), null);
                        throw throwable;
                    }
                    manager.disconnect(this.storage.getFullPath(), null);
                    return string;
                }
                Object var7_12 = null;
                manager.disconnect(this.storage.getFullPath(), null);
                return this.storage.getFullPath().toString();
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
                return this.storage.getFullPath().toString();
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            return this.storage.getFullPath().toString();
        }

        public Object getParent(Object o) {
            return null;
        }

        public int compareTo(Object o) {
            String otherPath;
            KeyReference otherRef = (KeyReference)o;
            String thisPath = this.storage.getFullPath().toString();
            int result = fgCollator.compare(thisPath, otherPath = otherRef.storage.getFullPath().toString());
            if (result != 0) {
                return result;
            }
            return this.offset - otherRef.offset;
        }
    }

    private static class ResultCollector
    implements ITextSearchResultCollector {
        private List fResult;
        private IProgressMonitor fProgressMonitor;
        private boolean fIsKeyDoubleQuoted;

        public ResultCollector(List result, IProgressMonitor progressMonitor, boolean isKeyDoubleQuoted) {
            this.fResult = result;
            this.fProgressMonitor = progressMonitor;
            this.fIsKeyDoubleQuoted = isKeyDoubleQuoted;
        }

        public void aboutToStart() throws CoreException {
        }

        public void accept(IResourceProxy proxy, int start, int length) throws CoreException {
            if (this.fIsKeyDoubleQuoted) {
                ++start;
                length -= 2;
            }
            this.fResult.add(new KeyReference((IStorage)((IFile)proxy.requestResource()), start, length));
        }

        public void done() throws CoreException {
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }
    }
}

