/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.folding;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.ui.text.folding.EmptyJavaFoldingPreferenceBlock;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingPreferenceBlock;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jface.text.Assert;

public final class JavaFoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private String fClass;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    JavaFoldingStructureProviderDescriptor(IConfigurationElement element) {
        this.fElement = element;
        this.fId = element.getAttributeAsIs(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = element.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fClass = element.getAttributeAsIs(CLASS);
        Assert.isLegal((this.fClass != null ? 1 : 0) != 0);
        this.fHasPreferences = element.getAttributeAsIs(PREFERENCES_CLASS) != null;
    }

    public IJavaFoldingStructureProvider createProvider() throws CoreException {
        IJavaFoldingStructureProvider prov = (IJavaFoldingStructureProvider)this.fElement.createExecutableExtension(CLASS);
        return prov;
    }

    public IJavaFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            IJavaFoldingPreferenceBlock prefs = (IJavaFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return prefs;
        }
        return new EmptyJavaFoldingPreferenceBlock();
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

