/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.workingsets.JavaWorkingSetPageContentProvider;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class JavaWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.JavaWorkingSetPage_title;
    private static final String PAGE_ID = "javaWorkingSetPage";
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public JavaWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, JavaPluginImages.DESC_WIZBAN_JAVA_WORKINGSET);
        this.setDescription(WorkingSetMessages.JavaWorkingSetPage_workingSet_description);
        this.fFirstCheck = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.JavaWorkingSetPage_workingSet_name);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.JavaWorkingSetPage_workingSet_content);
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fTree = new CheckboxTreeViewer(composite, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTreeContentProvider = new JavaWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider fJavaElementLabelProvider = new AppearanceAwareLabelProvider(36421324767273L, 3);
        this.fTree.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(fJavaElementLabelProvider));
        this.fTree.setSorter((ViewerSorter)new JavaElementSorter());
        this.fTree.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JavaWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!JavaWorkingSetPage.this.fTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)JavaWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            JavaWorkingSetPage.access$2(3.access$0(this.this$1), this.val$element, JavaWorkingSetPage.access$1(3.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ JavaWorkingSetPage access$0(3 var0) {
                return var0.JavaWorkingSetPage.this;
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(WorkingSetMessages.JavaWorkingSetPage_selectAll_label);
        selectAllButton.setToolTipText(WorkingSetMessages.JavaWorkingSetPage_selectAll_toolTip);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaWorkingSetPage.this.fTree.setCheckedElements(JavaWorkingSetPage.this.fTreeContentProvider.getElements(JavaWorkingSetPage.this.fTree.getInput()));
                JavaWorkingSetPage.this.validateInput();
            }
        });
        selectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(WorkingSetMessages.JavaWorkingSetPage_deselectAll_label);
        deselectAllButton.setToolTipText(WorkingSetMessages.JavaWorkingSetPage_deselectAll_toolTip);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaWorkingSetPage.this.fTree.setCheckedElements(new Object[0]);
                JavaWorkingSetPage.this.validateInput();
            }
        });
        deselectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(deselectAllButton);
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
        JavaUIHelp.setHelp((StructuredViewer)this.fTree, "org.eclipse.jdt.ui.java_working_set_page_context");
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(10);
        this.findCheckedElements(elements, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        } else {
            IAdaptable[] oldItems = this.fWorkingSet.getElements();
            ArrayList<IProject> closedWithChildren = new ArrayList<IProject>(elements.size());
            int i = 0;
            while (i < oldItems.length) {
                IProject project;
                IResource oldResource = null;
                if (oldItems[i] instanceof IResource) {
                    oldResource = (IResource)oldItems[i];
                } else {
                    IAdaptable iAdaptable = oldItems[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    oldResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (oldResource != null && !oldResource.isAccessible() && (elements.contains(project = oldResource.getProject()) || closedWithChildren.contains(project))) {
                    elements.add(oldItems[i]);
                    elements.remove(project);
                    closedWithChildren.add(project);
                }
                ++i;
            }
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private void validateInput() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.JavaWorkingSetPage_warning_nameWhitespace;
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = WorkingSetMessages.JavaWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = WorkingSetMessages.JavaWorkingSetPage_warning_workingSetExists;
                }
                ++i;
            }
        }
        if (errorMessage == null && !this.hasCheckedElement()) {
            errorMessage = WorkingSetMessages.JavaWorkingSetPage_warning_resourceMustBeChecked;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasCheckedElement() {
        TreeItem[] items = this.fTree.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.fTree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
            } else if (this.fTree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                boolean state = event.getChecked();
                JavaWorkingSetPage.this.fTree.setGrayed((Object)element, false);
                if (JavaWorkingSetPage.this.isExpandable(element)) {
                    JavaWorkingSetPage.this.setSubtreeChecked(element, state, state);
                }
                JavaWorkingSetPage.this.updateParentState(element, state);
                JavaWorkingSetPage.this.validateInput();
            }
        });
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        if (!(parent instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)parent;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContainer container = (IContainer)iAdaptable.getAdapter((Class)clazz);
        if (!this.fTree.getExpandedState(parent) && checkExpandedState || container != null && !container.isAccessible()) {
            return;
        }
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.fTree.setChecked(element, true);
                this.fTree.setGrayed(element, false);
            } else {
                this.fTree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(Object child, boolean baseChildState) {
        Object parent;
        if (child == null) {
            return;
        }
        if (child instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)child;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && !resource.isAccessible()) {
                return;
            }
        }
        if ((parent = this.fTreeContentProvider.getParent(child)) == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.fTree.getChecked(children[i]) != baseChildState || this.fTree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.fTree.setGrayed(parent, !allSameState);
        this.fTree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object element;
                Object[] elements;
                if (JavaWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage page = JavaPlugin.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IWorkbenchPart part = JavaPlugin.getActivePage().getActivePart();
                    if (part == null) {
                        return;
                    }
                    try {
                        elements = SelectionConverter.getStructuredSelection(part).toArray();
                        int i = 0;
                        while (i < elements.length) {
                            if (elements[i] instanceof IResource) {
                                IJavaElement je;
                                IResource iResource = (IResource)elements[i];
                                Class<?> clazz = class$2;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if ((je = (IJavaElement)iResource.getAdapter((Class)clazz)) != null && je.exists() && je.getJavaProject().isOnClasspath((IResource)elements[i])) {
                                    elements[i] = je;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return;
                    }
                }
                elements = JavaWorkingSetPage.this.fWorkingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    IJavaProject jProject;
                    IProject project;
                    element = elements[i];
                    if (element instanceof IResource && !(project = ((IResource)element).getProject()).isAccessible()) {
                        elements[i] = project;
                    }
                    if (element instanceof IJavaElement && (jProject = ((IJavaElement)element).getJavaProject()) != null && !jProject.getProject().isAccessible()) {
                        elements[i] = jProject.getProject();
                    }
                    ++i;
                }
                JavaWorkingSetPage.this.fTree.setCheckedElements(elements);
                i = 0;
                while (i < elements.length) {
                    element = elements[i];
                    if (JavaWorkingSetPage.this.isExpandable(element)) {
                        JavaWorkingSetPage.this.setSubtreeChecked(element, true, true);
                    }
                    JavaWorkingSetPage.this.updateParentState(element, true);
                    ++i;
                }
            }
        });
    }

    private boolean isExpandable(Object element) {
        return element instanceof IJavaProject || element instanceof IPackageFragmentRoot || element instanceof IPackageFragment || element instanceof IJavaModel || element instanceof IContainer;
    }
}

