/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.code.ExtractMethodWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ExtractMethodAction
extends SelectionDispatchAction {
    private final CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.ExtractMethodAction_dialog_title;

    public ExtractMethodAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.ExtractMethodAction_label);
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.extract_method_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(selection.getLength() == 0 ? false : this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(JavaTextSelection selection) {
        this.setEnabled(RefactoringAvailabilityTester.isExtractMethodAvailable(selection));
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            ExtractMethodRefactoring refactoring = ExtractMethodRefactoring.create(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection.getOffset(), selection.getLength());
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, new ExtractMethodWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, DIALOG_MESSAGE_TITLE, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }
}

