/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindImplementorsAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class FindImplementorsInWorkingSetAction
extends FindImplementorsAction {
    private IWorkingSet[] fWorkingSets;

    public FindImplementorsInWorkingSetAction(IWorkbenchSite site) {
        super(site);
    }

    public FindImplementorsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        this(site);
        this.fWorkingSets = workingSets;
    }

    public FindImplementorsInWorkingSetAction(JavaEditor editor) {
        super(editor);
    }

    public FindImplementorsInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        this(editor);
        this.fWorkingSets = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindImplementorsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindImplementorsInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_implementors_in_working_set_action");
    }

    protected JavaSearchQuery createJob(IJavaElement element) throws JavaModelException {
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        return new JavaSearchQuery(new ElementQuerySpecification(element, this.getLimitTo(), this.getScope(element), this.getScopeDescription(element)));
    }
}

