/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class OpenExternalJavadocAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenExternalJavadocAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenExternalJavadocAction_label);
        this.setDescription(ActionMessages.OpenExternalJavadocAction_description);
        this.setToolTipText(ActionMessages.OpenExternalJavadocAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_external_javadoc_action");
    }

    public OpenExternalJavadocAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaElement;
    }

    public void run(ITextSelection selection) {
        IJavaElement element = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        try {
            this.run(SelectionConverter.codeResolveOrInput(this.fEditor, this.getShell(), this.getDialogTitle(), ActionMessages.OpenExternalJavadocAction_select_element));
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), this.getDialogTitle(), ActionMessages.OpenExternalJavadocAction_code_resolve_failed);
        }
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        IJavaElement element = (IJavaElement)selection.getFirstElement();
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        this.run(element);
    }

    public void run(IJavaElement element) {
        if (element == null) {
            return;
        }
        Shell shell = this.getShell();
        try {
            URL noRefURL;
            String labelName = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
            URL baseURL = JavaUI.getJavadocBaseLocation(element);
            if (baseURL == null) {
                IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
                if (root != null && root.getKind() == 2) {
                    String message = ActionMessages.OpenExternalJavadocAction_libraries_no_location;
                    OpenExternalJavadocAction.showMessage(shell, MessageFormat.format(message, labelName, root.getElementName()), false);
                } else {
                    IJavaProject annotatedElement = element.getJavaProject();
                    String message = ActionMessages.OpenExternalJavadocAction_source_no_location;
                    OpenExternalJavadocAction.showMessage(shell, MessageFormat.format(message, labelName, annotatedElement.getElementName()), false);
                }
                return;
            }
            if ("file".equals(baseURL.getProtocol()) && !new File((noRefURL = JavaUI.getJavadocLocation(element, false)).getFile()).isFile()) {
                String message = ActionMessages.OpenExternalJavadocAction_no_entry;
                OpenExternalJavadocAction.showMessage(shell, MessageFormat.format(message, labelName, noRefURL.toExternalForm()), false);
                return;
            }
            URL url = JavaUI.getJavadocLocation(element, true);
            if (url != null) {
                OpenBrowserUtil.open(url, shell.getDisplay(), OpenExternalJavadocAction.getTitle());
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            OpenExternalJavadocAction.showMessage(shell, ActionMessages.OpenExternalJavadocAction_opening_failed, true);
        }
    }

    private static void showMessage(final Shell shell, final String message, final boolean isError) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (isError) {
                    MessageDialog.openError((Shell)shell, (String)OpenExternalJavadocAction.getTitle(), (String)message);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)OpenExternalJavadocAction.getTitle(), (String)message);
                }
            }
        });
    }

    private static String getTitle() {
        return ActionMessages.OpenExternalJavadocAction_dialog_title;
    }

    protected String getDialogTitle() {
        return OpenExternalJavadocAction.getTitle();
    }
}

