/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.util;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.dtd.core.internal.emf.DTDAttribute;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementReferenceContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntityReferenceContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.DTDGroupContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDGroupKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDNotation;
import org.eclipse.wst.dtd.core.internal.emf.DTDObject;
import org.eclipse.wst.dtd.core.internal.emf.DTDOccurrenceType;
import org.eclipse.wst.dtd.core.internal.emf.DTDPCDataContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.emf.DTDRepeatableContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDSourceOffset;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDVisitor;

public class DTDPrinter
extends DTDVisitor {
    StringBuffer sb = new StringBuffer();
    boolean updateOffset = true;

    public DTDPrinter(boolean updateOffset) {
        this.updateOffset = updateOffset;
    }

    public StringBuffer getBuffer() {
        return this.sb;
    }

    public void visitDTDFile(DTDFile file) {
        super.visitDTDFile(file);
    }

    public void visitDTDNotation(DTDNotation notation) {
        this.generateComment(notation);
        this.updateStartOffset(notation, this.sb.length());
        this.sb.append("<!NOTATION ");
        this.sb.append(notation.getName()).append(" ");
        String publicID = notation.getPublicID();
        String systemID = notation.getSystemID();
        if (publicID == null || publicID.equals("")) {
            this.sb.append("SYSTEM ");
        } else {
            this.sb.append("PUBLIC \"").append(publicID).append("\" ");
        }
        if (systemID == null) {
            this.sb.append("\"\"");
        } else {
            this.sb.append("\"").append(systemID).append("\"");
        }
        this.endTag();
        this.updateEndOffset(notation, this.sb.length() - 1);
        super.visitDTDNotation(notation);
    }

    public void visitDTDEntity(DTDEntity entity) {
        this.generateComment(entity);
        this.updateStartOffset(entity, this.sb.length());
        this.sb.append("<!ENTITY ");
        if (entity.isParameterEntity()) {
            this.sb.append("% ");
        }
        this.sb.append(entity.getName()).append(" ");
        this.sb.append(entity.getContent().unparse());
        this.endTag();
        this.updateEndOffset(entity, this.sb.length() - 1);
        super.visitDTDEntity(entity);
    }

    public void visitDTDElement(DTDElement element) {
        this.generateComment(element);
        this.updateStartOffset(element, this.sb.length());
        this.sb.append("<!ELEMENT " + element.getName());
        DTDElementContent content = element.getContent();
        if (content instanceof DTDPCDataContent || content instanceof DTDElementReferenceContent) {
            this.sb.append(" (");
            super.visitDTDElement(element);
            this.sb.append(")");
        } else {
            this.sb.append(" ");
            super.visitDTDElement(element);
        }
        this.endTag();
        this.updateEndOffset(element, this.sb.length() - 1);
        this.visitAttributes(element);
    }

    public void visitDTDParameterEntityReference(DTDParameterEntityReference parmEntity) {
        this.generateComment(parmEntity);
        this.updateStartOffset(parmEntity, this.sb.length());
        this.sb.append("%" + parmEntity.getName() + ";\n");
        this.updateEndOffset(parmEntity, this.sb.length() - 1);
    }

    public void visitDTDElementContent(DTDElementContent content) {
        int occurType;
        DTDRepeatableContent repeatContent;
        DTDOccurrenceType occurrenceType;
        this.updateStartOffset(content, this.sb.length());
        String trailingChars = "";
        if (content instanceof DTDRepeatableContent && (occurrenceType = (repeatContent = (DTDRepeatableContent)content).getOccurrence()) != null && (occurType = occurrenceType.getValue()) != 49) {
            if (repeatContent instanceof DTDEntityReferenceContent) {
                this.sb.append("(");
                trailingChars = ")";
            }
            trailingChars = String.valueOf(trailingChars) + (char)occurType;
        }
        if (content instanceof DTDGroupContent) {
            super.visitDTDElementContent(content);
        } else if (content instanceof DTDElementReferenceContent || content instanceof DTDEntityReferenceContent) {
            this.sb.append(((DTDRepeatableContent)content).unparseRepeatableContent());
        } else {
            this.sb.append(content.getContentName());
        }
        this.sb.append(trailingChars);
        this.updateEndOffset(content, this.sb.length());
    }

    public void visitDTDGroupContent(DTDGroupContent group) {
        this.sb.append("(");
        DTDGroupKind kind = group.getGroupKind();
        if (kind == null) {
            group.setGroupKind(DTDGroupKind.get(1));
        }
        String con = group.getGroupKind().getValue() == 2 ? " | " : ", ";
        EList content = group.getContent();
        if (content != null) {
            boolean firstContent = true;
            Iterator i = content.iterator();
            while (i.hasNext()) {
                if (!firstContent) {
                    this.sb.append(con);
                } else {
                    firstContent = false;
                }
                this.visitDTDElementContent((DTDElementContent)i.next());
            }
        }
        this.sb.append(")");
    }

    private void visitAttributes(DTDElement elem) {
        EList attrs = elem.getDTDAttribute();
        Iterator i = attrs.iterator();
        if (attrs != null && i.hasNext()) {
            DTDAttribute attrib = (DTDAttribute)i.next();
            String comment = attrib.getComment();
            if (comment != null && comment.length() > 0) {
                this.sb.append("<!--\n ").append(comment).append("\n-->\n");
            }
            this.sb.append("<!ATTLIST " + elem.getName() + "\n");
            this.sb.append(" ");
            this.updateStartOffset(attrib, this.sb.length());
            this.sb.append(attrib.unparse());
            this.updateEndOffset(attrib, this.sb.length());
            this.sb.append("\n");
            while (i.hasNext()) {
                attrib = (DTDAttribute)i.next();
                comment = attrib.getComment();
                if (comment != null && comment.length() > 0) {
                    this.sb.append(">\n");
                    if (comment != null && comment.length() > 0) {
                        this.sb.append("<!--\n ").append(comment).append("\n-->\n");
                    }
                    this.sb.append("<!ATTLIST " + elem.getName() + "\n");
                }
                this.sb.append(" ");
                this.updateStartOffset(attrib, this.sb.length());
                this.sb.append(attrib.unparse());
                this.updateEndOffset(attrib, this.sb.length());
                this.sb.append("\n");
            }
            this.sb.append(">\n");
        }
    }

    private void endTag() {
        this.sb.append(">\n");
    }

    private void updateStartOffset(DTDSourceOffset o, int offset) {
        if (this.updateOffset) {
            o.setStartOffset(offset);
        }
    }

    private void updateEndOffset(DTDSourceOffset o, int offset) {
        if (this.updateOffset) {
            o.setEndOffset(offset);
        }
    }

    private void generateComment(DTDObject dtdObject) {
        String commentString = null;
        if (dtdObject instanceof DTDElement) {
            commentString = ((DTDElement)dtdObject).getComment();
        } else if (dtdObject instanceof DTDEntity) {
            commentString = ((DTDEntity)dtdObject).getComment();
        } else if (dtdObject instanceof DTDNotation) {
            commentString = ((DTDNotation)dtdObject).getComment();
        }
        if (commentString != null && commentString.length() > 0) {
            this.sb.append("<!--").append(commentString).append("-->\n");
        }
    }
}

