/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalConditionalOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalIfElseOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalInfixOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;
import org.eclipse.jem.internal.proxy.remote.BeanProxyValueSender;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMExpressionConnection;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMCallbackThread;
import org.eclipse.jem.internal.proxy.remote.REMExpression;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

public class REMExpression
extends Expression {
    private IREMExpressionConnection connection;
    private boolean closed;
    protected Commands.ValueObject workerValue;
    protected Map beanTypeCache;
    protected Map methodsCache;
    protected Map fieldsCache;
    protected List pendingTransactions;
    private static final boolean EXECUTE_PENDING_IMMEDIATELY = false;
    private boolean sentData;
    protected static final String IO_EXCEPTION_MSG = ProxyRemoteMessages.REMExpression_IOExceptionSeeLog_INFO_;
    protected static final String COMMAND_EXCEPTION_MSG = ProxyRemoteMessages.REMExpression_CommandExceptionSeeLog_INFO_;
    private static final Object VOIDTYPE = new Object();
    private static final Object NOTRESOLVED = new Object();
    protected IBeanProxy expressionProcesserController;

    public REMExpression(REMProxyFactoryRegistry registry) {
        super((ProxyFactoryRegistry)registry);
    }

    protected int getREMExpressionID() {
        return ((Object)((Object)this)).hashCode();
    }

    protected List getPendingTransactions() {
        if (this.pendingTransactions == null) {
            this.pendingTransactions = new ArrayList();
        }
        return this.pendingTransactions;
    }

    protected void addPendingTransaction(PendingTransaction pending) {
        this.getPendingTransactions().add(pending);
    }

    protected boolean haveSentData() {
        return this.sentData;
    }

    protected IREMExpressionConnection getConnection() {
        if (this.connection == null) {
            if (!this.sentData) {
                this.getREMBeanProxyFactory().startTransaction();
            }
            this.sentData = true;
            this.connection = (IREMExpressionConnection)this.getREMRegistry().getFreeConnection();
            try {
                if (this.workerValue == null) {
                    this.workerValue = new Commands.ValueObject();
                }
                if (this.expressionProcesserController == null) {
                    byte trace = !this.isTraceSet() ? (byte)-1 : (this.isTrace() ? (byte)1 : 0);
                    this.connection.startExpressionProcessing(this.getREMExpressionID(), trace);
                } else {
                    this.fillProxy((IProxy)this.expressionProcesserController, this.workerValue);
                    this.connection.resumeExpression(this.getREMExpressionID(), this.workerValue);
                    this.expressionProcesserController = null;
                }
            }
            catch (IOException e) {
                this.connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                if (!e.isRecoverable()) {
                    this.connection.close();
                    this.connection = null;
                }
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
        return this.connection;
    }

    protected void throwIllegalStateException(String msg) throws IllegalStateException {
        throw new IllegalStateException(msg);
    }

    protected final REMProxyFactoryRegistry getREMRegistry() {
        return (REMProxyFactoryRegistry)this.registry;
    }

    protected final REMStandardBeanProxyFactory getREMBeanProxyFactory() {
        return (REMStandardBeanProxyFactory)this.beanProxyFactory;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processPendingTransactions() {
        if (this.pendingTransactions == null) return;
        if (this.pendingTransactions.isEmpty()) return;
        try {
            int i = 0;
            while (i < this.pendingTransactions.size()) {
                ((PendingTransaction)this.pendingTransactions.get(i)).pushTransaction(this);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.pendingTransactions.clear();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.pendingTransactions.clear();
            return;
        }
    }

    protected PendingTransaction getPendingEntryFromTop(int fromTop) {
        if (this.pendingTransactions != null && this.pendingTransactions.size() >= fromTop) {
            return (PendingTransaction)this.pendingTransactions.get(this.pendingTransactions.size() - fromTop);
        }
        return null;
    }

    protected void popPendingEntry(int fromTop) {
        if (this.pendingTransactions != null) {
            if (this.pendingTransactions.size() > fromTop) {
                while (fromTop-- > 0) {
                    this.pendingTransactions.remove(this.pendingTransactions.size() - 1);
                }
            } else {
                this.pendingTransactions.clear();
            }
        }
    }

    protected void pushToProxy(IProxy proxy) {
        if (proxy == null || proxy.isBeanProxy()) {
            this.pushToProxy((IBeanProxy)proxy);
        } else {
            this.pushToExpressionProxy((ExpressionProxy)proxy);
        }
    }

    private void pushToProxy(IBeanProxy proxy) {
        block5: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)12);
                if (proxy == null) {
                    this.workerValue.set();
                } else {
                    ((IREMBeanProxy)proxy).renderBean(this.workerValue);
                }
                connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeProxy() {
        if (!this.closed) {
            try {
                if (this.connection != null && this.connection.isConnected()) {
                    try {
                        try {
                            this.connection.stopExpressionProcessing(this.getREMExpressionID());
                        }
                        catch (IOException e) {
                            this.connection.close();
                            ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.INFO);
                        }
                        Object var2_4 = null;
                        this.getREMRegistry().returnConnection(this.connection);
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        this.getREMRegistry().returnConnection(this.connection);
                        throw throwable;
                    }
                }
                Object var4_7 = null;
                this.closed = true;
                if (this.sentData) {
                    this.getREMBeanProxyFactory().stopTransaction();
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.closed = true;
                if (this.sentData) {
                    this.getREMBeanProxyFactory().stopTransaction();
                }
                throw throwable;
            }
        }
        this.methodsCache = null;
        this.fieldsCache = null;
        this.beanTypeCache = null;
        this.pendingTransactions = null;
        this.connection = null;
    }

    private BeanProxyValueSender getExpressionProxiesSender() {
        return new BeanProxyValueSender(this.getREMBeanProxyFactory()){

            public void sendValue(Commands.ValueObject value) {
                if (value.getType() == 54) {
                    switch (value.anInt) {
                        case 1: {
                            this.array[this.index++] = NOTRESOLVED;
                            break;
                        }
                        case 0: {
                            this.array[this.index++] = VOIDTYPE;
                            break;
                        }
                    }
                } else {
                    super.sendValue(value);
                }
            }
        };
    }

    private void processpulledExpressionProxies(List expressionProxies, BeanProxyValueSender sender) {
        int len = expressionProxies.size();
        int j = 0;
        Object[] resolveds = sender.getArray();
        int i = 0;
        while (i < len) {
            ExpressionProxy ep = (ExpressionProxy)expressionProxies.get(i);
            if (ep != null) {
                Object resolved;
                if ((resolved = resolveds[j++]) == NOTRESOLVED) {
                    this.fireProxyNotResolved(ep);
                } else if (resolved == VOIDTYPE) {
                    this.fireProxyVoid(ep);
                } else {
                    this.fireProxyResolved(ep, (IBeanProxy)resolved);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBeanProxy pullProxyValue(int proxycount, List expressionProxies) throws ThrowableProxy, NoExpressionValueException {
        IREMExpressionConnection lclConnection;
        boolean processedExpressionProxies;
        block17: {
            IBeanProxy iBeanProxy;
            if (!this.haveSentData()) {
                this.markAllProxiesNotResolved(expressionProxies);
                return null;
            }
            processedExpressionProxies = false;
            lclConnection = this.getConnection();
            this.markInTransaction(lclConnection);
            try {
                try {
                    Commands.ValueObject proxyids = null;
                    BeanProxyValueSender sender = null;
                    if (proxycount > 0) {
                        proxyids = this.createExpressionProxiesValueObject(proxycount, expressionProxies);
                        sender = this.getExpressionProxiesSender();
                    }
                    lclConnection.pullValue(this.getREMExpressionID(), proxyids, sender);
                    if (proxycount > 0) {
                        this.processpulledExpressionProxies(expressionProxies, sender);
                    }
                    processedExpressionProxies = true;
                    lclConnection.getFinalValue(this.workerValue);
                    iBeanProxy = this.getREMBeanProxyFactory().getBeanProxy(this.workerValue);
                    Object var8_11 = null;
                    this.markEndTransaction(lclConnection);
                    if (processedExpressionProxies) return iBeanProxy;
                }
                catch (CommandErrorException e) {
                    try {
                        if (e.getErrorCode() == 9) {
                            ThrowableProxy t = null;
                            try {
                                this.getREMBeanProxyFactory().getBeanProxy(e.getValue());
                                throw new REMNoExpressionValueException(t);
                            }
                            catch (ThrowableProxy e1) {
                                t = e1;
                            }
                            throw new REMNoExpressionValueException(t);
                        }
                        this.getREMBeanProxyFactory().processErrorReturn(e);
                    }
                    catch (CommandException commandException) {
                        ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                        if (!e.isRecoverable()) {
                            lclConnection.close();
                            this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                        }
                        break block17;
                    }
                }
                catch (CommandException e) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                    if (!e.isRecoverable()) {
                        lclConnection.close();
                        this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.markEndTransaction(lclConnection);
                if (processedExpressionProxies) throw throwable;
                this.markAllProxiesNotResolved(expressionProxies);
                throw throwable;
            }
            this.markAllProxiesNotResolved(expressionProxies);
            return iBeanProxy;
        }
        Object var8_13 = null;
        this.markEndTransaction(lclConnection);
        if (processedExpressionProxies) return null;
        this.markAllProxiesNotResolved(expressionProxies);
        return null;
    }

    protected void markInTransaction(IREMExpressionConnection remConnection) {
        REMCallbackThread callbackThread;
        Thread thread = Thread.currentThread();
        if (thread instanceof REMCallbackThread && (callbackThread = (REMCallbackThread)thread).getConnection() == remConnection) {
            callbackThread.setIntransaction(true);
        }
    }

    protected void markEndTransaction(IREMExpressionConnection remConn) {
        REMCallbackThread callbackThread;
        Thread thread = Thread.currentThread();
        if (thread instanceof REMCallbackThread && (callbackThread = (REMCallbackThread)thread).getConnection() == remConn) {
            callbackThread.setIntransaction(false);
        }
    }

    private Commands.ValueObject createExpressionProxiesValueObject(int actualCount, List expressionProxies) {
        class ExpressionProxyRetriever
        implements Commands.ValueRetrieve {
            Iterator expressionProxiesItr;
            Commands.ValueObject worker;
            final /* synthetic */ REMExpression this$0;

            public ExpressionProxyRetriever(REMExpression rEMExpression, List expressionProxies) {
                this.this$0 = rEMExpression;
                this.worker = new Commands.ValueObject();
                this.expressionProxiesItr = expressionProxies.iterator();
            }

            public Commands.ValueObject nextValue() {
                this.worker.set(-1);
                while (this.expressionProxiesItr.hasNext()) {
                    E parm = this.expressionProxiesItr.next();
                    if (parm == null) continue;
                    this.worker.set(((ExpressionProxy)parm).getProxyID());
                    break;
                }
                return this.worker;
            }
        }
        this.workerValue.setArrayIDS((Commands.ValueRetrieve)new ExpressionProxyRetriever(this, expressionProxies), actualCount, 3);
        return this.workerValue;
    }

    protected void pushCastToProxy(IProxyBeanType type) {
        block3: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)4);
                this.fillProxy((IProxy)type, this.workerValue);
                connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void fillProxy(IProxy type, Commands.ValueObject value) throws IOException {
        if (type.isBeanProxy()) {
            ((IREMBeanProxy)type).renderBean(value);
        } else {
            ExpressionProxy ep = (ExpressionProxy)type;
            value.set(ep.getProxyID());
        }
    }

    protected void pushInstanceofToProxy(IProxyBeanType type) {
        block3: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)8);
                this.fillProxy((IProxy)type, this.workerValue);
                connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushInfixToProxy(InfixOperator operator, InternalInfixOperandType operandType) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)9);
            connection.pushByte((byte)operator.getValue());
            connection.pushByte((byte)operandType.getValue());
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushPrefixToProxy(PrefixOperator operator) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)11);
            connection.pushByte((byte)operator.getValue());
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushArrayAccessToProxy(int indexCount) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)1);
            connection.pushInt(indexCount);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushArrayCreationToProxy(IProxyBeanType type, int dimensionCount) {
        block3: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)2);
                this.fillProxy((IProxy)type, this.workerValue);
                connection.pushValueObject(this.workerValue);
                connection.pushInt(dimensionCount);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushArrayInitializerToProxy(IProxyBeanType type, int stripCount, int expressionCount) {
        block3: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)3);
                this.fillProxy((IProxy)type, this.workerValue);
                connection.pushValueObject(this.workerValue);
                connection.pushInt(stripCount);
                connection.pushInt(expressionCount);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushClassInstanceCreationToProxy(IProxyBeanType type, int argumentCount) {
        block3: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)6);
                this.fillProxy((IProxy)type, this.workerValue);
                connection.pushValueObject(this.workerValue);
                connection.pushInt(argumentCount);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushTypeReceiverToProxy(IProxyBeanType type) {
        block3: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)14);
                this.fillProxy((IProxy)type, this.workerValue);
                connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushFieldAccessToProxy(Object field, boolean hasReceiver) {
        block5: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)7);
                if (field instanceof String) {
                    this.workerValue.set((String)field);
                } else {
                    this.fillProxy((IProxy)field, this.workerValue);
                }
                connection.pushValueObject(this.workerValue);
                connection.pushBoolean(hasReceiver);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushMethodInvocationToProxy(Object method, boolean hasReceiver, int argCount) {
        block5: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)10);
                if (method instanceof String) {
                    this.workerValue.set((String)method);
                } else {
                    this.fillProxy((IProxy)method, this.workerValue);
                }
                connection.pushValueObject(this.workerValue);
                connection.pushBoolean(hasReceiver);
                connection.pushInt(argCount);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block5;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushConditionalToProxy(InternalConditionalOperandType expressionType) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)5);
            connection.pushByte((byte)expressionType.getValue());
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pushInvoke(int proxycount, List expressionProxies) throws ThrowableProxy, NoExpressionValueException {
        if (!this.haveSentData()) {
            this.markAllProxiesNotResolved(expressionProxies);
            return;
        }
        boolean processedExpressionProxies = false;
        IREMExpressionConnection lclConnection = this.getConnection();
        this.markInTransaction(lclConnection);
        try {
            try {
                Commands.ValueObject proxyids = null;
                BeanProxyValueSender sender = null;
                if (proxycount > 0) {
                    proxyids = this.createExpressionProxiesValueObject(proxycount, expressionProxies);
                    sender = this.getExpressionProxiesSender();
                }
                lclConnection.sync(this.getREMExpressionID(), proxyids, sender);
                if (proxycount > 0) {
                    this.processpulledExpressionProxies(expressionProxies, sender);
                }
                processedExpressionProxies = true;
                lclConnection.getFinalValue(this.workerValue);
            }
            catch (CommandErrorException e) {
                try {
                    if (e.getErrorCode() == 9) {
                        ThrowableProxy t = null;
                        try {
                            this.getREMBeanProxyFactory().getBeanProxy(e.getValue());
                            throw new REMNoExpressionValueException(t);
                        }
                        catch (ThrowableProxy e1) {
                            t = e1;
                        }
                        throw new REMNoExpressionValueException(t);
                    }
                    this.getREMBeanProxyFactory().processErrorReturn(e);
                }
                catch (CommandException commandException) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                    if (!e.isRecoverable()) {
                        lclConnection.close();
                        this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                    }
                }
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                if (!e.isRecoverable()) {
                    lclConnection.close();
                    this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.markEndTransaction(lclConnection);
            if (processedExpressionProxies) throw throwable;
            this.markAllProxiesNotResolved(expressionProxies);
            throw throwable;
        }
        {
            Object var8_13 = null;
            this.markEndTransaction(lclConnection);
            if (processedExpressionProxies) return;
        }
        this.markAllProxiesNotResolved(expressionProxies);
    }

    protected ExpressionProxy createExpressionProxy(int proxyType, int proxyID) {
        switch (proxyType) {
            default: {
                return new ExpressionProxy(proxyID, 0, (Expression)this);
            }
            case 1: {
                return new REMBeanTypeExpressionProxy(proxyID, this);
            }
            case 2: {
                return new REMMethodExpressionProxy(proxyID, this);
            }
            case 3: 
        }
        return new REMFieldExpressionProxy(proxyID, this);
    }

    protected void pushAssignmentToProxy(ExpressionProxy proxy) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)15);
            connection.pushInt(proxy.getProxyID());
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushAssignmentToProxy() {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)17);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    private void pushToExpressionProxy(ExpressionProxy proxy) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)16);
            connection.pushInt(proxy.getProxyID());
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushBlockBeginToProxy(int blockNumber) {
        this.addPendingTransaction(new BlockBegin(blockNumber));
    }

    protected void pushBlockEndToProxy(int blockNumber) {
        PendingTransaction topEntry = this.getPendingEntryFromTop(1);
        if (topEntry instanceof BlockBreak && ((BlockBreak)topEntry).blockNumber == blockNumber) {
            this.popPendingEntry(1);
            topEntry = this.getPendingEntryFromTop(1);
        }
        if (topEntry instanceof BlockBegin && ((BlockBegin)topEntry).blockNumber == blockNumber) {
            this.popPendingEntry(1);
            return;
        }
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)20);
            connection.pushInt(blockNumber);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushBlockBreakToProxy(int blockNumber) {
        this.addPendingTransaction(new BlockBreak(blockNumber));
    }

    protected void pushTryBeginToProxy(int tryNumber) {
        this.addPendingTransaction(new TryBegin(tryNumber));
    }

    protected void pushTryCatchClauseToProxy(int tryNumber, IProxyBeanType exceptionType, ExpressionProxy ep) {
        this.addPendingTransaction(new TryCatch(tryNumber, exceptionType, ep));
    }

    protected void pushTryFinallyClauseToProxy(int tryNumber) {
        this.addPendingTransaction(new TryFinally(tryNumber));
    }

    protected void pushTryEndToProxy(int tryNumber) {
        block5: {
            PendingTransaction topEntry;
            int fromTop;
            block6: {
                fromTop = 0;
                while (true) {
                    if ((topEntry = this.getPendingEntryFromTop(++fromTop)) instanceof TryFinally) {
                        if (((TryFinally)topEntry).tryNumber == tryNumber) continue;
                        break block5;
                    }
                    if (!(topEntry instanceof TryCatch)) break block6;
                    if (((TryCatch)topEntry).tryNumber != tryNumber) break;
                }
                break block5;
            }
            if (topEntry instanceof TryBegin && ((TryBegin)topEntry).tryNumber == tryNumber) {
                this.popPendingEntry(fromTop);
                return;
            }
        }
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)24);
            connection.pushInt(tryNumber);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushThrowToProxy() {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)25);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushRethrowToProxy(int tryNumber) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)26);
            connection.pushInt(tryNumber);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushBeanTypeToProxy(IBeanTypeExpressionProxy proxy) {
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)13);
            REMBeanTypeExpressionProxy ep = (REMBeanTypeExpressionProxy)proxy;
            connection.pushInt(ep.getProxyID());
            connection.pushString(ep.getTypeName());
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushMethodToProxy(ExpressionProxy proxy, IProxyBeanType declaringType, String methodName, IProxyBeanType[] parameterTypes) {
        block6: {
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)27);
                connection.pushInt(proxy.getProxyID());
                this.fillProxy((IProxy)declaringType, this.workerValue);
                connection.pushValueObject(this.workerValue);
                connection.pushString(methodName);
                if (parameterTypes == null || parameterTypes.length == 0) {
                    connection.pushInt(0);
                } else {
                    connection.pushInt(parameterTypes.length);
                    int i = 0;
                    while (i < parameterTypes.length) {
                        this.fillProxy((IProxy)parameterTypes[i], this.workerValue);
                        connection.pushValueObject(this.workerValue);
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block6;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushFieldToProxy(ExpressionProxy proxy, IProxyBeanType declaringType, String fieldName) {
        block3: {
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)28);
                connection.pushInt(proxy.getProxyID());
                this.fillProxy((IProxy)declaringType, this.workerValue);
                connection.pushValueObject(this.workerValue);
                connection.pushString(fieldName);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    public Map getMethods(IProxyBeanType beanType) {
        HashMap methods;
        if (this.methodsCache == null) {
            this.methodsCache = new HashMap();
        }
        if ((methods = (HashMap)this.methodsCache.get(beanType.getTypeName())) == null) {
            methods = new HashMap(20);
            this.methodsCache.put(beanType.getTypeName(), methods);
        }
        return methods;
    }

    public Map getFields(IProxyBeanType beanType) {
        HashMap fields;
        if (this.fieldsCache == null) {
            this.fieldsCache = new HashMap();
        }
        if ((fields = (HashMap)this.fieldsCache.get(beanType.getTypeName())) == null) {
            fields = new HashMap(20);
            this.fieldsCache.put(beanType.getTypeName(), fields);
        }
        return fields;
    }

    public IProxyBeanType getBeanType(String beanTypeName) {
        if (this.beanTypeCache == null) {
            this.beanTypeCache = new HashMap();
        }
        return (IProxyBeanType)this.beanTypeCache.get(beanTypeName);
    }

    public void addBeanType(String beanTypeName, IProxyBeanType beantype) {
        this.beanTypeCache.put(beanTypeName, beantype);
    }

    public void removeBeanType(String beanTypeName) {
        this.beanTypeCache.remove(beanTypeName);
    }

    protected void pushIfTestToProxy() {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)30);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushIfElseToProxy(InternalIfElseOperandType clauseType) {
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)29);
            connection.pushByte((byte)clauseType.getValue());
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected void pushNewInstanceToProxy(String initializationString, IProxyBeanType resultType) {
        block3: {
            this.processPendingTransactions();
            IREMExpressionConnection connection = this.getConnection();
            try {
                connection.pushExpressionCommand(this.getREMExpressionID(), (byte)31);
                connection.pushString(initializationString);
                this.fillProxy((IProxy)resultType, this.workerValue);
                connection.pushValueObject(this.workerValue);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                this.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                this.markInvalid(e.getLocalizedMessage());
                if (e.isRecoverable()) break block3;
                connection.close();
                this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
            }
        }
    }

    protected void pushMarkToProxy(int markID) {
        this.addPendingTransaction(new Mark(markID));
    }

    protected void pushEndmarkToProxy(int markID, boolean restore) {
        PendingTransaction topEntry = this.getPendingEntryFromTop(1);
        if (topEntry instanceof Mark && ((Mark)topEntry).markID == markID) {
            this.popPendingEntry(1);
            return;
        }
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)33);
            connection.pushInt(markID);
            connection.pushBoolean(restore);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pushBeginTransferThreadToProxy() throws ThrowableProxy {
        if (this.connection == null) return;
        if (this.expressionProcesserController != null) return;
        IREMExpressionConnection lclConnection = this.getConnection();
        this.markInTransaction(lclConnection);
        try {
            try {
                this.workerValue.set();
                lclConnection.transferExpression(this.getREMExpressionID(), this.workerValue);
                this.expressionProcesserController = this.getREMBeanProxyFactory().getBeanProxy(this.workerValue);
                this.getREMRegistry().returnConnection(lclConnection);
                this.connection = null;
            }
            catch (CommandException e) {
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                if (!e.isRecoverable()) {
                    lclConnection.close();
                    this.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.markEndTransaction(lclConnection);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.markEndTransaction(lclConnection);
            return;
        }
    }

    protected void pushTransferThreadToProxy() {
    }

    protected void pushSubexpressionBeginToProxy(int subexpressionNumber) {
        this.addPendingTransaction(new SubexpressionBegin(subexpressionNumber));
    }

    protected void pushSubexpressionEndToProxy(int subexpressionNumber) {
        PendingTransaction topEntry = this.getPendingEntryFromTop(1);
        if (topEntry instanceof SubexpressionBegin && ((SubexpressionBegin)topEntry).subexpressionNumber == subexpressionNumber) {
            this.popPendingEntry(1);
            topEntry = this.getPendingEntryFromTop(1);
        }
        this.processPendingTransactions();
        IREMExpressionConnection connection = this.getConnection();
        try {
            connection.pushExpressionCommand(this.getREMExpressionID(), (byte)35);
            connection.pushInt(subexpressionNumber);
        }
        catch (IOException e) {
            connection.close();
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
            this.markInvalid(e.getLocalizedMessage());
            this.throwIllegalStateException(IO_EXCEPTION_MSG);
        }
    }

    protected static abstract class PendingTransaction {
        protected PendingTransaction() {
        }

        public abstract void pushTransaction(REMExpression var1);
    }

    private static class REMNoExpressionValueException
    extends NoExpressionValueException {
        private static final long serialVersionUID = 1692406777391812694L;

        public REMNoExpressionValueException(ThrowableProxy e) {
            super((Throwable)e);
        }

        public String getLocalizedMessage() {
            return ((ThrowableProxy)this.getCause()).getProxyLocalizedMessage();
        }

        public String getMessage() {
            return ((ThrowableProxy)this.getCause()).getProxyMessage();
        }

        public void printStackTrace() {
            this.getCause().printStackTrace();
        }

        public void printStackTrace(PrintStream s) {
            this.getCause().printStackTrace(s);
        }

        public void printStackTrace(PrintWriter s) {
            this.getCause().printStackTrace(s);
        }
    }

    private static class REMBeanTypeExpressionProxy
    extends ExpressionProxy
    implements IBeanTypeExpressionProxy {
        private String typeName;

        REMBeanTypeExpressionProxy(int proxyid, Expression expression) {
            super(proxyid, 1, expression);
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " - " + this.getTypeName();
        }

        public IProxyMethod getMethodProxy(IExpression expression, String methodName, IProxyBeanType[] parameterTypes) {
            REMProxyFactoryRegistry registry = (REMProxyFactoryRegistry)expression.getRegistry();
            return ((REMMethodProxyFactory)registry.getMethodProxyFactory()).getMethodProxy(expression, (IProxyBeanType)this, methodName, parameterTypes);
        }

        public IProxyMethod getMethodProxy(IExpression expression, String methodName, String[] parameterTypes) {
            REMProxyFactoryRegistry registry = (REMProxyFactoryRegistry)expression.getRegistry();
            return ((REMMethodProxyFactory)registry.getMethodProxyFactory()).getMethodProxy(expression, (IProxyBeanType)this, methodName, parameterTypes);
        }

        public IProxyMethod getMethodProxy(IExpression expression, String methodName) {
            return this.getMethodProxy(expression, methodName, (IProxyBeanType[])null);
        }

        public IProxyField getFieldProxy(IExpression expression, String fieldName) {
            REMProxyFactoryRegistry registry = (REMProxyFactoryRegistry)expression.getRegistry();
            return ((REMMethodProxyFactory)registry.getMethodProxyFactory()).getFieldProxy(expression, (IProxyBeanType)this, fieldName);
        }
    }

    private static class REMMethodExpressionProxy
    extends ExpressionProxy
    implements IProxyMethod {
        REMMethodExpressionProxy(int proxyid, Expression expression) {
            super(proxyid, 2, expression);
        }
    }

    private static class REMFieldExpressionProxy
    extends ExpressionProxy
    implements IProxyField {
        REMFieldExpressionProxy(int proxyid, Expression expression) {
            super(proxyid, 3, expression);
        }
    }

    private static class BlockBegin
    extends PendingTransaction {
        public int blockNumber;

        public BlockBegin(int blockNumber) {
            this.blockNumber = blockNumber;
        }

        public void pushTransaction(REMExpression remExpression) {
            IREMExpressionConnection connection = remExpression.getConnection();
            try {
                connection.pushExpressionCommand(remExpression.getREMExpressionID(), (byte)18);
                connection.pushInt(this.blockNumber);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                remExpression.markInvalid(e.getLocalizedMessage());
                remExpression.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
        }
    }

    private static class BlockBreak
    extends PendingTransaction {
        public int blockNumber;

        public BlockBreak(int blockNumber) {
            this.blockNumber = blockNumber;
        }

        public void pushTransaction(REMExpression remExpression) {
            IREMExpressionConnection connection = remExpression.getConnection();
            try {
                connection.pushExpressionCommand(remExpression.getREMExpressionID(), (byte)19);
                connection.pushInt(this.blockNumber);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                remExpression.markInvalid(e.getLocalizedMessage());
                remExpression.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
        }
    }

    private static class TryBegin
    extends PendingTransaction {
        public final int tryNumber;

        public TryBegin(int tryNumber) {
            this.tryNumber = tryNumber;
        }

        public void pushTransaction(REMExpression remExpression) {
            IREMExpressionConnection connection = remExpression.getConnection();
            try {
                connection.pushExpressionCommand(remExpression.getREMExpressionID(), (byte)21);
                connection.pushInt(this.tryNumber);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                remExpression.markInvalid(e.getLocalizedMessage());
                remExpression.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
        }
    }

    private static class TryCatch
    extends PendingTransaction {
        public final int tryNumber;
        private final IProxyBeanType exceptionType;
        private final ExpressionProxy ep;

        public TryCatch(int tryNumber, IProxyBeanType exceptionType, ExpressionProxy ep) {
            this.tryNumber = tryNumber;
            this.exceptionType = exceptionType;
            this.ep = ep;
        }

        public void pushTransaction(REMExpression remExpression) {
            block5: {
                IREMExpressionConnection connection = remExpression.getConnection();
                try {
                    connection.pushExpressionCommand(remExpression.getREMExpressionID(), (byte)22);
                    connection.pushInt(this.tryNumber);
                    remExpression.fillProxy((IProxy)this.exceptionType, remExpression.workerValue);
                    connection.pushValueObject(remExpression.workerValue);
                    if (this.ep != null) {
                        connection.pushInt(this.ep.getProxyID());
                    } else {
                        connection.pushInt(-1);
                    }
                }
                catch (IOException e) {
                    connection.close();
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                    remExpression.markInvalid(e.getLocalizedMessage());
                    remExpression.throwIllegalStateException(IO_EXCEPTION_MSG);
                }
                catch (CommandException e) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                    remExpression.markInvalid(e.getLocalizedMessage());
                    if (e.isRecoverable()) break block5;
                    connection.close();
                    remExpression.throwIllegalStateException(COMMAND_EXCEPTION_MSG);
                }
            }
        }
    }

    private static class TryFinally
    extends PendingTransaction {
        public final int tryNumber;

        public TryFinally(int tryNumber) {
            this.tryNumber = tryNumber;
        }

        public void pushTransaction(REMExpression remExpression) {
            IREMExpressionConnection connection = remExpression.getConnection();
            try {
                connection.pushExpressionCommand(remExpression.getREMExpressionID(), (byte)23);
                connection.pushInt(this.tryNumber);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                remExpression.markInvalid(e.getLocalizedMessage());
                remExpression.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
        }
    }

    private static class Mark
    extends PendingTransaction {
        public int markID;

        public Mark(int markID) {
            this.markID = markID;
        }

        public void pushTransaction(REMExpression remExpression) {
            IREMExpressionConnection connection = remExpression.getConnection();
            try {
                connection.pushExpressionCommand(remExpression.getREMExpressionID(), (byte)32);
                connection.pushInt(this.markID);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                remExpression.markInvalid(e.getLocalizedMessage());
                remExpression.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
        }
    }

    private static class SubexpressionBegin
    extends PendingTransaction {
        public int subexpressionNumber;

        public SubexpressionBegin(int subexpressionNumber) {
            this.subexpressionNumber = subexpressionNumber;
        }

        public void pushTransaction(REMExpression remExpression) {
            IREMExpressionConnection connection = remExpression.getConnection();
            try {
                connection.pushExpressionCommand(remExpression.getREMExpressionID(), (byte)34);
                connection.pushInt(this.subexpressionNumber);
            }
            catch (IOException e) {
                connection.close();
                ProxyPlugin.getPlugin().getLogger().log((Throwable)e);
                remExpression.markInvalid(e.getLocalizedMessage());
                remExpression.throwIllegalStateException(IO_EXCEPTION_MSG);
            }
        }
    }
}

