/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDElementDeclarationCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDTypeDefinitionCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.widgets.NewComponentDialog;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetNewComponentAction
extends AddElementAction {
    Object input;
    protected IEditorPart editorPart;
    protected String kind;
    private String typeKind = "complex";
    private WSDLElementCommand command;
    private String newDialogTitle = WSDLEditorPlugin.getWSDLString("_UI_LABEL_NEW_COMPONENT");

    public SetNewComponentAction(String text, Node parentNode, String prefix, String localName, Object input) {
        super(text, parentNode, prefix, localName);
        this.input = input;
    }

    public void setEditor(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public void setReferenceKind(String kind) {
        this.kind = kind;
    }

    public void setTypeKind(String typeKind) {
        this.typeKind = typeKind;
    }

    protected void performAddElement() {
        String defaultName;
        Shell shell = Display.getCurrent().getActiveShell();
        NewComponentDialog dialog = new NewComponentDialog(shell, this.newDialogTitle, defaultName = this.getDefaultName(), this.getUsedNames());
        int dialogCode = dialog.createAndOpen();
        if (dialogCode == 0) {
            Definition definition;
            if (this.input instanceof Port) {
                definition = ((Port)this.input).getEnclosingDefinition();
                String newName = dialog.getName();
                BindingGenerator bindingGenerator = new BindingGenerator(definition, null, "http://schemas.xmlsoap.org/wsdl/soap/");
                bindingGenerator.setName(newName);
                bindingGenerator.generateBinding();
                String itemPrefix = definition.getPrefix(definition.getTargetNamespace());
                if (itemPrefix == null) {
                    itemPrefix = "";
                }
                Element wsdlElement = WSDLEditorUtil.getInstance().getElementForObject((WSDLElement)this.input);
                wsdlElement.setAttribute("binding", itemPrefix.length() == 0 ? newName : String.valueOf(itemPrefix) + ":" + newName);
            } else if (this.input instanceof Binding) {
                String portTypeValue;
                definition = ((Binding)this.input).getEnclosingDefinition();
                Element definitionElement = WSDLEditorUtil.getInstance().getElementForObject(definition);
                String newName = dialog.getName();
                String prefix = definitionElement.getPrefix();
                AddElementAction addPortTypeAction = new AddElementAction("", "icons/message_obj.gif", definitionElement, prefix, "portType");
                addPortTypeAction.setComputeTopLevelRefChild(true);
                addPortTypeAction.run();
                Element newMessage = addPortTypeAction.getNewElement();
                newMessage.setAttribute("name", newName);
                String itemPrefix = definition.getPrefix(definition.getTargetNamespace());
                if (itemPrefix == null) {
                    itemPrefix = "";
                }
                String string = portTypeValue = itemPrefix.length() == 0 ? newName : String.valueOf(itemPrefix) + ":" + newName;
                if (this.input != null && portTypeValue != null) {
                    Element wsdlElement = WSDLEditorUtil.getInstance().getElementForObject((WSDLElement)this.input);
                    wsdlElement.setAttribute("type", portTypeValue);
                }
            } else if (this.input instanceof Input || this.input instanceof Output || this.input instanceof Fault) {
                definition = ((MessageReference)this.input).getEnclosingDefinition();
                String newName = dialog.getName();
                AddMessageCommand action = new AddMessageCommand(definition, newName);
                action.run();
                Message message = (Message)action.getWSDLElement();
                CreateWSDLElementHelper.PART_TYPE_OR_DEFINITION = CreateWSDLElementHelper.getPartInfo((WSDLElement)message);
                CreateWSDLElementHelper.createPart(message);
                String itemPrefix = definition.getPrefix(definition.getTargetNamespace());
                if (itemPrefix == null) {
                    itemPrefix = "";
                }
                Element wsdlElement = WSDLEditorUtil.getInstance().getElementForObject((WSDLElement)this.input);
                wsdlElement.setAttribute("message", itemPrefix.length() == 0 ? newName : String.valueOf(itemPrefix) + ":" + newName);
            } else if (this.input instanceof Part) {
                definition = ((Part)this.input).getEnclosingDefinition();
                String referencingPrefix = definition.getPrefix(definition.getTargetNamespace());
                String newName = dialog.getName();
                if (this.kind.equalsIgnoreCase("type")) {
                    if (this.typeKind.equalsIgnoreCase("complex")) {
                        ((AddXSDTypeDefinitionCommand)this.command).isComplexType(true);
                    } else {
                        ((AddXSDTypeDefinitionCommand)this.command).isComplexType(false);
                    }
                    ((AddXSDTypeDefinitionCommand)this.command).run(newName);
                    ComponentReferenceUtil.setComponentReference((Part)this.input, true, referencingPrefix.equals("") ? newName : String.valueOf(referencingPrefix) + ":" + newName);
                } else if (this.kind.equalsIgnoreCase("element")) {
                    ((AddXSDElementDeclarationCommand)this.command).run(newName);
                    ComponentReferenceUtil.setComponentReference((Part)this.input, false, referencingPrefix.equals("") ? newName : String.valueOf(referencingPrefix) + ":" + newName);
                }
            }
            WSDLEditor editor = (WSDLEditor)this.editorPart;
            editor.getSelectionManager().setSelection((ISelection)new StructuredSelection(this.input));
        }
    }

    private List getUsedNames() {
        if (this.input instanceof Port) {
            Definition definition = ((Port)this.input).getEnclosingDefinition();
            return NameUtil.getUsedBindingNames(definition);
        }
        if (this.input instanceof Binding) {
            Definition definition = ((Binding)this.input).getEnclosingDefinition();
            return NameUtil.getUsedPortTypeNames(definition);
        }
        if (this.input instanceof Input || this.input instanceof Output || this.input instanceof Fault) {
            Definition definition = ((MessageReference)this.input).getEnclosingDefinition();
            return NameUtil.getUsedMessageNames(definition);
        }
        if (this.input instanceof Part) {
            Definition definition = ((Part)this.input).getEnclosingDefinition();
            if (this.kind.equalsIgnoreCase("element")) {
                if (this.command == null) {
                    this.command = new AddXSDElementDeclarationCommand(definition, "NewElement");
                }
                XSDSchema parentSchema = ((AddXSDElementDeclarationCommand)this.command).getSchema();
                return this.getUsedElementNames(parentSchema);
            }
            if (this.kind.equalsIgnoreCase("type")) {
                if (this.command == null) {
                    this.command = new AddXSDTypeDefinitionCommand(definition, "NewType");
                }
                XSDSchema parentSchema = ((AddXSDTypeDefinitionCommand)this.command).getSchema();
                List usedNames = this.typeKind.equalsIgnoreCase("complex") ? this.getUsedComplexTypeNames(parentSchema) : this.getUsedSimpleTypeNames(parentSchema);
                return usedNames;
            }
        }
        return new ArrayList();
    }

    private String getDefaultName() {
        if (this.input instanceof Port) {
            this.newDialogTitle = WSDLEditorPlugin.getWSDLString("_UI_LABEL_NEW_BINDING");
            Definition def = ((Port)this.input).getEnclosingDefinition();
            return NameUtil.getUniqueNameHelper("NewBinding", NameUtil.getUsedBindingNames(def));
        }
        if (this.input instanceof Binding) {
            this.newDialogTitle = WSDLEditorPlugin.getWSDLString("_UI_LABEL_NEW_PORTTYPE");
            Definition def = ((Binding)this.input).getEnclosingDefinition();
            return NameUtil.getUniqueNameHelper("NewPortType", NameUtil.getUsedPortTypeNames(def));
        }
        if (this.input instanceof Input || this.input instanceof Output || this.input instanceof Fault) {
            this.newDialogTitle = WSDLEditorPlugin.getWSDLString("_UI_LABEL_NEW_MESSAGE");
            Definition def = ((MessageReference)this.input).getEnclosingDefinition();
            return NameUtil.getUniqueNameHelper("NewMessage", NameUtil.getUsedMessageNames(def));
        }
        if (this.input instanceof Part) {
            Definition def = ((Part)this.input).getEnclosingDefinition();
            if (this.kind.equalsIgnoreCase("element")) {
                this.newDialogTitle = WSDLEditorPlugin.getWSDLString("_UI_LABEL_NEW_ELEMENT");
                if (this.command == null) {
                    this.command = new AddXSDElementDeclarationCommand(def, "NewElement");
                }
                XSDSchema parentSchema = ((AddXSDElementDeclarationCommand)this.command).getSchema();
                List usedNames = this.getUsedElementNames(parentSchema);
                return NameUtil.getUniqueNameHelper("NewElement", usedNames);
            }
            if (this.kind.equalsIgnoreCase("type")) {
                if (this.command == null) {
                    this.command = new AddXSDTypeDefinitionCommand(def, "NewType");
                }
                XSDSchema parentSchema = ((AddXSDTypeDefinitionCommand)this.command).getSchema();
                String newItemName = "NewComplexType";
                List usedNames = null;
                if (this.typeKind.equalsIgnoreCase("complex")) {
                    this.newDialogTitle = WSDLEditorPlugin.getWSDLString("_UI_LABEL_NEW_COMPLEX_TYPE");
                    usedNames = this.getUsedComplexTypeNames(parentSchema);
                } else {
                    this.newDialogTitle = WSDLEditorPlugin.getWSDLString("_UI_LABEL_NEW_SIMPLE_TYPE");
                    usedNames = this.getUsedSimpleTypeNames(parentSchema);
                    newItemName = "NewSimpleType";
                }
                newItemName = NameUtil.getUniqueNameHelper(newItemName, usedNames);
                return newItemName;
            }
        }
        return "NewComponent";
    }

    private List getUsedSimpleTypeNames(XSDSchema schema) {
        ArrayList<String> namesList = new ArrayList<String>();
        Iterator typesIt = schema.getTypeDefinitions().iterator();
        while (typesIt.hasNext()) {
            XSDTypeDefinition type = (XSDTypeDefinition)typesIt.next();
            if (!(type instanceof XSDSimpleTypeDefinition)) continue;
            namesList.add(type.getName());
        }
        return namesList;
    }

    private List getUsedComplexTypeNames(XSDSchema schema) {
        ArrayList<String> namesList = new ArrayList<String>();
        Iterator typesIt = schema.getTypeDefinitions().iterator();
        while (typesIt.hasNext()) {
            XSDTypeDefinition type = (XSDTypeDefinition)typesIt.next();
            if (!(type instanceof XSDComplexTypeDefinition)) continue;
            namesList.add(type.getName());
        }
        return namesList;
    }

    private List getUsedElementNames(XSDSchema schema) {
        ArrayList<String> namesList = new ArrayList<String>();
        Iterator elementsIt = schema.getElementDeclarations().iterator();
        while (elementsIt.hasNext()) {
            XSDElementDeclaration element = (XSDElementDeclaration)elementsIt.next();
            namesList.add(element.getName());
        }
        return namesList;
    }
}

