/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.util.XMLQuickScan;
import org.eclipse.wst.wsdl.ui.internal.viewers.BaseViewer;
import org.w3c.dom.Element;

public class ImportViewer
extends BaseViewer
implements ModelAdapterListener {
    protected Composite control;
    protected IEditorPart editorPart;
    protected Text namespaceText;
    protected Text prefixText;
    protected Text locationText;
    Button selectButton;

    public ImportViewer(Composite parent, IEditorPart editorPart) {
        super(ImportViewer.getStatusLineManager(editorPart));
        this.editorPart = editorPart;
        this.createControl(parent);
    }

    protected String getHeadingText() {
        return WSDLEditorPlugin.getWSDLString("_UI_LABEL_IMPORT");
    }

    public void createControl(Composite parent) {
        this.control = this.flatViewUtility.createComposite(parent, 1, true);
        GridLayout layout = (GridLayout)this.control.getLayout();
        layout.verticalSpacing = 0;
        this.flatViewUtility.createFlatPageHeader(this.control, this.getHeadingText());
        Composite c = this.flatViewUtility.createComposite(this.control, 1, true);
        Label bogus = this.flatViewUtility.createLabel(c, 0, "");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        bogus.setLayoutData((Object)gd);
        Composite composite = this.flatViewUtility.createComposite(c, 2, true);
        GridLayout layout2 = new GridLayout();
        layout2.makeColumnsEqualWidth = false;
        layout2.numColumns = 3;
        layout2.marginHeight = 3;
        composite.setLayout((Layout)layout2);
        this.flatViewUtility.createLabel(composite, 0, WSDLEditorPlugin.getWSDLString("_UI_LABEL_NAMESPACE"));
        this.namespaceText = this.flatViewUtility.createTextField(composite);
        this.namespaceText.setEnabled(false);
        Label con = this.flatViewUtility.createLabel(composite, 0, "");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        con.setLayoutData((Object)gd);
        this.flatViewUtility.createLabel(composite, 0, WSDLEditorPlugin.getWSDLString("_UI_LABEL_PREFIX"));
        this.prefixText = this.flatViewUtility.createTextField(composite);
        this.prefixText.addListener(24, (Listener)this);
        this.prefixText.setEnabled(false);
        Label con2 = this.flatViewUtility.createLabel(composite, 0, "");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        con2.setLayoutData((Object)gd);
        this.flatViewUtility.createLabel(composite, 0, WSDLEditorPlugin.getWSDLString("_UI_LABEL_LOCATION"));
        this.locationText = this.flatViewUtility.createTextField(composite);
        this.locationText.setEnabled(false);
        this.selectButton = this.flatViewUtility.createPushButton(composite, "...");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        this.selectButton.setLayoutData((Object)gd);
        this.selectButton.addSelectionListener((SelectionListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSetInput(Object input) {
        this.setListenerEnabled(false);
        try {
            WSDLEditorUtil.getInstance().getNodeForObject(input);
            this.update();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setListenerEnabled(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.setListenerEnabled(true);
        if (oldInput != null) {
            WSDLModelAdapterFactory.getWSDLModelAdapterFactory();
            WSDLModelAdapterFactory.removeModelAdapterListener(oldInput, this);
        }
        WSDLModelAdapterFactory.getWSDLModelAdapterFactory();
        WSDLModelAdapterFactory.addModelAdapterListener(input, this);
        oldInput = input;
    }

    protected void handleEventHelper(Element element, Event event) {
        int cfr_ignored_0 = event.type;
    }

    protected void update() {
        Element element = ((WSDLElement)this.input).getElement();
        this.flatViewUtility.updateFlatPageHeaderTitle(this.getHeadingText());
        this.prefixText.setText("");
        this.locationText.setText("");
        this.namespaceText.setText("                                                                  ");
        this.namespaceText.getParent().layout();
        this.namespaceText.setText("");
        String locationValue = element.getAttribute("location");
        this.locationText.setText(locationValue != null ? locationValue : "");
        String namespaceValue = element.getAttribute("namespace");
        this.namespaceText.setText(namespaceValue != null ? namespaceValue : "");
        String prefix = ((Import)this.input).getEnclosingDefinition().getPrefix(namespaceValue);
        this.prefixText.setText(prefix != null ? prefix : "");
    }

    public Control getControl() {
        return this.control;
    }

    public void doHandleEvent(Event event) {
    }

    public void propertyChanged(Object object, String property) {
        if (this.isListenerEnabled()) {
            this.setListenerEnabled(false);
            this.update();
            this.setListenerEnabled(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.selectButton) {
            ((EObject)this.input).eResource().getResourceSet();
            WSDLEditor editor = (WSDLEditor)this.editorPart;
            IFile currentWSDLFile = ((IFileEditorInput)editor.getEditorInput()).getFile();
            SelectSingleFileDialog dialog = new SelectSingleFileDialog(WSDLEditorPlugin.getShell(), null, true);
            String[] filters = new String[]{"xsd", "wsdl"};
            IFile[] excludedFiles = new IFile[]{currentWSDLFile};
            dialog.addFilterExtensions(filters, excludedFiles);
            dialog.create();
            dialog.getShell().setText(WSDLEditorPlugin.getWSDLString("_UI_TITLE_SELECT"));
            dialog.setTitle(WSDLEditorPlugin.getWSDLString("_UI_TITLE_SELECT_FILE"));
            dialog.setMessage(WSDLEditorPlugin.getWSDLString("_UI_DESCRIPTION_SELECT_WSDL_OR_XSD"));
            int rc = dialog.open();
            if (rc == 0) {
                IFile selectedFile = dialog.getFile();
                String location = ComponentReferenceUtil.computeRelativeURI(selectedFile, currentWSDLFile, true);
                Import importObj = (Import)this.input;
                Element importElement = WSDLEditorUtil.getInstance().getElementForObject(importObj);
                Definition definition = importObj.getEnclosingDefinition();
                Element definitionElement = WSDLEditorUtil.getInstance().getElementForObject(definition);
                String importTargetNamespace = "";
                String prefix = this.prefixText.getText();
                String uniquePrefix = "";
                URI uri = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString());
                importTargetNamespace = XMLQuickScan.getTargetNamespaceURIForSchema(uri.toString());
                uniquePrefix = prefix.trim().equals("") ? this.getUniquePrefix(definition, uri.fileExtension()) : prefix;
                if (importTargetNamespace == null || importTargetNamespace != null && importTargetNamespace.trim().length() == 0) {
                    return;
                }
                importElement.setAttribute("location", location);
                importElement.setAttribute("namespace", importTargetNamespace);
                definitionElement.setAttribute("xmlns:" + uniquePrefix, importTargetNamespace);
                this.namespaceText.setText(importTargetNamespace);
                this.locationText.setText(location);
                this.prefixText.setText(uniquePrefix);
            }
        }
    }

    private String getUniquePrefix(Definition definition, String initPrefix) {
        String uniquePrefix;
        Map map = definition.getNamespaces();
        if (definition.getNamespace(initPrefix) == null) {
            uniquePrefix = initPrefix;
        } else {
            String tempPrefix = initPrefix;
            int i = 1;
            while (map.containsKey(String.valueOf(tempPrefix) + i)) {
                ++i;
            }
            uniquePrefix = String.valueOf(tempPrefix) + i;
        }
        return uniquePrefix;
    }
}

